/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.animation;

import edu.umd.cs.jazz.animation.ZAnimation;
import edu.umd.cs.jazz.component.ZFillPaint;
import edu.umd.cs.jazz.component.ZPenPaint;
import java.awt.Color;

public class ZColorAnimation
extends ZAnimation {
    private Color fSource;
    private Color fDestination;
    private ZFillPaint fFillPaintTarget;
    private ZPenPaint fPenPaintTarget;

    public ZColorAnimation(Color aSource, Color aDestination) {
        this.fSource = aSource;
        this.fDestination = aDestination;
    }

    public Color getSourceColor() {
        return this.fSource;
    }

    public void setSourceColor(Color aSource) {
        this.fSource = aSource;
    }

    public Color getDestinationColor() {
        return this.fDestination;
    }

    public void setDestinationColor(Color aDestination) {
        this.fDestination = aDestination;
    }

    public ZPenPaint getPenPaintTarget() {
        return this.fPenPaintTarget;
    }

    public void setPenPaintTarget(ZPenPaint aPenPaintTarget) {
        this.fPenPaintTarget = aPenPaintTarget;
    }

    public ZFillPaint getFillPaintTarget() {
        return this.fFillPaintTarget;
    }

    public void setFillPaintTarget(ZFillPaint aFillPaintTarget) {
        this.fFillPaintTarget = aFillPaintTarget;
    }

    protected void animateFrameForTime(long aTime) {
        super.animateFrameForTime(aTime);
        float ratio = this.getAlpha().value(aTime);
        float red = (float)this.fSource.getRed() + ratio * (float)(this.fDestination.getRed() - this.fSource.getRed());
        float green = (float)this.fSource.getGreen() + ratio * (float)(this.fDestination.getGreen() - this.fSource.getGreen());
        float blue = (float)this.fSource.getBlue() + ratio * (float)(this.fDestination.getBlue() - this.fSource.getBlue());
        float alpha = (float)this.fSource.getAlpha() + ratio * (float)(this.fDestination.getAlpha() - this.fSource.getAlpha());
        Color interpolation = new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f);
        if (this.fFillPaintTarget != null) {
            this.fFillPaintTarget.setFillPaint(interpolation);
        }
        if (this.fPenPaintTarget != null) {
            this.fPenPaintTarget.setPenPaint(interpolation);
        }
    }
}

