/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.animation;

import edu.umd.cs.jazz.animation.ZAlpha;
import edu.umd.cs.jazz.animation.ZAnimationScheduler;

public abstract class ZNextFrameCondition
implements Comparable {
    private ZAlpha fAlpha;

    public ZNextFrameCondition(ZAlpha aAlpha) {
        this.fAlpha = aAlpha;
    }

    public boolean isReadyToAnimate() {
        if (this.fAlpha != null) {
            return this.fAlpha.isStarted(ZAnimationScheduler.instance().getCurrentTime());
        }
        return true;
    }

    public int compareTo(Object o) {
        long aTime = ZAnimationScheduler.instance().getCurrentTime();
        ZNextFrameCondition aFrameCondition = (ZNextFrameCondition)o;
        ZAlpha thisAlpha = this.fAlpha;
        ZAlpha thatAlpha = aFrameCondition.fAlpha;
        if (thisAlpha == null && thatAlpha != null) {
            return 1;
        }
        if (thisAlpha != null && thatAlpha == null) {
            return -1;
        }
        if (thisAlpha == null && thatAlpha == null) {
            return 0;
        }
        boolean isThisStarted = thisAlpha.isStarted(aTime);
        boolean isThatStarted = thatAlpha.isStarted(aTime);
        if (isThisStarted && !isThatStarted) {
            return 1;
        }
        if (!isThisStarted && isThatStarted) {
            return -1;
        }
        if (!isThatStarted && !isThatStarted) {
            long thatStart;
            long thisStart = this.fAlpha.getTriggerTime() + this.fAlpha.getPhaseDelayDuration();
            if (thisStart < (thatStart = aFrameCondition.fAlpha.getTriggerTime() + aFrameCondition.fAlpha.getPhaseDelayDuration())) {
                return 1;
            }
            if (thisStart > thatStart) {
                return -1;
            }
        }
        return 0;
    }
}

