/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.component.ZPenColor;
import edu.umd.cs.jazz.component.ZPenPaint;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ZText
extends ZVisualComponent
implements ZPenColor,
ZPenPaint,
Serializable {
    protected static final FontRenderContext LOW_QUALITY_FONT_CONTEXT = new FontRenderContext(null, false, false);
    protected static final FontRenderContext HIGH_QUALITY_FONT_CONTEXT = new FontRenderContext(null, true, true);
    protected static final double DEFAULT_GREEK_THRESHOLD = 5.5;
    protected static final Color DEFAULT_GREEK_COLOR;
    protected static final String DEFAULT_FONT_NAME = "Helvetica";
    protected static final int DEFAULT_FONT_STYLE = 0;
    protected static final int DEFAULT_FONT_SIZE = 12;
    protected static final Font DEFAULT_FONT;
    protected static final Color DEFAULT_PEN_COLOR;
    protected static final Color DEFAULT_BACKGROUND_COLOR;
    protected static final Color DEFAULT_CARET_COLOR;
    protected static final boolean DEFAULT_EDITABLE = false;
    protected static final String DEFAULT_TEXT = "";
    protected double greekThreshold = 5.5;
    protected Color greekColor = DEFAULT_GREEK_COLOR;
    protected Color penColor = DEFAULT_PEN_COLOR;
    protected Color backgroundColor = DEFAULT_BACKGROUND_COLOR;
    protected Color caretColor = DEFAULT_CARET_COLOR;
    protected int caretPos = 0;
    protected int caretLine = 0;
    protected double caretX = 0.0;
    protected double caretY = 0.0;
    protected transient Line2D caretShape = new Line2D.Double();
    protected Font font = DEFAULT_FONT;
    protected ArrayList lines = new ArrayList();
    protected boolean editable = false;
    protected transient FontRenderContext prevFRC = null;
    protected boolean boundsBug = false;
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public ZText() {
        this(DEFAULT_TEXT, DEFAULT_FONT);
    }

    public ZText(String str) {
        this(str, DEFAULT_FONT);
    }

    public ZText(String str, Font font) {
        if (System.getProperty("java.version").equals("1.2") || System.getProperty("java.version").equals("1.2.1")) {
            this.boundsBug = true;
        }
        this.setText(str);
        this.font = font;
        this.reshape();
    }

    protected Object duplicateObject() {
        ZText newText = (ZText)super.duplicateObject();
        newText.lines = (ArrayList)this.lines.clone();
        return newText;
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.repaint();
    }

    public Paint getPenPaint() {
        return this.penColor;
    }

    public void setPenPaint(Paint aPaint) {
        this.penColor = (Color)aPaint;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        this.caretColor = color;
        this.repaint();
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double threshold) {
        this.greekThreshold = threshold;
        this.repaint();
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        String result = new String();
        int lineNum = 0;
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            if (lineNum > 0) {
                result = result + '\n';
            }
            String line = (String)i.next();
            result = result + line;
            ++lineNum;
        }
        return result;
    }

    public int getCaretPos() {
        return this.caretPos;
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public void setFont(Font aFont) {
        this.font = aFont;
        this.reshape();
    }

    public void setText(String str) {
        int pos = 0;
        boolean done = false;
        this.lines = new ArrayList();
        do {
            int index;
            if ((index = str.indexOf(10, pos)) == -1) {
                this.lines.add(str);
                done = true;
                continue;
            }
            this.lines.add(str.substring(0, index));
            str = str.substring(index + 1);
        } while (!done);
        this.reshape();
    }

    public void addChar(char c) {
        String frontHalf = ((String)this.lines.get(this.caretLine)).substring(0, this.caretPos);
        String backHalf = ((String)this.lines.get(this.caretLine)).substring(this.caretPos);
        this.lines.set(this.caretLine, frontHalf + c + backHalf);
        ++this.caretPos;
        this.reshape();
    }

    public void addEnterChar() {
        String frontHalf = ((String)this.lines.get(this.caretLine)).substring(0, this.caretPos);
        String backHalf = ((String)this.lines.get(this.caretLine)).substring(this.caretPos);
        this.lines.set(this.caretLine, frontHalf);
        ++this.caretLine;
        this.lines.add(this.caretLine, backHalf);
        this.caretPos = 0;
        this.reshape();
    }

    public void deleteChar() {
        String currentLine = (String)this.lines.get(this.caretLine);
        if (this.caretPos == currentLine.length()) {
            if (this.caretLine < this.lines.size() - 1) {
                this.lines.set(this.caretLine, currentLine + (String)this.lines.get(this.caretLine + 1));
                this.lines.remove(this.caretLine + 1);
            }
        } else {
            String frontHalf = currentLine.substring(0, this.caretPos);
            String backHalf = currentLine.substring(this.caretPos + 1);
            this.lines.set(this.caretLine, frontHalf + backHalf);
        }
        this.reshape();
    }

    public void deleteCharBeforeCaret() {
        if (this.caretPos > 0 || this.caretLine > 0) {
            this.setCaretPos(this.getCaretPos() - 1);
            this.deleteChar();
        }
    }

    public void deleteToEndOfLine() {
        if (this.caretPos == ((String)this.lines.get(this.caretLine)).length()) {
            this.deleteChar();
        } else {
            String frontHalf = ((String)this.lines.get(this.caretLine)).substring(0, this.caretPos);
            this.lines.set(this.caretLine, frontHalf);
            this.reshape();
        }
    }

    public void setCaretLine(int line) {
        this.caretLine = line < 0 ? 0 : (line >= this.lines.size() ? this.lines.size() - 1 : line);
        this.setCaretPos(this.getCaretPos());
        this.repaint();
    }

    public void setCaretPos(int cp) {
        if (cp < 0) {
            if (this.caretLine > 0) {
                --this.caretLine;
                this.caretPos = ((String)this.lines.get(this.caretLine)).length();
            } else {
                this.caretPos = 0;
            }
        } else if (cp > ((String)this.lines.get(this.caretLine)).length()) {
            if (this.caretLine < this.lines.size() - 1) {
                ++this.caretLine;
                this.caretPos = 0;
            } else {
                this.caretPos = ((String)this.lines.get(this.caretLine)).length();
            }
        } else {
            this.caretPos = cp;
        }
        this.repaint();
    }

    public void setCaretPos(Point2D pt) {
        LineMetrics lm = this.font.getLineMetrics((String)this.lines.get(0), this.prevFRC);
        double height = lm.getHeight();
        double desc = lm.getDescent();
        this.caretLine = (int)((pt.getY() - desc) / height);
        if (pt.getY() < desc) {
            this.caretLine = 0;
        }
        if (this.caretLine >= this.lines.size()) {
            this.caretLine = this.lines.size() - 1;
        }
        Rectangle2D bounds = null;
        String textLine = (String)this.lines.get(this.caretLine);
        this.caretPos = textLine.length();
        int ch = 0;
        while (ch < textLine.length()) {
            String substr = textLine.substring(0, ch);
            bounds = this.font.getStringBounds(substr, this.prevFRC);
            double strWid = bounds.getWidth();
            double charWid = this.font.getStringBounds(textLine.substring(ch, ch + 1), this.prevFRC).getWidth();
            if (this.boundsBug && substr != null && substr.length() > 0 && substr.charAt(substr.length() - 1) == ' ') {
                strWid += this.font.getStringBounds("t", this.prevFRC).getWidth();
                charWid = this.font.getStringBounds("t", this.prevFRC).getWidth();
            }
            if (strWid > pt.getX()) {
                if (pt.getX() > strWid - charWid / 2.0) {
                    this.caretPos = ch;
                    break;
                }
                this.caretPos = ch - 1;
                if (this.caretPos >= 0) break;
                this.caretPos = 0;
                break;
            }
            ++ch;
        }
        this.repaint();
    }

    public void setTranslateX(double x) {
        this.setTranslation(x, this.translateY);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public void setTranslateY(double y) {
        this.setTranslation(this.translateX, y);
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setTranslation(double x, double y) {
        this.translateX = x;
        this.translateY = y;
        this.reshape();
    }

    public void setTranslation(Point2D p) {
        this.setTranslation(p.getX(), p.getY());
    }

    public Point2D getTranslation() {
        Point2D.Double p = new Point2D.Double(this.translateX, this.translateY);
        return p;
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (keyCode == 16 || keyCode == 17 || keyCode == 18 || keyCode == 157) {
            return;
        }
        if (e.isControlDown()) {
            if (keyCode == 37) {
                if (this.getCaretPos() > 0) {
                    int startPos = this.getCaretPos() - 1;
                    char c = ((String)this.lines.get(this.caretLine)).charAt(startPos);
                    while (c == ' ' && startPos > 0) {
                        c = ((String)this.lines.get(this.caretLine)).charAt(startPos);
                        --startPos;
                    }
                    int nextPos = 0;
                    boolean foundSpace = false;
                    int i = startPos;
                    while (i >= 0) {
                        c = ((String)this.lines.get(this.caretLine)).charAt(i);
                        if (c == ' ') {
                            nextPos = i + 1;
                            break;
                        }
                        --i;
                    }
                    this.setCaretPos(nextPos);
                }
            } else if (keyCode == 39) {
                int strLen = ((String)this.lines.get(this.caretLine)).length();
                if (this.getCaretPos() < strLen) {
                    int nextPos = strLen;
                    boolean foundSpace = false;
                    int i = this.getCaretPos();
                    while (i < strLen) {
                        char c = ((String)this.lines.get(this.caretLine)).charAt(i);
                        if (c == ' ') {
                            foundSpace = true;
                        }
                        if (foundSpace && c != ' ') {
                            nextPos = i;
                            break;
                        }
                        ++i;
                    }
                    this.setCaretPos(nextPos);
                }
            } else if (keyCode == 38) {
                this.setCaretLine(this.getCaretLine() - 1);
            } else if (keyCode == 40) {
                this.setCaretLine(this.getCaretLine() + 1);
            }
        } else if (!e.isAltDown()) {
            if (keyCode == 37) {
                this.setCaretPos(this.getCaretPos() - 1);
            } else if (keyCode == 39) {
                this.setCaretPos(this.getCaretPos() + 1);
            } else if (keyCode == 38) {
                this.setCaretLine(this.getCaretLine() - 1);
            } else if (keyCode == 40) {
                this.setCaretLine(this.getCaretLine() + 1);
            } else if (keyCode == 36) {
                this.setCaretPos(0);
            } else if (keyCode == 35) {
                this.setCaretPos(((String)this.lines.get(this.caretLine)).length());
            } else if (keyCode == 8) {
                this.deleteCharBeforeCaret();
            } else if (keyCode == 127) {
                this.deleteChar();
            } else if (keyCode == 10) {
                this.addEnterChar();
            } else {
                this.addChar(keyChar);
            }
        }
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        AffineTransform at = null;
        boolean translated = false;
        if (!this.lines.isEmpty()) {
            double renderedFontSize;
            if (this.translateX != 0.0 || this.translateY != 0.0) {
                at = g2.getTransform();
                g2.translate(this.translateX, this.translateY);
                translated = true;
            }
            if ((renderedFontSize = (double)this.font.getSize() * renderContext.getCompositeMagnification()) < 0.5 || renderedFontSize < this.greekThreshold && renderContext.getGreekText()) {
                this.paintAsGreek(renderContext);
            } else {
                this.paintAsText(renderContext);
            }
            if (translated) {
                g2.setTransform(at);
            }
        }
        this.prevFRC = g2.getFontRenderContext();
    }

    public void paintAsGreek(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        if (this.greekColor != null) {
            g2.setColor(this.greekColor);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.bounds.getWidth(), this.bounds.getHeight());
            g2.fill(rect);
        }
    }

    public void paintAsText(ZRenderContext renderContext) {
        LineMetrics lm;
        Graphics2D g2 = renderContext.getGraphics2D();
        if (this.backgroundColor != null) {
            g2.setColor(this.backgroundColor);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.bounds.getWidth(), this.bounds.getHeight());
            g2.fill(rect);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        g2.setColor(this.penColor);
        g2.setFont(this.font);
        int lineNum = 0;
        long startTime = 0L;
        long endTime = 0L;
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            lm = this.font.getLineMetrics(line, frc);
            double y = lm.getAscent() + (float)lineNum * lm.getHeight();
            g2.drawString(line, 0.0f, (float)y);
            ++lineNum;
        }
        if (this.editable) {
            this.caretX = 0.0;
            String textLine = (String)this.lines.get(this.caretLine);
            lm = this.font.getLineMetrics(textLine, frc);
            if (this.caretPos > 0) {
                this.caretX = this.boundsBug && textLine.substring(0, this.caretPos).endsWith(" ") ? this.font.getStringBounds(textLine.substring(0, this.caretPos - 1) + 't', frc).getWidth() : this.font.getStringBounds(textLine, 0, this.caretPos, frc).getWidth();
            }
            this.caretY = lm.getAscent() + (float)this.caretLine * lm.getHeight();
            g2.setColor(this.caretColor);
            g2.setStroke(new BasicStroke((float)(2.0 / renderContext.getCompositeMagnification()), 0, 2));
            this.caretShape.setLine(this.caretX, this.caretY, this.caretX, this.caretY - (double)lm.getAscent());
            g2.draw(this.caretShape);
        }
    }

    protected void computeBounds() {
        Rectangle2D rect = null;
        Object bugBounds = null;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        FontRenderContext frc = LOW_QUALITY_FONT_CONTEXT;
        int loop = 0;
        while (loop < 2) {
            double height = 0.0;
            boolean hasText = true;
            if (this.lines.size() == 1 && ((String)this.lines.get(0)).equals(DEFAULT_TEXT)) {
                hasText = false;
            }
            if (!this.lines.isEmpty() && hasText) {
                int lineNum = 0;
                Iterator i = this.lines.iterator();
                while (i.hasNext()) {
                    String line = (String)i.next();
                    LineMetrics lm = this.font.getLineMetrics(line, frc);
                    rect = this.font.getStringBounds(line, frc);
                    double lineWidth = rect.getWidth();
                    if (this.boundsBug && line.endsWith(" ")) {
                        lineWidth = this.font.getStringBounds(line.substring(0, line.length() - 1) + 't', frc).getWidth();
                    }
                    if (lineWidth > maxWidth) {
                        maxWidth = lineWidth;
                    }
                    height = lineNum == 0 ? (height += (double)(lm.getAscent() + lm.getDescent())) : (height += (double)lm.getHeight());
                    ++lineNum;
                }
            } else {
                rect = this.boundsBug ? this.font.getStringBounds("t", frc) : this.font.getStringBounds(" ", frc);
                maxWidth = rect.getWidth();
                height = rect.getHeight();
            }
            if (maxHeight < height) {
                maxHeight = height;
            }
            frc = HIGH_QUALITY_FONT_CONTEXT;
            ++loop;
        }
        this.bounds.setRect(this.translateX, this.translateY, maxWidth, maxHeight);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("penColor") == 0) {
            this.setPenColor((Color)fieldValue);
        } else if (fieldName.compareTo("backgroundColor") == 0) {
            this.setBackgroundColor((Color)fieldValue);
        } else if (fieldName.compareTo("caretColor") == 0) {
            this.setCaretColor((Color)fieldValue);
        } else if (fieldName.compareTo("font") == 0) {
            this.setFont((Font)fieldValue);
        } else if (fieldName.compareTo("editable") == 0) {
            this.setEditable((Boolean)fieldValue);
        } else if (fieldName.compareTo("translateX") == 0) {
            this.setTranslateX((Double)fieldValue);
        } else if (fieldName.compareTo("translateY") == 0) {
            this.setTranslateY((Double)fieldValue);
        } else if (fieldName.compareTo("text") == 0) {
            this.setText((String)fieldValue);
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.penColor != null && this.penColor != DEFAULT_PEN_COLOR) {
            out.writeState("java.awt.Color", "penColor", this.penColor);
        }
        if (this.backgroundColor != null && this.backgroundColor != DEFAULT_BACKGROUND_COLOR) {
            out.writeState("java.awt.Color", "backgroundColor", this.backgroundColor);
        }
        if (this.caretColor != null && this.caretColor != DEFAULT_CARET_COLOR) {
            out.writeState("java.awt.Color", "caretColor", this.caretColor);
        }
        if (this.getFont() != DEFAULT_FONT) {
            out.writeState("java.awt.Font", "font", this.getFont());
        }
        if (this.getEditable()) {
            out.writeState("boolean", "editable", this.getEditable());
        }
        if (this.translateX != 0.0) {
            out.writeState("Double", "translateX", new Double(this.translateX));
        }
        if (this.translateY != 0.0) {
            out.writeState("Double", "translateY", new Double(this.translateY));
        }
        if (this.getText() != DEFAULT_TEXT) {
            out.writeState("String", "text", this.getText());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.caretShape = new Line2D.Double();
        this.prevFRC = new FontRenderContext(null, true, true);
    }

    static {
        DEFAULT_GREEK_THRESHOLD = 5.5;
        DEFAULT_GREEK_COLOR = Color.gray;
        DEFAULT_FONT_NAME = DEFAULT_FONT_NAME;
        DEFAULT_FONT_STYLE = 0;
        DEFAULT_FONT_SIZE = 12;
        DEFAULT_FONT = new Font(DEFAULT_FONT_NAME, 0, 12);
        DEFAULT_PEN_COLOR = Color.black;
        DEFAULT_BACKGROUND_COLOR = null;
        DEFAULT_CARET_COLOR = Color.red;
        DEFAULT_EDITABLE = false;
        DEFAULT_TEXT = DEFAULT_TEXT;
    }
}

