/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZDimension;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class ZDragSequenceEventHandler
extends ZFilteredEventHandler {
    private Point2D fMousePressedScreenPoint;
    private Point2D fDragStartScreenPoint;
    private Point2D fPreviousScreenPoint;
    private Point2D fCurrentScreenPoint;
    private Dimension2D fCurrentScreenDelta;
    private boolean fIsDragging = false;
    private double fMinDragStartDistance = 0.0;

    public ZDragSequenceEventHandler(ZSceneGraphObject aFilteredMouseEventSource) {
        super(aFilteredMouseEventSource);
    }

    public ZDragSequenceEventHandler(ZSceneGraphObject aFilteredMouseEventSource, ZCanvas aFilteredKeyEventSouce) {
        super(aFilteredMouseEventSource, aFilteredKeyEventSouce);
    }

    protected void filteredMousePressed(ZMouseEvent e) {
        this.getMousePressedScreenPoint().setLocation(e.getX(), e.getY());
        if (this.shouldStartDragInteraction(e)) {
            this.startDrag(e);
        }
    }

    protected void filteredMouseDragged(ZMouseEvent e) {
        if (!this.isDragging()) {
            if (this.shouldStartDragInteraction(e)) {
                this.startDrag(e);
            }
            return;
        }
        this.drag(e);
    }

    protected void filteredMouseReleased(ZMouseEvent e) {
        if (this.isDragging()) {
            this.endDrag(e);
        }
    }

    protected void startDrag(ZMouseEvent e) {
        this.setIsDragging(true);
        ZSceneGraphPath aPath = e.getPath();
        this.getDragStartScreenPoint().setLocation(this.getMousePressedScreenPoint());
        this.getPreviousScreenPoint().setLocation(this.fDragStartScreenPoint);
        this.getCurrentScreenPoint().setLocation(this.fDragStartScreenPoint);
        this.getCurrentScreenDelta().setSize(0.0, 0.0);
        this.getTopCamera().getDrawingSurface().setInteracting(true);
    }

    protected void drag(ZMouseEvent e) {
        double dx = (double)e.getX() - this.getPreviousScreenPoint().getX();
        double dy = (double)e.getY() - this.getPreviousScreenPoint().getY();
        if (dx != 0.0 || dy != 0.0) {
            this.getCurrentScreenPoint().setLocation(e.getX(), e.getY());
            this.getCurrentScreenDelta().setSize(dx, dy);
            this.dragInScreenCoords(e, this.getCurrentScreenDelta());
            this.getPreviousScreenPoint().setLocation(e.getX(), e.getY());
        }
    }

    protected void dragInScreenCoords(ZMouseEvent e, Dimension2D aScreenDelta) {
    }

    protected void endDrag(ZMouseEvent e) {
        this.getTopCamera().getDrawingSurface().setInteracting(false);
        this.setIsDragging(false);
    }

    protected boolean shouldStartDragInteraction(ZMouseEvent e) {
        return this.getMousePressedScreenPoint().distance(e.getX(), e.getY()) >= this.getMinDragStartDistance();
    }

    public boolean isDragging() {
        return this.fIsDragging;
    }

    protected void setIsDragging(boolean aBoolean) {
        this.fIsDragging = aBoolean;
    }

    public double getMinDragStartDistance() {
        return this.fMinDragStartDistance;
    }

    public void setMinDragStartDistance(double aDouble) {
        this.fMinDragStartDistance = aDouble;
    }

    public Point2D getMousePressedScreenPoint() {
        if (this.fMousePressedScreenPoint == null) {
            this.fMousePressedScreenPoint = new Point2D.Double();
        }
        return this.fMousePressedScreenPoint;
    }

    public Point2D getDragStartScreenPoint() {
        if (this.fDragStartScreenPoint == null) {
            this.fDragStartScreenPoint = new Point2D.Double();
        }
        return this.fDragStartScreenPoint;
    }

    public Point2D getPreviousScreenPoint() {
        if (this.fPreviousScreenPoint == null) {
            this.fPreviousScreenPoint = new Point2D.Double();
        }
        return this.fPreviousScreenPoint;
    }

    public Point2D getCurrentScreenPoint() {
        if (this.fCurrentScreenPoint == null) {
            this.fCurrentScreenPoint = new Point2D.Double();
        }
        return this.fCurrentScreenPoint;
    }

    public Dimension2D getCurrentScreenDelta() {
        if (this.fCurrentScreenDelta == null) {
            this.fCurrentScreenDelta = new ZDimension();
        }
        return this.fCurrentScreenDelta;
    }
}

