/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZSelectionManager;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.event.ZMouseListener;
import edu.umd.cs.jazz.event.ZMouseMotionListener;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;

public class ZFilteredEventHandler
implements ZEventHandler {
    private boolean fIsActive;
    private ZSceneGraphObject fFilteredMouseEventSource;
    private ZCanvas fFilteredKeyEventSource;
    private ZMouseEvent fCurrentFilteredMouseEvent;
    protected ZFilteredEventDispatcher fFilteredEventDispatcher;
    protected ZMouseFilter fMouseFilter;

    public ZFilteredEventHandler(ZSceneGraphObject aFilteredMouseEventSource) {
        this.setFilteredMouseEventSource(aFilteredMouseEventSource);
    }

    public ZFilteredEventHandler(ZSceneGraphObject aFilteredMouseEventSource, ZCanvas aFilteredKeyEventSource) {
        this(aFilteredMouseEventSource);
        this.setFilteredKeyEventSource(aFilteredKeyEventSource);
    }

    public void setMouseFilter(ZMouseFilter aMouseFilter) {
        this.fMouseFilter = aMouseFilter;
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter();
        }
        return this.fMouseFilter;
    }

    protected boolean wantsKeyEvents() {
        return this.fFilteredKeyEventSource != null;
    }

    protected boolean wantsMouseEvents() {
        return this.fFilteredMouseEventSource != null;
    }

    protected boolean wantsMouseMotionEvents() {
        return this.fFilteredMouseEventSource != null;
    }

    public ZSceneGraphObject getFilteredMouseEventSource() {
        return this.fFilteredMouseEventSource;
    }

    public void setFilteredMouseEventSource(ZSceneGraphObject aFilteredMouseEventSource) {
        if (this.fFilteredMouseEventSource != null && this.isActive()) {
            if (this.wantsMouseEvents()) {
                this.fFilteredMouseEventSource.removeMouseListener(this.getFilteredEventDispatcher());
            }
            if (this.wantsMouseMotionEvents()) {
                this.fFilteredMouseEventSource.removeMouseMotionListener(this.getFilteredEventDispatcher());
            }
        }
        this.fFilteredMouseEventSource = aFilteredMouseEventSource;
        if (this.fFilteredMouseEventSource != null && this.isActive()) {
            if (this.wantsMouseEvents()) {
                this.fFilteredMouseEventSource.addMouseListener(this.getFilteredEventDispatcher());
            }
            if (this.wantsMouseMotionEvents()) {
                this.fFilteredMouseEventSource.addMouseMotionListener(this.getFilteredEventDispatcher());
            }
        }
    }

    public ZCanvas getFilteredKeyEventSource() {
        return this.fFilteredKeyEventSource;
    }

    public void setFilteredKeyEventSource(ZCanvas aFilteredKeyEventSource) {
        if (this.fFilteredKeyEventSource != null && this.isActive() && this.wantsKeyEvents()) {
            this.fFilteredKeyEventSource.removeKeyListener(this.getFilteredEventDispatcher());
        }
        this.fFilteredKeyEventSource = aFilteredKeyEventSource;
        if (this.fFilteredKeyEventSource != null && this.isActive() && this.wantsKeyEvents()) {
            this.fFilteredKeyEventSource.addKeyListener(this.getFilteredEventDispatcher());
        }
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public void setActive(boolean active) {
        if (this.fIsActive && !active) {
            this.fIsActive = false;
            if (this.wantsMouseEvents()) {
                this.fFilteredMouseEventSource.removeMouseListener(this.getFilteredEventDispatcher());
            }
            if (this.wantsMouseMotionEvents()) {
                this.fFilteredMouseEventSource.removeMouseMotionListener(this.getFilteredEventDispatcher());
            }
            if (this.wantsKeyEvents()) {
                this.fFilteredKeyEventSource.removeKeyListener(this.getFilteredEventDispatcher());
            }
        } else if (!this.fIsActive && active) {
            this.fIsActive = true;
            if (this.wantsMouseEvents()) {
                this.fFilteredMouseEventSource.addMouseListener(this.getFilteredEventDispatcher());
            }
            if (this.wantsMouseMotionEvents()) {
                this.fFilteredMouseEventSource.addMouseMotionListener(this.getFilteredEventDispatcher());
            }
            if (this.wantsKeyEvents()) {
                this.fFilteredKeyEventSource.addKeyListener(this.getFilteredEventDispatcher());
                this.fFilteredKeyEventSource.requestFocus();
            }
        }
        this.fIsActive = active;
    }

    public ZMouseEvent getCurrentFilteredMouseEvent() {
        return this.fCurrentFilteredMouseEvent;
    }

    public Collection getCurrentSelection() {
        if (this.getInteractionCamera() != null) {
            return ZSelectionManager.getSelectedNodes(this.getTopCamera());
        }
        if (this.getFilteredKeyEventSource() != null) {
            return ZSelectionManager.getSelectedNodes(this.getFilteredKeyEventSource().getRoot());
        }
        return new ArrayList(0);
    }

    public ZCamera getInteractionCamera() {
        if (this.getCurrentFilteredMouseEvent() != null) {
            return this.getCurrentFilteredMouseEvent().getPath().getCamera();
        }
        return null;
    }

    public ZCamera getTopCamera() {
        if (this.getCurrentFilteredMouseEvent() != null) {
            return this.getCurrentFilteredMouseEvent().getPath().getTopCamera();
        }
        return null;
    }

    public ZFilteredEventDispatcher getFilteredEventDispatcher() {
        if (this.fFilteredEventDispatcher == null) {
            this.fFilteredEventDispatcher = new ZFilteredEventDispatcher();
        }
        return this.fFilteredEventDispatcher;
    }

    protected void filteredKeyPressed(KeyEvent e) {
    }

    protected void filteredKeyReleased(KeyEvent e) {
    }

    protected void filteredKeyTyped(KeyEvent e) {
    }

    protected void filteredMouseClicked(ZMouseEvent e) {
    }

    protected void filteredMouseDragged(ZMouseEvent e) {
    }

    protected void filteredMouseEntered(ZMouseEvent e) {
    }

    protected void filteredMouseExited(ZMouseEvent e) {
    }

    protected void filteredMouseMoved(ZMouseEvent e) {
    }

    protected void filteredMousePressed(ZMouseEvent e) {
    }

    protected void filteredMouseReleased(ZMouseEvent e) {
    }

    public class ZFilteredEventDispatcher
    implements ZMouseListener,
    ZMouseMotionListener,
    KeyListener {
        public void keyPressed(KeyEvent e) {
            ZFilteredEventHandler.this.filteredKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            ZFilteredEventHandler.this.filteredKeyReleased(e);
        }

        public void keyTyped(KeyEvent e) {
            ZFilteredEventHandler.this.filteredKeyTyped(e);
        }

        public void mouseClicked(ZMouseEvent e) {
            if (ZFilteredEventHandler.this.getMouseFilter().accept(e)) {
                ZFilteredEventHandler.this.fCurrentFilteredMouseEvent = e;
                ZFilteredEventHandler.this.filteredMouseClicked(e);
            }
        }

        public void mouseDragged(ZMouseEvent e) {
            if (ZFilteredEventHandler.this.getMouseFilter().accept(e)) {
                ZFilteredEventHandler.this.fCurrentFilteredMouseEvent = e;
                ZFilteredEventHandler.this.filteredMouseDragged(e);
            }
        }

        public void mouseEntered(ZMouseEvent e) {
            if (ZFilteredEventHandler.this.getMouseFilter().accept(e)) {
                ZFilteredEventHandler.this.fCurrentFilteredMouseEvent = e;
                ZFilteredEventHandler.this.filteredMouseEntered(e);
            }
        }

        public void mouseExited(ZMouseEvent e) {
            if (ZFilteredEventHandler.this.getMouseFilter().accept(e)) {
                ZFilteredEventHandler.this.fCurrentFilteredMouseEvent = e;
                ZFilteredEventHandler.this.filteredMouseExited(e);
            }
        }

        public void mouseMoved(ZMouseEvent e) {
            if (ZFilteredEventHandler.this.getMouseFilter().accept(e)) {
                ZFilteredEventHandler.this.fCurrentFilteredMouseEvent = e;
                ZFilteredEventHandler.this.filteredMouseMoved(e);
            }
        }

        public void mousePressed(ZMouseEvent e) {
            if (ZFilteredEventHandler.this.getMouseFilter().accept(e)) {
                ZFilteredEventHandler.this.fCurrentFilteredMouseEvent = e;
                ZFilteredEventHandler.this.filteredMousePressed(e);
            }
        }

        public void mouseReleased(ZMouseEvent e) {
            if (ZFilteredEventHandler.this.getMouseFilter().accept(e)) {
                ZFilteredEventHandler.this.fCurrentFilteredMouseEvent = e;
                ZFilteredEventHandler.this.filteredMouseReleased(e);
            }
        }
    }
}

