/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZDragSequenceEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.Dimension2D;

public class ZPanEventHandler
extends ZDragSequenceEventHandler {
    public static int DEFAULT_MIN_PAN_START_DISTANCE = 5;

    public ZPanEventHandler(ZSceneGraphObject aFilteredMouseEventSource) {
        super(aFilteredMouseEventSource);
        this.setMinDragStartDistance(DEFAULT_MIN_PAN_START_DISTANCE);
    }

    public ZPanEventHandler(ZSceneGraphObject aEventSource, ZCamera aIgnoredCamera) {
        this(aEventSource);
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter(16);
        }
        return this.fMouseFilter;
    }

    protected void dragInScreenCoords(ZMouseEvent e, Dimension2D aScreenDelta) {
        this.pan(e, aScreenDelta);
    }

    public void pan(ZMouseEvent e, Dimension2D aScreenDelta) {
        ZSceneGraphPath aPath = e.getPath();
        aPath.screenToCamera(aScreenDelta, this.getInteractionCamera());
        this.getInteractionCamera().cameraToLocal(aScreenDelta, null);
        this.getInteractionCamera().translate(aScreenDelta.getWidth(), aScreenDelta.getHeight());
    }

    public boolean isMoved() {
        return this.isDragging();
    }
}

