/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.event.ZDragSequenceEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZDimension;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.event.KeyEvent;
import java.awt.geom.Dimension2D;
import java.util.Iterator;

public class ZSelectionMoveHandler
extends ZDragSequenceEventHandler {
    public ZSelectionMoveHandler(ZSceneGraphObject aFilteredMouseEventSource, ZCanvas aFilteredKeyEventSouce) {
        super(aFilteredMouseEventSource, aFilteredKeyEventSouce);
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter(16);
        }
        return this.fMouseFilter;
    }

    protected void filteredKeyPressed(KeyEvent e) {
        double dx = 0.0;
        double dy = 0.0;
        switch (e.getKeyCode()) {
            case 37: {
                dx = -1.0;
                break;
            }
            case 39: {
                dx = 1.0;
                break;
            }
            case 38: {
                dy = -1.0;
                break;
            }
            case 40: {
                dy = 1.0;
                break;
            }
            default: {
                return;
            }
        }
        this.dragSelectionBy(new ZDimension(dx, dy));
    }

    protected void startDrag(ZMouseEvent e) {
        ZSceneGraphPath aPath = e.getPath();
        if (aPath.getObject() == null) {
            this.getMouseFilter().rejectAllEventTypes();
            this.getMouseFilter().setAcceptsMousePressed(true);
        } else {
            this.getMouseFilter().acceptAllEventTypes();
            super.startDrag(e);
        }
    }

    protected void dragInScreenCoords(ZMouseEvent e, Dimension2D aScreenDelta) {
        this.dragSelectionBy(aScreenDelta);
    }

    protected void dragSelectionBy(Dimension2D aScreenDelta) {
        ZDimension aDimension = new ZDimension();
        ZSceneGraphPath aPath = this.getCurrentFilteredMouseEvent().getCurrentPath();
        aPath.screenToCamera(aScreenDelta, this.getInteractionCamera());
        this.getInteractionCamera().cameraToLocal(aScreenDelta, null);
        Iterator i = this.getCurrentSelection().iterator();
        while (i.hasNext()) {
            ZNode each = (ZNode)i.next();
            ZTransformGroup eachTransform = each.editor().getTransformGroup();
            aDimension.setSize(aScreenDelta);
            each.globalToLocal(aDimension);
            eachTransform.translate(aDimension.getWidth(), aDimension.getHeight());
        }
    }
}

