/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class ZExtendedInputStream
implements Serializable {
    protected InputStream stream;
    protected long filePosition = 0L;

    public ZExtendedInputStream(InputStream stream) {
        this.stream = stream;
    }

    public void setFilePosition(long n) throws IOException {
        long tmp = n - this.filePosition;
        this.stream.skip(tmp);
        this.filePosition += tmp;
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    public long skip(long n) throws IOException {
        long result = this.stream.skip(n);
        this.filePosition += n;
        return result;
    }

    public int read() throws IOException {
        int result = this.stream.read();
        ++this.filePosition;
        return result;
    }

    public int read(byte[] b) throws IOException {
        int result = this.stream.read(b);
        this.filePosition += (long)result;
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.stream.read(b, off, len);
        this.filePosition += (long)result;
        return result;
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public static final void main(String[] args) {
        try {
            FileInputStream f = new FileInputStream("test2.jazz");
            ZExtendedInputStream s = new ZExtendedInputStream(f);
            s.setFilePosition(807L);
            byte[] buf = new byte[16];
            s.read(buf, 0, 16);
            System.out.println(new String(buf));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

