/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZHandle;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZTransformable;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZNoninvertibleTransformException;
import edu.umd.cs.jazz.util.ZUtil;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class ZSceneGraphPath
implements Serializable {
    private static final int INITIAL_PATH_LIST_LENGTH = 10;
    private static final int INITIAL_CAMERA_LIST_LENGTH = 1;
    private static final int INITIAL_TRANSFORMER_LIST_LENGTH = 5;
    private ZRoot root = null;
    private ZCamera topCamera = null;
    private ZNode topCameraNode = null;
    private ZList.ZSceneGraphObjectList parents = new ZListImpl.ZSceneGraphObjectListImpl(10);
    private ZList.ZCameraList cameras = new ZListImpl.ZCameraListImpl(1);
    private ZList.ZTransformableList transformers = new ZListImpl.ZTransformableListImpl(5);
    private ZSceneGraphObject terminal = null;
    private AffineTransform transform = new AffineTransform();
    private AffineTransform cameraTransform = new AffineTransform();
    private boolean cameraFound = false;

    public ZSceneGraphObject getObject() {
        return this.terminal;
    }

    public void setObject(ZSceneGraphObject object) {
        this.terminal = object;
    }

    public ZNode getTopCameraNode() {
        return this.topCameraNode;
    }

    public void setTopCameraNode(ZNode node) {
        this.topCameraNode = node;
    }

    public ZCamera getTopCamera() {
        return this.topCamera;
    }

    public void setTopCamera(ZCamera camera) {
        this.topCamera = camera;
    }

    public ZNode getNode() {
        if (this.terminal instanceof ZVisualComponent || this.terminal instanceof ZHandle || this.terminal == null) {
            ZSceneGraphObject[] objectsRef = this.parents.getSceneGraphObjectsReference();
            int i = this.parents.size() - 1;
            while (i >= 0) {
                if (objectsRef[i] instanceof ZNode) {
                    return (ZNode)objectsRef[i];
                }
                --i;
            }
        }
        ZNode node = this.terminal == null ? this.topCameraNode : (ZNode)this.terminal;
        return node;
    }

    public ZCamera getCamera() {
        if (this.terminal instanceof ZCamera) {
            return (ZCamera)this.terminal;
        }
        if (this.cameras.size() > 0) {
            return this.getCamera(this.cameras.size() - 1);
        }
        return this.topCamera;
    }

    public ZRoot getRoot() {
        return this.root;
    }

    public void setRoot(ZRoot root) {
        this.root = root;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void setTransform(AffineTransform tm) {
        this.transform.setTransform(tm);
    }

    public AffineTransform getCameraTransform() {
        return (AffineTransform)this.cameraTransform.clone();
    }

    public AffineTransform getCameraTransform(ZCamera camera) {
        return this.transformers.collectiveCatTransformUntil(camera);
    }

    public void setCameraTransform(AffineTransform tm) {
        this.cameraTransform.setTransform(tm);
    }

    public void screenToGlobal(Point2D pt) {
        this.screenToCamera(pt);
        this.getCamera().cameraToLocal(pt, null);
    }

    public void screenToGlobal(Dimension2D aDimension) {
        this.screenToCamera(aDimension);
        this.getCamera().cameraToLocal(aDimension, null);
    }

    public void screenToGlobal(Rectangle2D rect) {
        this.screenToCamera(rect);
        this.getCamera().cameraToLocal(rect, null);
    }

    public double screenToCamera(Point2D pt) {
        double dz = 0.0;
        try {
            this.cameraTransform.inverseTransform(pt, pt);
            dz = 1.0 / Math.max(this.cameraTransform.getScaleX(), this.cameraTransform.getScaleY());
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
        return dz;
    }

    public void screenToCamera(Dimension2D aDimension) {
        try {
            ZUtil.inverseTransformDimension(aDimension, this.cameraTransform);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public double screenToCamera(Rectangle2D rect) {
        try {
            return ZUtil.inverseTransformRectangle(rect, this.cameraTransform);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public double screenToCamera(Point2D pt, ZCamera camera) {
        ZCamera bottomCamera = this.getCamera();
        if (camera == bottomCamera) {
            return this.screenToCamera(pt);
        }
        double dz = 0.0;
        AffineTransform tmpTransform = this.transformers.collectiveCatTransformUntil(camera);
        try {
            tmpTransform.inverseTransform(pt, pt);
            dz = 1.0 / Math.max(tmpTransform.getScaleX(), tmpTransform.getScaleY());
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
        return dz;
    }

    public void screenToCamera(Dimension2D aDimension, ZCamera aCamera) {
        ZCamera bottomCamera = this.getCamera();
        if (aCamera == bottomCamera) {
            this.screenToCamera(aDimension);
            return;
        }
        AffineTransform tmpTransform = this.transformers.collectiveCatTransformUntil(aCamera);
        try {
            ZUtil.inverseTransformDimension(aDimension, tmpTransform);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public double screenToCamera(Rectangle2D rect, ZCamera camera) {
        ZCamera bottomCamera = this.getCamera();
        if (camera == bottomCamera) {
            return this.screenToCamera(rect);
        }
        AffineTransform tmpTransform = this.transformers.collectiveCatTransformUntil(camera);
        try {
            return ZUtil.inverseTransformRectangle(rect, tmpTransform);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public double cameraToScreen(Point2D pt, ZCamera camera) {
        AffineTransform tmpTransform = this.transformers.collectiveCatTransformUntil(camera);
        tmpTransform.transform(pt, pt);
        return Math.max(tmpTransform.getScaleX(), tmpTransform.getScaleY());
    }

    public double cameraToScreen(Dimension2D dimension, ZCamera camera) {
        AffineTransform tmpTransform = this.transformers.collectiveCatTransformUntil(camera);
        return ZUtil.transformDimension(dimension, tmpTransform);
    }

    public double cameraToScreen(Rectangle2D rect, ZCamera camera) {
        AffineTransform tmpTransform = this.transformers.collectiveCatTransformUntil(camera);
        ZTransformGroup.transform(rect, tmpTransform);
        return Math.max(tmpTransform.getScaleX(), tmpTransform.getScaleY());
    }

    public void screenToLocal(Point2D pt) {
        try {
            this.transform.inverseTransform(pt, pt);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public void screenToLocal(Dimension2D aDimension) {
        try {
            ZUtil.inverseTransformDimension(aDimension, this.transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public void screenToLocal(Rectangle2D rect) {
        try {
            ZUtil.inverseTransformRectangle(rect, this.transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public int getNumParents() {
        return this.parents.size();
    }

    public ZSceneGraphObject getParent(int i) {
        return (ZSceneGraphObject)this.parents.get(i);
    }

    public void push(ZSceneGraphObject sgo) {
        this.parents.add(sgo);
    }

    public void pop(ZSceneGraphObject sgo) {
        this.parents.pop(sgo);
    }

    public void trimToSize() {
        this.parents.trimToSize();
        this.trimTransformersToSize();
        this.trimCamerasToSize();
    }

    public int getNumCameras() {
        return this.cameras.size();
    }

    public ZCamera getCamera(int i) {
        return (ZCamera)this.cameras.get(i);
    }

    public void pushCamera(ZCamera camera) {
        this.cameras.add(camera);
    }

    public void popCamera(ZCamera camera) {
        this.cameras.pop(camera);
    }

    public void trimCamerasToSize() {
        this.cameras.trimToSize();
    }

    public void pushTransformer(ZTransformable transformer) {
        this.transformers.add(transformer);
    }

    public void popTransformer(ZTransformable transformer) {
        this.transformers.pop(transformer);
    }

    public void processMouseEvent(ZMouseEvent e) {
        if (this.terminal != null) {
            this.terminal.processMouseEvent(e);
            if (e.isConsumed()) {
                return;
            }
        }
        ZSceneGraphObject[] parentsRef = this.parents.getSceneGraphObjectsReference();
        int i = this.parents.size() - 1;
        while (i >= 0) {
            parentsRef[i].processMouseEvent(e);
            if (e.isConsumed()) {
                return;
            }
            --i;
        }
        this.getTopCameraNode().processMouseEvent(e);
    }

    public void trimTransformersToSize() {
        this.transformers.trimToSize();
    }

    public void setCameraFound(boolean cf) {
        this.cameraFound = cf;
    }

    public boolean getCameraFound() {
        return this.cameraFound;
    }

    public void updateTransform() {
        ZCamera bottomCamera = this.getCamera();
        AffineTransform tmpTransform = new AffineTransform();
        AffineTransform catTransform = new AffineTransform();
        ZTransformable[] transformersRef = this.transformers.getTransformablesReference();
        int i = 0;
        while (i < this.transformers.size()) {
            ZTransformable obj = transformersRef[i];
            double[] matrix = new double[6];
            transformersRef[i].getMatrix(matrix);
            catTransform.setTransform(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
            if (bottomCamera != null && obj == bottomCamera) {
                this.setCameraTransform((AffineTransform)tmpTransform.clone());
            }
            tmpTransform.concatenate(catTransform);
            ++i;
        }
        this.setTransform(tmpTransform);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ZSceneGraphPath[transform=" + this.transform + "; root=" + this.getRoot() + "; object=" + this.getObject() + "; parents=");
        int i = 0;
        while (i < this.parents.size()) {
            sb.append(this.parents.get(i));
            if (i < this.parents.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("; cameras=");
        int i2 = 0;
        while (i2 < this.cameras.size()) {
            sb.append(this.cameras.get(i2));
            if (i2 < this.cameras.size() - 1) {
                sb.append(", ");
            }
            ++i2;
        }
        sb.append("]");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    static {
        INITIAL_PATH_LIST_LENGTH = 10;
        INITIAL_CAMERA_LIST_LENGTH = 1;
        INITIAL_TRANSFORMER_LIST_LENGTH = 5;
    }
}

