/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.translators;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.TextEditor;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Replacer;

public class TranslatorPlugin
implements JAlbumPlugin {
    private PluginContext context;
    private JAlbumFrame window;
    Action translateSelectedSkin = new AbstractAction("Translate selected skin"){

        public void actionPerformed(ActionEvent e) {
            try {
                File skinDir = TranslatorPlugin.this.context.getJAlbumContext().getSkinDir();
                File textsDir = new File(skinDir, "texts");
                File englishText = new File(textsDir, "texts.properties");
                if (!englishText.exists()) {
                    JOptionPane.showMessageDialog((Component)TranslatorPlugin.this.window, "Sorry. This skin is not prepared for translation\n(Missing texts/texts.properties file)", "Translate selected skin", 0);
                    return;
                }
                File currentText = TranslatorPlugin.getCurrentLanguageFile(textsDir);
                if (!currentText.exists()) {
                    int answer = JOptionPane.showConfirmDialog((Component)TranslatorPlugin.this.window, "This skin is missing a translation for the currently selected language.\nA copy of the English translation file will be be generated for the currently selected language.\nJust change the English texts to the right of the = signs to your language.", "Translate selected skin", 2, 2);
                    if (answer != 0) {
                        return;
                    }
                    IO.copyFile((File)englishText, (File)currentText);
                }
                TextEditor.openDocument((File)englishText);
                TextEditor.openDocument((File)currentText);
            }
            catch (IOException ex) {
                Debug.showErrorDialog((JAlbumFrame)TranslatorPlugin.this.window, (IOException)ex);
            }
        }
    };
    Action translateJalbum = new AbstractAction("Translate jAlbum"){

        public void actionPerformed(ActionEvent e) {
            try {
                File progDir = Config.getConfig().progDir;
                File textsDir = new File(progDir, "texts");
                File englishText = new File(textsDir, "texts.properties");
                if (!englishText.exists()) {
                    JOptionPane.showMessageDialog((Component)TranslatorPlugin.this.window, "Sorry. Can't find the English reference translation.\n(Missing texts/texts.properties file)", "Translate jAlbum", 0);
                    return;
                }
                File currentText = TranslatorPlugin.getCurrentLanguageFile(textsDir);
                if (!currentText.exists()) {
                    System.out.println(currentText.getAbsolutePath());
                    int answer = JOptionPane.showConfirmDialog((Component)TranslatorPlugin.this.window, "jAlbum is missing a translation for the currently selected language.\nA copy of the English translation file will be be generated for the currently selected language.\nJust change the English texts to the right of the = signs to your language.", "Translate jAlbum", 2, 2);
                    if (answer != 0) {
                        return;
                    }
                    IO.copyFile((File)englishText, (File)currentText);
                }
                TextEditor.openDocument((File)englishText);
                TranslatorPlugin.viewEndOfDocument();
                TextEditor.openDocument((File)currentText);
                TranslatorPlugin.viewEndOfDocument();
            }
            catch (IOException ex) {
                Debug.showErrorDialog((JAlbumFrame)TranslatorPlugin.this.window, (IOException)ex);
            }
        }
    };
    Action updateSkinTranslation = new AbstractAction("Update skin translation"){
        {
            this.putValue("ShortDescription", "Add texts that are not yet translated to current skin translation");
        }

        public void actionPerformed(ActionEvent e) {
            TranslatorPlugin.this.updateTranslation(new File(TranslatorPlugin.this.context.getJAlbumContext().getSkinDir(), "texts"));
        }
    };
    Action updateJalbumTranslation = new AbstractAction("Update jAlbum translation"){
        {
            this.putValue("ShortDescription", "Add texts that are not yet translated to current jAlbum translation");
        }

        public void actionPerformed(ActionEvent e) {
            TranslatorPlugin.this.updateTranslation(new File(Config.getConfig().progDir, "texts"));
        }
    };
    Action findSkinTranslation = new AbstractAction("Find skin translation"){
        {
            this.putValue("ShortDescription", "Find translation file in file system");
        }

        public void actionPerformed(ActionEvent e) {
            File translationFile = TranslatorPlugin.getCurrentLanguageFile(new File(TranslatorPlugin.this.context.getJAlbumContext().getSkinDir(), "texts"));
            try {
                BrowserLauncher.showInFileSystem((File)translationFile);
            }
            catch (IOException ex) {
                Debug.showErrorDialog((JAlbumFrame)TranslatorPlugin.this.window, (IOException)ex);
            }
        }
    };
    Action findJalbumTranslation = new AbstractAction("Find jAlbum translation"){
        {
            this.putValue("ShortDescription", "Find translation file in file system");
        }

        public void actionPerformed(ActionEvent e) {
            File translationFile = TranslatorPlugin.getCurrentLanguageFile(new File(Config.getConfig().progDir, "texts"));
            try {
                BrowserLauncher.showInFileSystem((File)translationFile);
            }
            catch (IOException ex) {
                Debug.showErrorDialog((JAlbumFrame)TranslatorPlugin.this.window, (IOException)ex);
            }
        }
    };

    public void init(PluginContext context) {
        this.context = context;
        this.window = context.getJAlbumContext().getFrame();
        JMenu menu = new JMenu("Translator");
        menu.add(new JMenuItem(this.translateSelectedSkin));
        menu.add(this.updateSkinTranslation);
        menu.add(this.findSkinTranslation);
        menu.addSeparator();
        menu.add(new JMenuItem(this.translateJalbum));
        menu.add(this.updateJalbumTranslation);
        menu.add(this.findJalbumTranslation);
        context.addToolsMenuItem((JMenuItem)menu);
    }

    public boolean onExit() {
        return true;
    }

    private static void viewEndOfDocument() {
        try {
            JTextComponent editor = TextEditor.getCurrentEditorComponent();
            editor.setCaretPosition(editor.getDocument().getLength());
        }
        catch (NoSuchMethodError ex) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    private void updateTranslation(File textsDir) {
        try {
            File englishText = new File(textsDir, "texts.properties");
            if (!englishText.exists()) {
                return;
            }
            File currentText = TranslatorPlugin.getCurrentLanguageFile(textsDir);
            if (!currentText.exists()) {
                return;
            }
            if (currentText.equals(englishText)) {
                return;
            }
            Map all = IO.readMapFile((File)englishText);
            Map current = IO.readMapFile((File)currentText);
            for (Object key : current.keySet()) {
                all.remove(key);
            }
            if (all.size() > 0) {
                String content = "\n# Needs translation:\n" + TranslatorPlugin.mapToString(all);
                TextEditor.openDocument((File)currentText);
                JTextComponent editor = TextEditor.getCurrentEditorComponent();
                Document doc = editor.getDocument();
                editor.moveCaretPosition(doc.getLength());
                int selectionStart = doc.getLength();
                doc.insertString(doc.getLength(), content, null);
                editor.setSelectionStart(selectionStart);
                editor.setSelectionEnd(doc.getLength());
            } else {
                JOptionPane.showMessageDialog((Component)this.window, "The current translation is complete", "Update translation", 1);
            }
        }
        catch (Exception ex) {
            Debug.showErrorDialog((Component)this.window, (Throwable)ex);
        }
    }

    private static String mapToString(Map map) {
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        for (Map.Entry e : map.entrySet()) {
            out.println(e.getKey().toString() + "=" + backslashEncoder.replace(e.getValue().toString()));
        }
        out.close();
        return writer.getBuffer().toString();
    }

    private static File getCurrentLanguageFile(File textsDir) {
        String lang = "_" + Config.getConfig().getInterpretedLanguage();
        if ("_en".equals(lang)) {
            lang = "";
        }
        return new File(textsDir, "texts" + lang + ".properties");
    }
}

