/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestListings
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestListings.java,v 1.15 2010-09-14 00:44:58 bruceb Exp $";

    protected String getLogName() {
        return "TestListings.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDir() throws Exception {
        log.debug("testDir() - ENTRY");
        try {
            block6: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir();
                this.print(list);
                list = this.ftp.dir(".");
                this.print(list);
                log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir);
                this.print(list);
                log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                try {
                    list = this.ftp.dir(randomName);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block6;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550 for non-existent dir"));
                }
            }
            this.ftp.quit();
        }
        finally {
            log.debug("testDir() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirFull() throws Exception {
        log.debug("testDirFull() - ENTRY");
        try {
            block6: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir(".", true);
                this.print(list);
                log.debug("******* dirDetails *******");
                FTPFile[] files = this.ftp.dirDetails(".");
                this.print(files);
                log.debug("******* end dirDetails *******");
                log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir, true);
                this.print(list);
                log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                log.debug("Testing for non-existent dir: " + randomName);
                try {
                    list = this.ftp.dir(randomName, true);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block6;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550/2 for non-existent dir"));
                }
            }
            this.ftp.quit();
        }
        finally {
            log.debug("testDirFull() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirFull2() throws Exception {
        log.debug("testDirFull2() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            FTPFile[] files = this.ftp.dirDetails(".");
            DirCallback dirCallback = new DirCallback();
            this.ftp.dirDetails(".", dirCallback);
            if (dirCallback.getFiles().size() != files.length) {
                log.debug("Callback=" + dirCallback.getFiles().size() + ", listing=" + files.length);
                Iterator i = dirCallback.getFiles().keySet().iterator();
                while (i.hasNext()) {
                    log.debug((String)i.next());
                }
                log.debug("Listing=" + files.length);
                for (int j = 0; j < files.length; ++j) {
                    log.debug(files[j].getName());
                }
                TestListings.fail((String)"Mismatch in listing length");
            }
            log.debug("Listing lengths match!");
            boolean allFound = true;
            for (int i = 0; i < files.length; ++i) {
                if (dirCallback.getFiles().get(files[i].getName()) != null) continue;
                log.debug("Failed to find " + files[i].getName());
                allFound = false;
            }
            if (!allFound) {
                Iterator i = dirCallback.getFiles().values().iterator();
                while (i.hasNext()) {
                    log.debug(((FTPFile)i.next()).getName());
                }
                TestListings.fail((String)"Failed to find all files");
            }
            this.ftp.quit();
        }
        finally {
            log.debug("testDirFull2() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestListings.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestListings.suite());
    }

    class DirCallback
    implements DirectoryListCallback {
        private Map files = new HashMap();

        DirCallback() {
        }

        public void listDirectoryEntry(DirectoryListArgument arg) {
            this.files.put(arg.getEntry().getName(), arg.getEntry());
        }

        public Map getFiles() {
            return this.files;
        }
    }
}

