/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.debug;

import com.enterprisedt.util.debug.FileAppender;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class RollingFileAppender
extends FileAppender {
    public static final String cvsId = "@(#)$Id: RollingFileAppender.java,v 1.4 2010-11-04 04:06:42 bruceb Exp $";
    private static long DEFAULT_MAXSIZE = 0xA00000L;
    private static int CHECK_THRESHOLD_BYTES = 5120;
    private static String LINE_SEP = System.getProperty("line.separator");
    private long maxFileSize = DEFAULT_MAXSIZE;
    private int thresholdBytesWritten = 0;
    private int maxSizeRollBackups = 1;

    public RollingFileAppender(String file, long maxFileSize) throws IOException {
        super(file);
        this.maxFileSize = maxFileSize;
        this.checkSizeForRollover();
    }

    public RollingFileAppender(String file) throws IOException {
        super(file);
        this.checkSizeForRollover();
    }

    public int getMaxSizeRollBackups() {
        return this.maxSizeRollBackups;
    }

    public void setMaxSizeRollBackups(int maxSizeRollBackups) {
        this.maxSizeRollBackups = maxSizeRollBackups;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public synchronized void log(String msg) {
        if (!this.closed) {
            this.checkForRollover();
            this.log.println(msg);
            this.log.flush();
            this.thresholdBytesWritten += msg.length();
        }
    }

    public synchronized void log(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String msg = sw.toString();
        if (!this.closed) {
            this.checkForRollover();
            this.log.println(msg);
            this.log.flush();
            this.thresholdBytesWritten += msg.length();
        }
    }

    private void checkForRollover() {
        if (this.thresholdBytesWritten < CHECK_THRESHOLD_BYTES) {
            return;
        }
        this.thresholdBytesWritten = 0;
        this.checkSizeForRollover();
    }

    private void checkSizeForRollover() {
        try {
            File f = new File(this.getFile());
            if (f.length() > this.maxFileSize) {
                this.rollover();
            }
        }
        catch (Exception ex) {
            String msg = "Failed to rollover log files: " + ex.getMessage();
            System.err.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollover() throws IOException {
        this.close();
        StringBuffer msg = new StringBuffer();
        Exception ex = null;
        try {
            File master = new File(this.getFile());
            if (this.maxSizeRollBackups == 0) {
                if (!master.delete()) {
                    msg.append("Failed to delete file: " + master.getAbsolutePath() + LINE_SEP);
                }
            } else {
                File f = new File(this.getFile() + "." + this.maxSizeRollBackups);
                if (f.exists() && !f.delete()) {
                    msg.append("Failed to delete file: " + f.getAbsolutePath() + LINE_SEP);
                }
                for (int i = this.maxSizeRollBackups - 1; i > 0; --i) {
                    File renamed;
                    f = new File(this.getFile() + "." + i);
                    if (!f.exists() || f.renameTo(renamed = new File(this.getFile() + "." + (i + 1)))) continue;
                    msg.append("Failed to rename file: " + f.getAbsolutePath() + " to " + renamed.getAbsolutePath() + LINE_SEP);
                }
                f = new File(this.getFile() + ".1");
                if (!master.renameTo(f)) {
                    msg.append("Failed to rename file: " + master.getAbsolutePath() + " to " + f.getAbsolutePath() + LINE_SEP);
                }
            }
        }
        catch (Exception e) {
            ex = e;
        }
        finally {
            this.open();
            if (ex != null) {
                msg.append("Failed to rollover log files: " + ex.getMessage() + LINE_SEP);
            }
            if (msg.length() > 0) {
                this.log.println(msg.toString());
                this.log.flush();
                this.thresholdBytesWritten += msg.length();
            }
        }
    }
}

