/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.FlipControl;
import se.datadosen.jalbum.Msg;

public class FlipFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = -7157802824057671770L;
    protected FlipControl flipControl;
    protected boolean flipVertically = false;
    protected boolean flipHorizontally = false;

    public FlipFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.flip.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.flip.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/flip.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.flip.description");
        this.category = FilterProperties.FilterCategory.OTHER;
        this.prescale = false;
        this.postscale = true;
        this.flipControl = new FlipControl(this);
    }

    public JPanel getControls() {
        return this.flipControl;
    }

    public BufferedImage renderImage(BufferedImage input) {
        int xMultiplier;
        int xStart;
        int yMultiplier;
        int yStart;
        BufferedImage out = new BufferedImage(input.getWidth(), input.getHeight(), input.getType());
        if (this.flipVertically) {
            yStart = input.getHeight() - 1;
            yMultiplier = -1;
        } else {
            yStart = 0;
            yMultiplier = 1;
        }
        if (this.flipHorizontally) {
            xStart = input.getWidth() - 1;
            xMultiplier = -1;
        } else {
            xStart = 0;
            xMultiplier = 1;
        }
        for (int x = 0; x < input.getWidth(); ++x) {
            for (int y = 0; y < input.getHeight(); ++y) {
                out.setRGB(x, y, input.getRGB(xStart + x * xMultiplier, yStart + y * yMultiplier));
            }
        }
        return out;
    }

    public void flipVertically() {
        this.flipVertically = !this.flipVertically;
        this.renderImage();
    }

    public void flipHorizontally() {
        this.flipHorizontally = !this.flipHorizontally;
        this.renderImage();
    }

    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 226 || arg0.getKeyCode() == 37 || arg0.getKeyCode() == 39 || arg0.getKeyCode() == 227) {
            this.flipVertically();
        } else if (arg0.getKeyCode() == 224 || arg0.getKeyCode() == 38 || arg0.getKeyCode() == 225 || arg0.getKeyCode() == 40) {
            this.flipHorizontally();
        }
    }

    public boolean isFlipVertically() {
        return this.flipVertically;
    }

    public void setFlipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    public boolean isFlipHorizontally() {
        return this.flipHorizontally;
    }

    public void setFlipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }
}

