/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.jalbum.editor.JTextPad;
import se.datadosen.component.RiverLayout;

public class JFindDialog
extends JDialog {
    private JTextPad owner;
    JTextField toFind = new JTextField(15);
    JLabel toReplaceLabel = new JLabel("Replace with:");
    JTextField replaceWith = new JTextField(15);
    JCheckBox matchCase = new JCheckBox("Match case");
    JCheckBox wholeWords = new JCheckBox("Whole words");
    JCheckBox regExp = new JCheckBox("Regular expression");
    JCheckBox allDocuments = new JCheckBox("All documents");
    JRadioButton up = new JRadioButton("Up");
    JRadioButton down = new JRadioButton("Down", true);
    JButton replaceNextButton;
    JButton replaceAllButton;
    Action cancelAction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent e) {
            JFindDialog.this.setVisible(false);
        }
    };

    public JFindDialog(JTextPad owner) {
        super(owner, "Find", false);
        this.owner = owner;
        this.init();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.toFind.requestFocusInWindow();
    }

    private void init() {
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        pane.registerKeyboardAction(this.cancelAction, "cancel", esc, 2);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.up);
        bg.add(this.down);
        JButton findNextButton = new JButton(this.owner.findNextAction);
        this.getRootPane().setDefaultButton(findNextButton);
        this.replaceNextButton = new JButton(this.owner.replaceNextAction);
        this.replaceAllButton = new JButton(this.owner.replaceAllAction);
        this.setLayout(new BorderLayout());
        JPanel c = new JPanel();
        c.setLayout(new RiverLayout());
        c.add(new JLabel("Find what:"));
        c.add("tab hfill", this.toFind);
        c.add("br", this.toReplaceLabel);
        c.add("tab hfill", this.replaceWith);
        JPanel cbPanel = new JPanel();
        cbPanel.setLayout(new GridLayout(0, 1));
        cbPanel.add(this.matchCase);
        cbPanel.add(this.wholeWords);
        cbPanel.add(this.regExp);
        cbPanel.add(this.allDocuments);
        c.add("br", cbPanel);
        ControlPanel directionPanel = new ControlPanel("Direction");
        directionPanel.add(this.up);
        directionPanel.add(this.down);
        c.add(directionPanel);
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new RiverLayout(4, 2));
        actionPanel.add("hfill", findNextButton);
        actionPanel.add("br hfill", this.replaceNextButton);
        actionPanel.add("br hfill", this.replaceAllButton);
        actionPanel.add("br hfill", new JButton(this.cancelAction));
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        content.add((Component)c, "Center");
        content.add((Component)actionPanel, "After");
        this.getContentPane().add((Component)content, "Center");
        this.setMode(Mode.find);
    }

    public void setMode(Mode mode) {
        boolean replaceMode = mode == Mode.replace;
        this.setTitle(replaceMode ? "Replace" : "Find");
        this.toReplaceLabel.setVisible(replaceMode);
        this.replaceWith.setVisible(replaceMode);
        this.replaceNextButton.setVisible(replaceMode);
        this.replaceAllButton.setVisible(replaceMode);
        this.pack();
    }

    class ControlPanel
    extends JPanel {
        public ControlPanel(String title) {
            this.setLayout(new RiverLayout());
            this.setBorder(BorderFactory.createTitledBorder(title));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        find,
        replace;

    }
}

