/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class OlympusMakernoteDescriptor
extends TagDescriptor {
    public OlympusMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 512: {
                return this.getSpecialModeDescription();
            }
            case 513: {
                return this.getJpegQualityDescription();
            }
            case 514: {
                return this.getMacroModeDescription();
            }
            case 516: {
                return this.getDigiZoomRatioDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getDigiZoomRatioDescription() throws MetadataException {
        if (!this._directory.containsTag(516)) {
            return null;
        }
        int value = this._directory.getInt(516);
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 2: {
                return "Digital 2x Zoom";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getMacroModeDescription() throws MetadataException {
        if (!this._directory.containsTag(514)) {
            return null;
        }
        int value = this._directory.getInt(514);
        switch (value) {
            case 0: {
                return "Normal (no macro)";
            }
            case 1: {
                return "Macro";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getJpegQualityDescription() throws MetadataException {
        if (!this._directory.containsTag(513)) {
            return null;
        }
        int value = this._directory.getInt(513);
        switch (value) {
            case 1: {
                return "SQ";
            }
            case 2: {
                return "HQ";
            }
            case 3: {
                return "SHQ";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getSpecialModeDescription() throws MetadataException {
        if (!this._directory.containsTag(512)) {
            return null;
        }
        int[] values = this._directory.getIntArray(512);
        StringBuilder desc = new StringBuilder();
        if (values.length > 1) {
            switch (values[0]) {
                case 0: {
                    desc.append("Normal picture taking mode");
                    break;
                }
                case 1: {
                    desc.append("Unknown picture taking mode");
                    break;
                }
                case 2: {
                    desc.append("Fast picture taking mode");
                    break;
                }
                case 3: {
                    desc.append("Panorama picture taking mode");
                    break;
                }
                default: {
                    desc.append("Unknown picture taking mode");
                }
            }
            desc.append(" - ");
            switch (values[1]) {
                case 0: {
                    desc.append("Unknown sequence number");
                    break;
                }
                case 1: {
                    desc.append("1st in a sequnce");
                    break;
                }
                case 2: {
                    desc.append("2nd in a sequence");
                    break;
                }
                case 3: {
                    desc.append("3rd in a sequence");
                    break;
                }
                default: {
                    desc.append(values[1]);
                    desc.append("th in a sequence");
                }
            }
        }
        if (values.length > 2) {
            switch (values[2]) {
                case 1: {
                    desc.append("Left to right panorama direction");
                    break;
                }
                case 2: {
                    desc.append("Right to left panorama direction");
                    break;
                }
                case 3: {
                    desc.append("Bottom to top panorama direction");
                    break;
                }
                case 4: {
                    desc.append("Top to bottom panorama direction");
                }
            }
        }
        return desc.toString();
    }
}

