/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JFileChooser;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JDirectoryChooser;
import se.datadosen.component.JSwingFileChooser;
import se.datadosen.component.JXFileChooser;
import se.datadosen.component.MacAWTDirectoryChooser;
import se.datadosen.component.MacAWTFileChooser;
import se.datadosen.component.mac.FileChooserImpl;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.util.Platform;

public class ChooserFactory {
    public static DirectoryChooser createDirectoryChooser(Window parent) {
        if (parent instanceof Frame) {
            return ChooserFactory.createDirectoryChooser((Frame)parent);
        }
        if (parent instanceof Dialog) {
            return ChooserFactory.createDirectoryChooser((Dialog)parent);
        }
        throw new IllegalArgumentException("Parent must be either Frame or Dialog");
    }

    public static DirectoryChooser createDirectoryChooser(Frame parent) {
        if (Platform.isMac()) {
            return new MacAWTDirectoryChooser(parent);
        }
        return new DeferredChooser(JDirectoryChooser.class);
    }

    public static DirectoryChooser createDirectoryChooser(Dialog parent) {
        if (Platform.isMac()) {
            return new MacAWTDirectoryChooser(parent);
        }
        return new DeferredChooser(JDirectoryChooser.class);
    }

    public static FileChooser createFileChooser(Window parent) {
        if (parent instanceof Frame) {
            return ChooserFactory.createFileChooser((Frame)parent);
        }
        if (parent instanceof Dialog) {
            return ChooserFactory.createFileChooser((Dialog)parent);
        }
        throw new IllegalArgumentException("Parent must be either Frame or Dialog");
    }

    public static FileChooser createFileChooser(Frame parent) {
        if (Platform.isMac()) {
            return new MacAWTFileChooser(parent);
        }
        return new DeferredChooser(JFileChooser.class);
    }

    public static FileChooser createFileChooser(Dialog parent) {
        if (Platform.isMac()) {
            return new MacAWTFileChooser(parent);
        }
        return new DeferredChooser(JFileChooser.class);
    }

    public static FileChooser createFilesChooser(Frame parent) {
        if (Platform.isMac() && Config.getConfig().isUseNativeFileDialogs()) {
            try {
                return new FileChooserImpl();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        return Platform.isWindows() ? new JXFileChooser() : new JSwingFileChooser();
    }
}

