/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import se.datadosen.util.Platform;

public class JGlassButton
extends JButton {
    protected boolean mouseOver = false;
    protected boolean mousePressed = false;
    private int borderRadius = 5;
    private boolean uiSet = false;
    private BufferedImage buf;
    private float alpha = 1.0f;
    private float borderOpacity = 0.6f;
    private boolean discrete = false;

    public JGlassButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JGlassButton(Action a) {
        super(a);
        this.init();
    }

    public JGlassButton(String text) {
        super(text);
        this.init();
    }

    public JGlassButton(Icon icon) {
        super(icon);
        this.init();
    }

    public void setUI(ButtonUI newUI) {
        if (!this.uiSet) {
            super.setUI(newUI);
            this.uiSet = true;
        }
    }

    private void init() {
        super.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusable(false);
        this.setOpaque(false);
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void setVisible(boolean visible) {
        if (this.isVisible() && visible) {
            return;
        }
        if (visible) {
            this.alpha = 0.0f;
        }
        super.setVisible(visible);
        if (visible) {
            new Thread("animator"){

                public void run() {
                    try {
                        boolean keepRunning = true;
                        float a = 0.0f;
                        while (keepRunning) {
                            if (!JGlassButton.this.isVisible()) {
                                return;
                            }
                            if (a > 1.0f) {
                                a = 1.0f;
                                keepRunning = false;
                            }
                            JGlassButton.this.alpha = a;
                            JGlassButton.this.repaint();
                            1.sleep(20L);
                            a += 0.12f;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    public void paintComponentNow(Graphics g2d) {
        this.paintComponent(g2d);
    }

    protected void paintComponent(Graphics g2d) {
        if (this.discrete && !this.mouseOver && !this.mousePressed) {
            return;
        }
        if (this.buf == null || this.buf.getWidth() != this.getWidth() || this.buf.getHeight() != this.getHeight()) {
            this.buf = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        }
        Graphics2D g = this.buf.createGraphics();
        Composite c = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(1));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setComposite(c);
        g.setFont(g2d.getFont());
        AffineTransform backupTransform = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (Platform.isMac()) {
            g.translate(0.5, 0.5);
        }
        if (this.isEnabled()) {
            g.setColor(this.getBackground());
            g.setColor(this.mousePressed ? this.getBackground().darker() : this.getBackground());
        } else {
            g.setColor(SystemColor.textInactiveText);
        }
        Composite backup = g.getComposite();
        float mouseOverOpacity = Math.min(this.borderOpacity + 0.2f, 1.0f);
        if (!this.isEnabled()) {
            mouseOverOpacity = this.borderOpacity;
        }
        AlphaComposite composite = AlphaComposite.getInstance(3, this.mouseOver && !this.discrete ? mouseOverOpacity : this.borderOpacity);
        g.setComposite(composite);
        if (!this.discrete || !this.mouseOver && !this.mousePressed) {
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.borderRadius * 2, this.borderRadius * 2);
            if (backup != null) {
                g.setComposite(backup);
            }
            g.setTransform(backupTransform);
        }
        g.translate(-1, 0);
        super.paintComponent(g);
        g.dispose();
        composite = AlphaComposite.getInstance(3, this.alpha);
        ((Graphics2D)g2d).setComposite(composite);
        g2d.drawImage(this.buf, 0, 0, null);
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public void setDiscrete(boolean discrete) {
        this.discrete = discrete;
    }

    public int getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(int borderRadius) {
        this.borderRadius = borderRadius;
    }

    public float getBorderOpacity() {
        return this.borderOpacity;
    }

    public void setBorderOpacity(float borderOpacity) {
        this.borderOpacity = borderOpacity;
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        public void mouseClicked(MouseEvent e) {
            JGlassButton.this.mouseOver = false;
            JGlassButton.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            JGlassButton.this.mousePressed = true;
            JGlassButton.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            JGlassButton.this.mousePressed = false;
            JGlassButton.this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            JGlassButton.this.mouseOver = true;
            JGlassButton.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            JGlassButton.this.mouseOver = false;
            JGlassButton.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            JGlassButton.this.mouseOver = true;
            JGlassButton.this.repaint();
        }
    }
}

