/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;

abstract class AbstractEditor
extends JAlbumObject.LabelEditor {
    static KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
    static KeyStroke altEnterStroke = KeyStroke.getKeyStroke(10, 512);
    static KeyStroke shiftEnterStroke = KeyStroke.getKeyStroke(10, 64);
    protected AlbumObject ao;
    private boolean editing;
    protected WrappableJLabel label = new WrappableJLabel();
    protected JTextArea editArea;
    Dimension lastCaptionAreaDimension = new Dimension(0, 0);
    private JScrollPane scrollPane = new JScrollPane(21, 31);
    private Color deselectedTextColor = this.getTextColor();

    public abstract String readText();

    public abstract void writeText(String var1) throws IOException;

    public abstract String getPromptText();

    public void removeNotify() {
        super.removeNotify();
        this.remove(this.scrollPane);
        this.scrollPane.setViewportView(null);
        this.editArea = null;
    }

    public AbstractEditor(JAlbumObject jao) {
        super(jao);
        this.ao = jao.ao;
        this.init();
    }

    protected Color getTextColor() {
        return SystemColor.textText;
    }

    protected JTextArea getEditArea() {
        if (this.editArea == null) {
            this.editArea = new JTextArea(2, 10){
                {
                    this.addKeyListener(new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            if (event.getKeyCode() == 9 || event.getKeyChar() == '\t') {
                                JAlbumObject.tabCycling = true;
                                if (event.isShiftDown()) {
                                    AbstractEditor.this.jao.transferFocusBackward();
                                } else {
                                    AbstractEditor.this.editArea.transferFocus();
                                }
                                event.consume();
                            }
                        }
                    });
                }

                public boolean isManagingFocus() {
                    return true;
                }
            };
            this.editArea.setForeground(this.getTextColor());
            this.editArea.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    AbstractEditor.this.setEditing(false);
                }
            });
            this.editArea.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        AbstractEditor.this.editArea.setText(AbstractEditor.this.readText());
                        AbstractEditor.this.setEditing(false);
                    }
                }
            });
            this.editArea.setFont(this.label.getFont());
            this.editArea.setText(this.label.getText());
            this.editArea.setLineWrap(true);
            this.editArea.setWrapStyleWord(true);
            this.editArea.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    AbstractEditor.this.updateCaptionAreaSize();
                }

                public void removeUpdate(DocumentEvent e) {
                    AbstractEditor.this.updateCaptionAreaSize();
                }

                public void changedUpdate(DocumentEvent e) {
                    AbstractEditor.this.updateCaptionAreaSize();
                }
            });
            AbstractAction myEnterAction = new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    AbstractEditor.this.setEditing(false);
                }
            };
            InputMap im = this.editArea.getInputMap();
            Object enterActionKeyName = im.get(enterStroke);
            im.put(altEnterStroke, enterActionKeyName);
            im.put(shiftEnterStroke, enterActionKeyName);
            im.put(enterStroke, myEnterAction);
            this.scrollPane.setViewportView(this.editArea);
            this.add((Component)this.scrollPane, "South");
        }
        return this.editArea;
    }

    private void init() {
        this.label.setFont(labelFont);
        this.label.setForeground(this.getTextColor());
        this.label.setOpaque(true);
        this.label.setBackground(SystemColor.text);
        this.label.setHorizontalAlignment(0);
        int w = this.jao.context.iconBounds.width;
        this.label.setPreferredWidth(w);
        Insets in = new Insets(0, 0, 0, 0);
        Border originalScrollBorder = this.scrollPane.getBorder();
        if (originalScrollBorder != null) {
            in = originalScrollBorder.getBorderInsets(this.scrollPane);
            Border emptyBorder = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            this.label.setBorder(emptyBorder);
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)this.label, "North");
        this.scrollPane.setVisible(false);
        this.add((Component)this.scrollPane, "South");
        this.jao.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (e.getButton() == 0 && AbstractEditor.this.readText().length() == 0) {
                    AbstractEditor.this.label.setText(AbstractEditor.this.getPromptText());
                }
            }

            public void mouseExited(MouseEvent e) {
                AbstractEditor.this.refresh();
            }
        });
    }

    private void updateCaptionAreaSize() {
        Dimension dim = this.editArea.getPreferredSize();
        if (!dim.equals(this.lastCaptionAreaDimension)) {
            this.lastCaptionAreaDimension = dim;
            Insets in = new Insets(0, 0, 0, 0);
            Border originalScrollBorder = this.scrollPane.getBorder();
            if (originalScrollBorder != null) {
                in = originalScrollBorder.getBorderInsets(this.scrollPane);
            }
            dim = this.editArea.getPreferredSize();
            dim.width += in.left + in.right;
            dim.height += in.top + in.bottom;
            this.scrollPane.setPreferredSize(dim);
            this.revalidate();
        }
    }

    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        if (this.editArea != null && this.editArea.hasFocus()) {
            this.jao.requestFocusInWindow();
        }
        this.scrollPane.setVisible(editing);
        this.label.setVisible(!editing);
        if (editing) {
            this.getEditArea();
            this.editArea.setText(this.readText());
            this.validate();
            this.repaint();
            this.editArea.requestFocusInWindow();
            this.updateCaptionAreaSize();
        } else {
            String newCaption;
            if (this.editArea != null && !(newCaption = this.editArea.getText()).equals(this.readText())) {
                try {
                    this.writeText(newCaption);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.refresh();
            this.validate();
            this.repaint();
        }
    }

    void refresh() {
        String text = this.readText();
        if ("".equals(text)) {
            this.deselectedTextColor = SystemColor.textInactiveText;
            this.label.setText(this.ao.getName());
        } else {
            this.deselectedTextColor = this.getTextColor();
            this.label.setText(this.readText());
        }
        this.label.setForeground(this.jao.isSelected() ? SystemColor.textHighlightText : this.deselectedTextColor);
    }

    boolean isEditing() {
        return this.editing;
    }

    void setSelected(boolean selected) {
        if (selected) {
            this.label.setForeground(SystemColor.textHighlightText);
            this.label.setBackground(SystemColor.textHighlight);
        } else {
            this.label.setForeground(this.deselectedTextColor);
            this.label.setBackground(SystemColor.text);
        }
    }
}

