/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.FileNamerContext;

public class AlbumObjectFactory
implements Serializable,
PropertyChangeListener {
    AlbumBean engine;
    protected AlbumFileFilter filter;
    private boolean cacheThumbnails = true;
    private boolean includeExcluded = true;
    private boolean includeMissing = true;
    private boolean makingAlbum = false;

    public AlbumObjectFactory(AlbumBean engine) {
        this.engine = engine;
        engine.addPropertyChangeListener("directory", this);
    }

    public AlbumObject createInstance(File file) {
        return this.createInstance(file, (AlbumObject)null);
    }

    public AlbumObject createInstance(File file, FileNamerContext context) {
        return this.createInstance(file, context.getFolder());
    }

    public AlbumObject createInstance(File file, AlbumObject parent) {
        return new AlbumObjectImpl(file, parent, this);
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public boolean isIncludeExcluded() {
        return this.includeExcluded;
    }

    public void setIncludeExcluded(boolean includeExcluded) {
        this.includeExcluded = includeExcluded;
    }

    public boolean isIncludeMissing() {
        return this.includeMissing;
    }

    public void setIncludeMissing(boolean includeMissing) {
        this.includeMissing = includeMissing;
    }

    public boolean isMakingAlbum() {
        return this.makingAlbum;
    }

    public void setMakingAlbum(boolean makingAlbum) {
        this.makingAlbum = makingAlbum;
    }

    public AlbumFileFilter getFilter() {
        if (this.filter == null) {
            this.filter = new AlbumFileFilter(this.engine);
        }
        return this.filter;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.filter = null;
    }
}

