/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.ProgressEvent;
import se.datadosen.jalbum.event.TransferListener;
import se.datadosen.util.BeanBinder;

public class JAlbumConsole
implements AlbumBeanListener,
TransferListener {
    AlbumBean engine = new AlbumBean();
    UploadBean uploadBean = new UploadBean();
    JAlbumContext context = JAlbumContext.getInstance();

    public JAlbumConsole(Properties props) throws Exception {
        String skin;
        this.engine.addAlbumBeanListener(this);
        System.out.println(Msg.get("console.startupInfo", AlbumBean.getInternalVersion()));
        this.context.setEngine(this.engine);
        AlbumObjectFactory factory = new AlbumObjectFactory(this.engine);
        JAlbumContext.getInstance().setAlbumObjectfactory(factory);
        if (props.containsKey("help") || props.containsKey("?")) {
            Properties defs = BeanBinder.getProperties((Object)this.engine, true);
            BeanBinder.getProperties((Object)this.uploadBean, defs);
            defs.setProperty("projectFile", "");
            defs.setProperty("programDirectory", Config.getConfig().progDir.toString());
            defs.setProperty("skinsDirectory", Config.getConfig().skinsDir.toString());
            defs.setProperty("runTool", "");
            defs.setProperty("uploadAll", "");
            defs.setProperty("smartUpload", "");
            System.out.println("\n" + Msg.get("console.helpInfo"));
            for (Map.Entry<Object, Object> e : defs.entrySet()) {
                if (e.getKey().equals("class") || e.getKey().equals("userVariables") || e.getKey().equals("skinVariables")) continue;
                System.out.println("-" + e.getKey() + " " + e.getValue());
            }
            System.out.println(Msg.get("console.userVariableInfo"));
            System.out.println(Msg.get("console.requiredArgumentsInfo"));
            return;
        }
        if (props.containsKey("projectFile")) {
            AccountProfile account;
            File projectFile = new File(props.getProperty("projectFile"));
            Properties fileProps = JAlbumUtilities.importProject(projectFile);
            String accountProfileName = fileProps.getProperty("accountProfileName");
            if (accountProfileName != null && (account = AccountManager.getInstance().findAccountByName(accountProfileName)) != null) {
                BeanBinder.getProperties((Object)account, fileProps);
            }
            fileProps.putAll((Map<?, ?>)props);
            props = fileProps;
        }
        if ((skin = props.getProperty("skin")) != null) {
            this.engine.setSkin(skin);
            props.remove("skin");
        }
        this.engine.setProperties(props);
        String toolName = props.getProperty("runTool");
        if (toolName != null) {
            this.engine.init();
            this.engine.processBeanShellFile(new File(toolName));
        } else if (props.containsKey("uploadAll") || props.containsKey("smartUpload")) {
            BeanBinder.setProperties((Object)this.uploadBean, props);
            System.out.println("Connecting to " + this.uploadBean.getFtpServer() + " - " + this.uploadBean.getFtpUser());
            this.uploadAlbum(props.containsKey("uploadAll"));
        } else {
            if (props.containsKey("appendImages")) {
                this.engine.makeAlbum();
            } else {
                this.engine.smartMakeAlbum();
            }
            System.out.println(Msg.get("console.albumCreationInfo") + " " + this.engine.getOutputDirectory());
        }
    }

    public static void main(String[] args) throws Exception {
        Properties commandLineProperties = BeanBinder.parseArgsOptions(args);
        new JAlbumConsole(commandLineProperties);
    }

    private void uploadAlbum(boolean fullUpdate) throws Exception {
        this.uploadBean.addTransferListener(this);
        this.uploadBean.connect();
        this.uploadBean.uploadAlbum(this.context, fullUpdate);
    }

    public void imageProcessingStarted(AlbumBeanEvent e) {
        if (e.imageNum == 0) {
            System.out.println("\n" + Msg.get("console.processingInfo", e.directory, this.engine.getOutputDirectory()));
            System.out.println(e.msg);
        } else {
            System.out.print(Msg.get("console.FileInfo") + " " + e.msg + " (" + (e.processedFiles + 1) + "/" + e.totalFiles + ") ");
        }
    }

    public void imageProcessingFinished(AlbumBeanEvent e) {
        System.out.println(Msg.get("console.processingDoneInfo"));
    }

    public void fileProcessingStarted(ProgressEvent e) {
        if (e.processed == 0L) {
            System.out.println("\n" + Msg.get("console.processingInfo", e.directory, this.uploadBean.getFtpServer()));
            System.out.println(e.msg);
        } else {
            System.out.print(Msg.get("console.FileInfo") + " " + e.msg + " (" + e.processed + "/" + e.total + ") ");
        }
    }

    public void fileProcessingFinished(ProgressEvent e) {
        System.out.println(Msg.get("console.processingDoneInfo"));
    }

    public void errorOccured(Throwable t, File f) {
        System.err.println(Msg.get("console.errorProcessingInfo", f, t.toString()));
    }

    public void fileProcessingProgress(ProgressEvent e) {
        System.out.print(".");
    }
}

