/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;

public class Debug {
    public static void showErrorDialog(Component parent, Throwable t) {
        Debug.showErrorDialog(parent, t, false);
    }

    public static void showFriendlyErrorDialog(Component parent, Throwable t) {
        Debug.showErrorDialog(parent, t, true);
    }

    private static void showErrorDialog(Component parent, Throwable t, boolean friendly) {
        if (t instanceof RuntimeException && !(t instanceof IllegalArgumentException) || Config.getConfig().isDebugMode()) {
            Debug.showStackTraceDialog(parent, t);
        } else {
            Tracer.getInstance().trace("crash", t, new String[0]);
            String message = friendly && t.getMessage().length() > 0 ? t.getMessage() : t.toString();
            JOptionPane.showMessageDialog(parent, message, Msg.get("ui.errorOccured"), 0);
        }
    }

    public static void showStackTraceDialog(Component parent, Throwable t) {
        t.printStackTrace(System.out);
        Tracer.getInstance().trace("crash", t, new String[0]);
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println("An unexpected error occurred. Please see detailed description below:");
        err.println("");
        t.printStackTrace(err);
        err.close();
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        sp.getViewport().add((Component)ta, null);
        JCopyableOptionPane.showCopyableMessageDialog(parent, sp, sw.toString(), Msg.get("ui.unexpectedErrorOccured"), 0);
    }

    public static void showCopyableError(Component parent, Throwable t, String title) {
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println(t.getMessage());
        err.close();
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setColumns(80);
        ta.setRows(15);
        sp.getViewport().add((Component)ta, null);
        JCopyableOptionPane.showCopyableMessageDialog(parent, sp, sw.toString(), Msg.get("ui.unexpectedErrorOccured"), 0);
    }

    public static void printClassInfo(Class c) {
        System.out.println("Class info:");
        do {
            System.out.println(c.getName() + " Loader: " + c.getClassLoader());
        } while ((c = c.getSuperclass()) != null);
    }

    public static void log(String s) {
        if (Config.getConfig().isDebugMode()) {
            System.out.println(s);
        }
    }

    public static void logErr(String s) {
        if (Config.getConfig().isDebugMode()) {
            System.err.println(s);
        }
    }

    public static void logErr(Object o) {
        if (Config.getConfig().isDebugMode()) {
            System.err.println(o);
        }
    }

    private static class JCopyableOptionPane {
        private String stringMessage;
        private JButton copyButton = new JButton(Msg.get("ui.copyToClipboard"));
        private JButton okButton = new JButton(Msg.get("ok"));
        private JDialog dialog;

        public static void showCopyableMessageDialog(Component parentComponent, Object message, String stringMessage, String title, int messageType) throws HeadlessException {
            JCopyableOptionPane pane = new JCopyableOptionPane(parentComponent, message, stringMessage, title, messageType);
            pane.dialog.setVisible(true);
            pane.dialog.dispose();
        }

        private JCopyableOptionPane(Component parentComponent, Object message, String stringMessage, String title, int messageType) {
            this.stringMessage = stringMessage;
            this.copyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(JCopyableOptionPane.this.stringMessage), null);
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCopyableOptionPane.this.dialog.setVisible(false);
                }
            });
            JOptionPane pane = new JOptionPane(message, messageType, messageType, null, new Object[]{this.copyButton, this.okButton}, this.okButton);
            this.dialog = pane.createDialog(parentComponent, title);
            this.dialog.setResizable(true);
        }
    }
}

