import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.AlphaComposite;
import java.awt.geom.*;
import static java.lang.Math.*;
import javax.swing.ImageIcon;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Title:        JAlbum simple image filter adding image logotypes to images
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */

public class LogoFilter implements JAFilter {
    public static final String LEFT_ALIGNMENT = "left";
    public static final String CENTER_ALIGNMENT = "center";
    public static final String RIGHT_ALIGNMENT = "right";
    public static final String TOP_ALIGNMENT = "top";
    public static final String BOTTOM_ALIGNMENT = "bottom";

    // Default image
	ImageIcon logo = new ImageIcon();
    private String src;
    private String align = LEFT_ALIGNMENT;
    private String valign = TOP_ALIGNMENT;
    private int margin = 0;
    private int offset = 0;
    private int voffset = 0;
    private float angle = 0;    
    private int strengthPercent = 100;

		// Implements JAFilter
    public String getName() {
        return "Logo filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Add image logotypes to images";
    }

    public void setStrengthPercent(int newStrengthPercent) {
        strengthPercent = newStrengthPercent;
        if (strengthPercent > 100) strengthPercent = 100;
        else if (strengthPercent < 0) strengthPercent = 0;
    }

    public int getStrengthPercent() {
        return strengthPercent;
    }
    
    public void setAngle(float newAngle) {
        angle = newAngle;
    }
    public float getAngle() {
        return angle;
    }    

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, Map vars) {
    	if ("false".equals(vars.get("applyLogo"))) {
    		return bi;
    	}
    	    	
        int x,y;
		Graphics2D g = bi.createGraphics();        
        Image logoImage = logo.getImage();
		double bw = logoImage.getWidth(null);
		double bh = logoImage.getHeight(null);
        
		double radians = angle/180 * PI;
		double boxWidth = abs(bw * cos(radians)) + abs(bh * sin(radians));
		double boxHeight = abs(bh * cos(radians)) + abs(-bw * sin(radians));
		
        int width = bi.getWidth();
        int height = bi.getHeight();

        if (align.equals(LEFT_ALIGNMENT))
            x = margin;
        else if (align.equals(RIGHT_ALIGNMENT))
            x = (int)(width-margin-boxWidth);
        else // CENTER
            x = (int)((width-boxWidth)/2);

        if (valign.equals(TOP_ALIGNMENT))
            y = margin;
        else if (valign.equals(BOTTOM_ALIGNMENT))
            y = (int)(height-margin-boxHeight);
        else // CENTER
            y = (int)((height-boxHeight)/2);

        g.translate(x+boxWidth/2+offset, y+boxHeight/2+voffset);
        if (angle != 0) {
	        g.rotate(angle/180 * Math.PI);
        }

        AlphaComposite composite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, strengthPercent/100.f);
        g.setComposite(composite);
        g.drawImage(logoImage, (int)(-bw/2), (int)(-bh/2), null);
        return bi;
    }
    
    public void setSrc(String imageURL) throws IOException {
        URL url = new URL(imageURL);
        logo = new ImageIcon(url);
        src = imageURL;
    }

    public String getSrc() {
        return src;
    }

    public void setMargin(int newMargin) {
        margin = newMargin;
    }
    public int getMargin() {
        return margin;
    }
    public void setAlign(String newAlign) {
        align = newAlign;
    }
    public String getAlign() {
        return align;
    }
    public void setValign(String newValign) {
        valign = newValign;
    }
    public String getValign() {
        return valign;
    }
    public void setOffset(int newOffset) {
        offset = newOffset;
    }
    public int getOffset() {
        return offset;
    }
    public void setVoffset(int newVoffset) {
        voffset = newVoffset;
    }
    public int getVoffset() {
        return voffset;
    }
}