<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="$text.meta.iso" xml:lang="$text.meta.iso">	
	<head>
		<% totalThumbnailCount = totalImages; totalFolderCount = 0; maxHeight = 0; %>
		<ja:fileiterator nodirs="true">
			<% if (imageHeight > maxHeight) {
				maxHeight = imageHeight;
			} %>
		</ja:fileiterator>
		<ja:fileiterator dirs="true">
			<% totalFolderCount++; %>
		</ja:fileiterator>
		<% scrollerSize = ((thumbnailCount > totalThumbnailCount) || (thumbnailCount < 1)) ? totalThumbnailCount : thumbnailCount;
		navigation = totalThumbnailCount > 1;
		if (fastNavigationStep > (totalThumbnailCount - 1)) {
			fastNavigationStep = totalThumbnailCount - 1;
		}
		fastNavigation = useFastNavigation && ((totalThumbnailCount > fastNavigationStep) || alwaysUseFastNavigation);
		folders = showSubfolders && totalFolderCount > 0;
		preloads = preloadAllImages ? totalThumbnailCount : preloadImages; 
		preloads = preloads < 0 ? 0 : preloads; %>
		<ja:include page="includes/breadcrumbs.inc" />
		<%= if (indexNum == void || indexNum == 1) {
			if (!(title == null || title.trim().equals(""))) {
				currentBreadCrumbFolderName = stripHtml(title);
			} else {
				currentBreadCrumbFolderName = stripHtml(imageDirectory.getName()); 
			}
		}
		calculatePath(imageDirectory, level); %>
		<title><%= writeTitle(stripHtml(albumTitle), "&raquo;") %></title>
		<ja:include page="includes/pagemeta.inc" />
		<link href="${resPath}/galleria/galleria.css" rel="stylesheet" type="text/css" />
		<link href="${resPath}/index.css" rel="stylesheet" type="text/css" />		
		<link href="${resPath}/common.css" rel="stylesheet" type="text/css" />
		<ja:include page="includes/additional_styles.inc" />
		<script src="${resPath}/jquery.js" type="text/javascript"></script>
		<ja:include page="includes/additional_scripts.inc" />
	</head>
	<body>
		<% customNavigation = JAlbumUtilities.hasWebPages(rootFolder);
		borderClass = (pageType != "index") ? " no_border" : "border"; %>			
		<div id="header">
			<div id="top_container" class="${borderClass}">
				<ja:if test="<%= customHeader != null && customHeader.length() > 0 %>">
					${customHeader}
				</ja:if>
				<ja:if test="${customNavigation}">
					<% topNavigation = "";
						for (AlbumObject ao : rootFolder.getChildren()) {
							if (ao.isIncluded() && !ao.isHidden()) {
								cat = ao.getCategory();
								if ((isFolder = (cat == Category.folder)) || cat == Category.webPage) {
									Scope vars = ao.getVars();
									
									String path = isFolder ? urlEncode(vars.get("label")) : vars.get("closeupPath"); 
									topNavigation += "<a href=\"" + rootPath + "/" + path + (isFolder ? ("/" + indexName) : "") + "\">" + vars.get("title") + "</a>";
								}
							}
						}
					%>
					<ja:if test="${topNavigation}" not value="">
						<div class="top_navigation">${topNavigation}</div>
					</ja:if>
				</ja:if>
				<ja:if test="${pageType}" value="index">
					<ja:if test="<%= (level == 0 && showAlbumTitle) || (level > 0 && showTitles) %>">		
						<h1><ja:if exists="homepageAddress"><a href="${homepageAddress}">$text.content.home</a> &raquo; </ja:if><%= writePath(albumTitle, "&raquo;") %><ja:if test="<%= slideshowEnable && totalThumbnailCount > 0 %>"> <span id="slideshow">(<a class="play" href="javascript:void(0);" onclick="$.galleria.playSlideshow();">$text.content.playSlideshow</a><a class="pause" href="javascript:void(0);" onclick="$.galleria.pauseSlideshow();" style="display:none;">$text.content.pauseSlideshow</a>)</span></ja:if></h1>
					</ja:if>
					<ja:if test="<%= (level == 0 && showAlbumDescription) || (level > 0 && showDescriptions) %>">
						<ja:if exists="comment">
							<p class="description"><%= comment.replaceAll("\n", "<br />"); %></p>
						</ja:if>
						<ja:else>
							<ja:if exists="description">
								<p class="description"><%= description.replaceAll("\n", "<br />"); %></p>
							</ja:if>
						</ja:else>
					</ja:if>		
					<ja:if exists="indexNum">
						<ja:include page="includes/paging.inc" />
						<h2>$text.content.page: <%= paging %></h2>
					</ja:if>
				</ja:if>
			</div>
			<ja:if test="<%= (!customNavigation || level > 0) && folders %>">
				<div id="folders_container">
					<ul class="folders">
						<ja:fileiterator dirs="true">
							<li>						
								<a href="${closeupPath}">								
									<span>${title}</span>
									<ja:if not exists="iconPath">
										<img src="${thumbPath}" alt="<%= stripHtml(title) %>" title="<%= stripHtml(title) %>" style="width: ${thumbWidth}px; height: ${thumbHeight}px;" />
									</ja:if>
									<ja:else>
										<% folderIconSize = maxThumbWidth;
										folderIconMargin = 0;
										if (maxThumbWidth > maxFolderIconSize) {
											folderIconSize = maxFolderIconSize;
											folderIconMargin = (maxThumbWidth - maxFolderIconSize)/2;
										} %> 
										<img src="${resPath}/folder.png" alt="<%= stripHtml(title) %>" title="<%= stripHtml(title) %>" style="width: <%= folderIconSize %>px; height: <%= folderIconSize %>px; margin: <%= folderIconMargin %>px;" />
									</ja:else>
									</a>
							</li>			
						</ja:fileiterator>
						<div class="clear"></div>
					</ul>
					<div class="clear"></div>
				</div>
			</ja:if>	
		</div>
