/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.FolderInfo;
import component.IcbmCore;
import component.SetupUI;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import main.Nickname;
import main.Oscar;
import module.Module;
import module.aolim.ui.ImAttribute;
import module.aolim.ui.ImProps;
import module.aolim.ui.ImUI;
import module.aolim.ui.ImWindowProps;
import tool.BlockEvent;
import tool.EvilEvent;
import tool.ToolStatusEvent;
import tool.ToolStatusListener;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmEvent;
import tool.icbm.IcbmListener;
import tool.icbm.IcbmSubModule;
import uiutil.ChangeListener;
import uiutil.IUtil;
import uiutil.PropertySheet;
import uiutil.UIPack;
import util.EventBus;
import util.EventBusEvent;
import util.JUtil;
import util.KeyBindings;

public class UiBean
implements IcbmSubModule,
IcbmListener,
UIPack,
ToolStatusListener {
    private static String MODULE = "ImUiBean";
    public static String INITIATE = "INITATE";
    public static String INTERACTIVE = "INTERACTIVE";
    private Hashtable uis = new Hashtable();
    private ImAttribute icbmAttribute;
    EventBus eventBus;
    EventBus systemBus;
    static /* synthetic */ Class class$tool$ToolStatusEvent;
    static /* synthetic */ Class class$tool$icbm$IcbmEvent;
    static /* synthetic */ Class class$tool$icbm$IcbmRateEvent;

    public UiBean() {
        this.loadImAttribute();
        this.systemBus = EventBus.joinBus((String)EventBus.SYSTEM_BUS);
        this.systemBus.addListenerFor((EventListener)((Object)this), class$tool$ToolStatusEvent != null ? class$tool$ToolStatusEvent : (class$tool$ToolStatusEvent = UiBean.class$("tool.ToolStatusEvent")));
    }

    public void initiate(IcbmChannel icbmChannel, String string) {
        this.eventBus = EventBus.joinBus((String)string);
        this.eventBus.addListenerFor((EventListener)((Object)this), class$tool$icbm$IcbmEvent != null ? class$tool$icbm$IcbmEvent : (class$tool$icbm$IcbmEvent = UiBean.class$("tool.icbm.IcbmEvent")));
    }

    void removeUI(ImUI imUI, String string) {
        this.uis.remove(String.valueOf(Nickname.normalize((String)imUI.getNickname())) + string);
        this.systemBus.removeListenerFor((EventListener)imUI, class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = UiBean.class$("tool.icbm.IcbmRateEvent")));
    }

    public String getName() {
        return "Icbm";
    }

    public String getDisplayName() {
        return "Im";
    }

    ImAttribute getImAttribute() {
        return this.icbmAttribute;
    }

    private final void loadImAttribute() {
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(IcbmCore.IM_KEY);
        int n = 0;
        this.icbmAttribute = new ImAttribute();
        String string = keyBindings.getValue(IcbmCore.FONT_NAME_KEY);
        if (string != null) {
            this.icbmAttribute.fontName = string;
        }
        if ((string = keyBindings.getValue(IcbmCore.FONT_STYLE_KEY)) != null) {
            this.icbmAttribute.fontStyle = string.equalsIgnoreCase("bold") ? 1 : (string.equalsIgnoreCase("italic") ? 2 : (string.equalsIgnoreCase("bold italic") ? 3 : 0));
        }
        if ((string = keyBindings.getValue(IcbmCore.FONT_SIZE_KEY)) != null) {
            n = Integer.parseInt(string);
        }
        if (n < 8 || n > 24) {
            n = 12;
        }
        this.icbmAttribute.fontSize = n / 2 * 2;
        string = keyBindings.getValue(IcbmCore.FONT_FG_COLOR_KEY);
        if (string != null) {
            this.icbmAttribute.textFgColor = IUtil.getColorFromString((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.FONT_BG_COLOR_KEY)) != null) {
            this.icbmAttribute.textBgColor = IUtil.getColorFromString((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.LOCAL_NAME_COLOR_KEY)) != null) {
            this.icbmAttribute.myNameColor = IUtil.getColorFromString((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.REMOTE_NAME_COLOR_KEY)) != null) {
            this.icbmAttribute.otherNameColor = IUtil.getColorFromString((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.WINDOW_COLOR_KEY)) != null) {
            this.icbmAttribute.windowColor = IUtil.getColorFromString((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.SEND_SOUND_KEY)) != null) {
            this.icbmAttribute.playSendSound = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.RECEIVE_SOUND_KEY)) != null) {
            this.icbmAttribute.playReceiveSound = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.RING_SOUND_KEY)) != null) {
            this.icbmAttribute.playRingSound = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.TIMESTAMP_KEY)) != null) {
            this.icbmAttribute.viewTimeStamps = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmCore.ENTER_KEY)) != null) {
            this.icbmAttribute.enterKeyInserts = JUtil.isTrue((String)string);
        }
    }

    void attributeChanged() {
        Enumeration enumeration = this.uis.keys();
        while (enumeration.hasMoreElements()) {
            ImUI imUI = (ImUI)this.uis.get(enumeration.nextElement());
            imUI.setImAttribute(this.icbmAttribute);
        }
    }

    void sendEvil(String string, boolean bl) {
        EvilEvent evilEvent = new EvilEvent((Object)this, 1110, new Nickname(string), bl);
        this.systemBus.postEvent((EventBusEvent)evilEvent);
    }

    void block(String string) {
        BlockEvent blockEvent = new BlockEvent((Object)this, 1120, new Nickname(string));
        this.systemBus.postEvent((EventBusEvent)blockEvent);
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        FolderInfo[] folderInfoArray = new FolderInfo[3];
        folderInfoArray[0] = new FolderInfo((Module)this, 0, "IM", "Visual");
        folderInfoArray[1] = new FolderInfo((Module)this, 1, "IM", "General");
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        switch (folderInfo.getFolderId()) {
            case 0: {
                return new ImWindowProps(this, (ChangeListener)setupUI);
            }
            case 1: {
                return new ImProps(this, (ChangeListener)setupUI);
            }
        }
        return null;
    }

    public String getModuleName() {
        return "AolImUI";
    }

    public void receiveMessage(IcbmEvent icbmEvent) {
        ImUI imUI = (ImUI)this.uis.get(String.valueOf(icbmEvent.getNickname().normalize()) + INTERACTIVE);
        if (imUI == null) {
            imUI = new ImUI(this);
            this.systemBus.addListenerFor((EventListener)imUI, class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = UiBean.class$("tool.icbm.IcbmRateEvent")));
            this.uis.put(String.valueOf(icbmEvent.getNickname().normalize()) + INTERACTIVE, imUI);
        }
        imUI.receive(icbmEvent.getNickname().nickname, icbmEvent.getMessage(), 1);
    }

    public void sendMessage(IcbmEvent icbmEvent) {
        ImUI imUI = (ImUI)this.uis.get(String.valueOf(icbmEvent.getNickname().normalize()) + "INTERACTIVE");
        if (imUI != null) {
            imUI.receive(Oscar.nickname, icbmEvent.getMessage(), -1);
        }
    }

    public void sendMessage(String string, String string2) {
        IcbmEvent icbmEvent = new IcbmEvent((Object)this, 1102, 1, new Nickname(string), string2);
        this.eventBus.postEvent((EventBusEvent)icbmEvent);
    }

    public void initiateMessage(IcbmEvent icbmEvent) {
        ImUI imUI = (ImUI)this.uis.get(String.valueOf(icbmEvent.getNickname().normalize()) + INITIATE);
        if (imUI == null) {
            imUI = (ImUI)this.uis.get(String.valueOf(icbmEvent.getNickname().normalize()) + INTERACTIVE);
        }
        if (imUI == null) {
            imUI = new ImUI(this);
            this.systemBus.addListenerFor((EventListener)imUI, class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = UiBean.class$("tool.icbm.IcbmRateEvent")));
            this.uis.put(String.valueOf(icbmEvent.getNickname().normalize()) + INITIATE, imUI);
        }
        imUI.initiate(icbmEvent.getNickname().nickname);
    }

    public void payloadError(IcbmEvent icbmEvent) {
    }

    public void connect(ToolStatusEvent toolStatusEvent) {
    }

    public void disconnect(ToolStatusEvent toolStatusEvent) {
    }

    public void enableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            Enumeration enumeration = this.uis.keys();
            while (enumeration.hasMoreElements()) {
                ImUI imUI = (ImUI)this.uis.get(enumeration.nextElement());
                imUI.setEnabled(true);
            }
        }
    }

    public void disableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            Enumeration enumeration = this.uis.keys();
            while (enumeration.hasMoreElements()) {
                ImUI imUI = (ImUI)this.uis.get(enumeration.nextElement());
                imUI.setEnabled(false);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

