/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.responder;

import component.FolderInfo;
import component.OscarLabelButton;
import component.SetupUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.TimeZone;
import main.NativeMethods;
import main.Nickname;
import main.Oscar;
import module.Module;
import module.aolim.responder.ResponderProps;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmEvent;
import tool.icbm.IcbmListener;
import tool.icbm.IcbmSubModule;
import uiutil.ACheckbox;
import uiutil.AolRtfArea;
import uiutil.ChangeListener;
import uiutil.ImagePanel;
import uiutil.MultiLineLabel;
import uiutil.OFrame;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import uiutil.UIPack;
import util.EventBus;
import util.EventBusEvent;
import util.KeyBindings;

public class ResponderBean
implements IcbmSubModule,
IcbmListener,
ActionListener,
UIPack {
    private static String MODULE = "ResponderBean";
    byte[] currentMessage;
    byte[] idleMessage;
    byte[] awayMessage;
    int lastIdleTime = 99999999;
    Hashtable sentUsers;
    DateFormat timeFormat = DateFormat.getTimeInstance(3);
    DateFormat dateFormat = DateFormat.getDateInstance(3);
    DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3);
    EventBus eventBus;
    NewAwayUI newAwayUI;
    AwayUI awayUI;
    Menu awayMenu;
    KeyBindings keys;
    static /* synthetic */ Class class$tool$icbm$IcbmEvent;

    public ResponderBean() {
        try {
            File file = new File(String.valueOf(Oscar.CONFIG_DIR) + "Idle.msg");
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
            this.idleMessage = new byte[(int)file.length()];
            dataInputStream.readFully(this.idleMessage);
            dataInputStream.close();
        }
        catch (Exception exception) {
            this.idleMessage = null;
        }
        this.timeFormat.setTimeZone(TimeZone.getDefault());
        this.dateFormat.setTimeZone(TimeZone.getDefault());
        this.dateTimeFormat.setTimeZone(TimeZone.getDefault());
        this.awayMenu = new Menu("Away");
        this.awayMenu.addActionListener(this);
        this.createMenu();
        Oscar.mainTool.addMenuItem("People", (MenuItem)this.awayMenu);
    }

    void createMenu() {
        this.awayMenu.removeAll();
        MenuItem menuItem = new MenuItem("New Message");
        menuItem.setActionCommand("NEWMESSAGE");
        this.awayMenu.add(menuItem);
        this.awayMenu.addSeparator();
        this.keys = Oscar.config.getKeyBindingsOrAdd("im.responder.messages");
        int n = this.keys.size();
        int n2 = 0;
        while (n2 < n) {
            this.awayMenu.add(this.keys.getKeyAt(n2));
            ++n2;
        }
    }

    public void initiate(IcbmChannel icbmChannel, String string) {
        this.eventBus = EventBus.joinBus((String)string);
        this.eventBus.addListenerFor((EventListener)this, class$tool$icbm$IcbmEvent != null ? class$tool$icbm$IcbmEvent : (class$tool$icbm$IcbmEvent = ResponderBean.class$("tool.icbm.IcbmEvent")));
    }

    String getValue(byte by, Nickname nickname) {
        switch (by) {
            case 78: {
                return Oscar.nickname;
            }
            case 110: {
                return nickname.nickname;
            }
            case 104: {
                try {
                    return InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    return "";
                }
            }
            case 100: {
                return this.dateFormat.format(new Date());
            }
            case 68: {
                return this.dateTimeFormat.format(new Date());
            }
            case 116: {
                return this.timeFormat.format(new Date());
            }
            case 105: {
                return String.valueOf(NativeMethods.getIdleTime() / 60);
            }
        }
        return String.valueOf((char)by);
    }

    int find(int n, char c) {
        int n2 = 0;
        int n3 = n;
        while (n3 < this.currentMessage.length) {
            if (this.currentMessage[n3] == c && n2 == 0) {
                if (n3 == n) {
                    return n3;
                }
                int n4 = 0;
                int n5 = n3 - 1;
                while (n5 >= n && this.currentMessage[n5] == 37) {
                    ++n4;
                    --n5;
                }
                if (n4 % 2 == 0) {
                    return n3;
                }
            }
            if ((this.currentMessage[n3] == 40 || this.currentMessage[n3] == 91) && this.currentMessage[n3 - 1] == 37) {
                ++n2;
            }
            if ((this.currentMessage[n3] == 41 || this.currentMessage[n3] == 93) && this.currentMessage[n3 - 1] != 37) {
                --n2;
            }
            ++n3;
        }
        return -1;
    }

    String getString(int n, int n2) {
        return new String(this.currentMessage, n, n2 - n);
    }

    void process(StringBuffer stringBuffer, Nickname nickname, String string, int n, int n2) {
        try {
            int n3 = n;
            while (n3 < n2) {
                if (this.currentMessage[n3] == 37) {
                    switch (this.currentMessage[++n3]) {
                        case 40: {
                            String string2 = this.getValue(this.currentMessage[++n3], nickname);
                            int n4 = this.find(n3 + 2, ';');
                            int n5 = this.find(n4 + 1, ';');
                            int n6 = this.find(n5 + 1, ')');
                            String string3 = this.getString(n3 + 2, n4);
                            if (string3.equalsIgnoreCase(string2)) {
                                this.process(stringBuffer, nickname, string, n4 + 1, n5);
                            } else {
                                this.process(stringBuffer, nickname, string, n5 + 1, n6);
                            }
                            n3 = n6 + 1;
                            break;
                        }
                        case 91: {
                            int n7 = this.find(n3 + 1, ']');
                            int n4 = n3;
                            int n5 = 1;
                            while ((n4 = this.find(n4 + 1, ';')) != -1) {
                                ++n5;
                            }
                            int n6 = (int)(Math.random() * (double)n5);
                            n4 = n3;
                            int n8 = 0;
                            while (n8 < n6) {
                                n4 = this.find(n4 + 1, ';');
                                ++n8;
                            }
                            int n9 = this.find(n4 + 1, ';');
                            if (n9 == -1) {
                                n9 = n7;
                            }
                            this.process(stringBuffer, nickname, string, n4 + 1, n9);
                            n3 = n7 + 1;
                            break;
                        }
                        default: {
                            stringBuffer.append(this.getValue(this.currentMessage[n3], nickname));
                            break;
                        }
                    }
                } else if (this.currentMessage[n3] != 10) {
                    stringBuffer.append((char)this.currentMessage[n3]);
                }
                ++n3;
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("Idle.msg's syntax is incorrect");
            return;
        }
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        FolderInfo[] folderInfoArray = new FolderInfo[]{new FolderInfo((Module)this, 0, "IM", "Responder")};
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return new ResponderProps(this, (ChangeListener)setupUI);
    }

    public String getModuleName() {
        return "AolImResponder";
    }

    public void receiveMessage(IcbmEvent icbmEvent) {
        if (icbmEvent.isAutoResponse()) {
            return;
        }
        int n = NativeMethods.getIdleTime();
        if (this.awayUI != null) {
            this.currentMessage = this.awayMessage;
        } else {
            this.currentMessage = this.idleMessage;
            if (n < 1200) {
                return;
            }
            if (n < this.lastIdleTime) {
                this.sentUsers = new Hashtable();
            }
            this.lastIdleTime = n;
        }
        if (this.currentMessage == null) {
            return;
        }
        this.sentUsers.put(icbmEvent.getNickname().nickname, icbmEvent.getNickname().nickname);
        StringBuffer stringBuffer = new StringBuffer("<HTML>");
        this.process(stringBuffer, icbmEvent.getNickname(), icbmEvent.getMessage(), 0, this.currentMessage.length);
        stringBuffer.append("</HTML>");
        IcbmEvent icbmEvent2 = new IcbmEvent((Object)this, 1102, icbmEvent.getChannel(), icbmEvent.getNickname(), stringBuffer.toString(), null, true);
        this.eventBus.postEvent((EventBusEvent)icbmEvent2);
    }

    public void sendMessage(IcbmEvent icbmEvent) {
    }

    public void initiateMessage(IcbmEvent icbmEvent) {
    }

    public void payloadError(IcbmEvent icbmEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("NEWMESSAGE")) {
            if (this.newAwayUI == null) {
                this.newAwayUI = new NewAwayUI(this);
                return;
            }
        } else {
            this.awayMessage = actionEvent.getActionCommand().getBytes();
            if (this.awayUI == null) {
                this.awayUI = new AwayUI(this);
            }
            this.awayUI.setMessage(actionEvent.getActionCommand());
            this.sentUsers = new Hashtable();
        }
    }

    public String getName() {
        return "Responder";
    }

    public String getDisplayName() {
        return "Responder Bean";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NewAwayUI
    extends OFrame
    implements ActionListener {
        AolRtfArea dataDisplay;
        OscarLabelButton awayButton;
        ACheckbox saveCheck;
        UIPack uipack;

        NewAwayUI(UIPack uIPack) {
            super("New Away Message");
            ResponderBean.this = ResponderBean.this;
            this.uipack = uIPack;
            ImagePanel imagePanel = new ImagePanel((LayoutManager)new BorderLayout(5, 5));
            imagePanel.setTile(Oscar.images.getImage(null, Oscar.BG_TILE, (Component)imagePanel, true));
            ((Container)((Object)this)).add((Component)imagePanel);
            imagePanel.setLayout(new BorderLayout(5, 5));
            imagePanel.add("East", (Component)new Spacer());
            imagePanel.add("West", (Component)new Spacer());
            TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new FlowLayout());
            imagePanel.add("North", (Component)transparentPanel);
            transparentPanel.add((Component)new MultiLineLabel("Enter new Away Message:"));
            transparentPanel.add((Component)new Spacer());
            this.saveCheck = new ACheckbox("Save for later use.");
            transparentPanel.add((Component)this.saveCheck);
            this.dataDisplay = new AolRtfArea("New Away Message", null, true, true, -1, 0);
            imagePanel.add("Center", (Component)this.dataDisplay);
            transparentPanel = new TransparentPanel((LayoutManager)new FlowLayout());
            imagePanel.add("South", (Component)transparentPanel);
            this.awayButton = new OscarLabelButton("I'm Away", uIPack, (Component)transparentPanel);
            this.awayButton.addActionListener((ActionListener)this);
            transparentPanel.add((Component)this.awayButton);
            OscarLabelButton oscarLabelButton = new OscarLabelButton("Cancel", uIPack, (Component)transparentPanel);
            oscarLabelButton.addActionListener((ActionListener)this);
            transparentPanel.add((Component)oscarLabelButton);
            ((Window)((Object)this)).pack();
            ((Component)((Object)this)).setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResponderBean.this.newAwayUI = null;
            ((Component)((Object)this)).setVisible(false);
            if (actionEvent.getSource() == this.awayButton) {
                ResponderBean.this.awayMessage = this.dataDisplay.getText().getBytes();
                if (ResponderBean.this.awayUI == null) {
                    ResponderBean.this.awayUI = new AwayUI(this.uipack);
                }
                ResponderBean.this.awayUI.setMessage(this.dataDisplay.getText());
                ResponderBean.this.sentUsers = new Hashtable();
                if (this.saveCheck.getState()) {
                    ResponderBean.this.awayMenu.add(this.dataDisplay.getText());
                    ResponderBean.this.keys.setValue(this.dataDisplay.getText(), "");
                }
            }
        }

        public void dispose() {
            ResponderBean.this.newAwayUI = null;
            ((Component)((Object)this)).setVisible(false);
        }

        void setMessage(String string) {
            this.dataDisplay.setHTML(string);
        }
    }

    class AwayUI
    extends OFrame
    implements ActionListener {
        AolRtfArea dataDisplay;

        AwayUI(UIPack uIPack) {
            super("Away");
            ResponderBean.this = ResponderBean.this;
            ImagePanel imagePanel = new ImagePanel((LayoutManager)new BorderLayout(5, 5));
            imagePanel.setTile(Oscar.images.getImage(null, Oscar.BG_TILE, (Component)imagePanel, true));
            ((Container)((Object)this)).add((Component)imagePanel);
            imagePanel.add("East", (Component)new Spacer());
            imagePanel.add("West", (Component)new Spacer());
            imagePanel.add("North", (Component)new MultiLineLabel("The following Away message will be sent\nto any member who sends you an IM."));
            this.dataDisplay = new AolRtfArea("Display Away Message", null, true, false, -1, 0);
            imagePanel.add("Center", (Component)this.dataDisplay);
            TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new FlowLayout());
            imagePanel.add("South", (Component)transparentPanel);
            OscarLabelButton oscarLabelButton = new OscarLabelButton("I'm back!", uIPack, (Component)transparentPanel);
            oscarLabelButton.addActionListener((ActionListener)this);
            transparentPanel.add((Component)oscarLabelButton);
            ((Window)((Object)this)).pack();
            ((Component)((Object)this)).setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResponderBean.this.awayUI = null;
            ((Component)((Object)this)).setVisible(false);
        }

        void setMessage(String string) {
            this.dataDisplay.setHTML(string);
        }

        public void dispose() {
            ResponderBean.this.awayUI = null;
            ((Component)((Object)this)).setVisible(false);
        }
    }
}

