/*
 * Decompiled with CFR 0.152.
 */
package component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import main.Ad;
import main.AdListener;
import main.Oscar;
import uiutil.ImageButton;

class BillBoard
extends ImageButton
implements AdListener,
ActionListener {
    public static int BORDER = 2;
    private Image adImage;
    private Ad ad;
    private int spot;
    private Color darkColor = Color.black;
    private Color lightColor = Color.white;
    private Color rollColor = Color.yellow;

    public BillBoard(int n, int n2, int n3, int n4) {
        super(n + 2 * BORDER, n2 + 2 * BORDER);
        this.spot = n3;
        if (Oscar.adCore != null) {
            Oscar.adCore.registerSpot(n3, n4);
        }
        this.addActionListener(this);
    }

    public void addNotify() {
        super.addNotify();
        if (Oscar.adCore != null) {
            Oscar.adCore.spotAvailable(this.spot, this);
        }
    }

    public void removeNotify() {
        super.addNotify();
        if (Oscar.adCore != null && this.ad != null) {
            Oscar.adCore.spotUnavailable(this.spot, this, this.ad);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.adImage != null) {
            graphics.drawImage(this.adImage, BORDER, BORDER, this);
        } else {
            int n = (dimension.width - this.width) / 2;
            int n2 = (dimension.height - this.height) / 2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, this.width - 1, this.height - 1);
        }
        if (this.state == 1) {
            graphics.setColor(this.rollColor);
        } else if (this.state == 2) {
            graphics.setColor(this.darkColor);
        } else {
            graphics.setColor(this.lightColor);
        }
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        if (this.state == 1) {
            graphics.setColor(this.rollColor);
        } else if (this.state == 2) {
            graphics.setColor(this.lightColor);
        } else {
            graphics.setColor(this.darkColor);
        }
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
    }

    public void displayAd(int n, Ad ad) {
        if (this.adImage != null) {
            this.adImage.flush();
        }
        this.ad = ad;
        this.adImage = ad.getImage();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.ad != null && Oscar.adCore != null) {
            Oscar.adCore.adClicked(this.ad, this.ad.url);
        }
    }
}

