/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyAttribute;
import component.BuddyCore;
import component.SampleTextPanelB;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.ColorSelector;
import uiutil.ColorSelectorListener;
import uiutil.IUtil;
import uiutil.ImageButton;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;

public class BuddyWindowProps
extends PropertySheet
implements ActionListener,
ChangeListener,
ColorSelectorListener,
ItemListener {
    private static final String MODULE = "BuddyWindowProps";
    private BuddyCore core;
    private ChangeListener changeListener;
    private boolean changed = false;
    private ImageButton textFgColor;
    private ImageButton textBgColor;
    private Choice fontName;
    private Choice fontStyle;
    private Choice fontSize;
    private SampleTextPanelB rightPanel;
    private BuddyAttribute attribute;
    private int[] fontStyleArray = new int[]{0, 2, 1, 3};

    public BuddyWindowProps(BuddyCore buddyCore, ChangeListener changeListener) {
        this.core = buddyCore;
        this.attribute = buddyCore.getBuddyAttribute();
        this.changeListener = changeListener;
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        this.add("Center", transparentPanel);
        this.add("North", new Spacer());
        this.add("West", new Spacer());
        this.add("East", new Spacer());
        transparentPanel.setLayout(new GridLayout(1, 2, 0, 0));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.setLayout(new GridLayout(6, 1, 0, 0));
        this.rightPanel = new SampleTextPanelB(this);
        transparentPanel2.add(new Label("Text Color:"));
        TransparentPanel transparentPanel3 = new TransparentPanel();
        transparentPanel3.setLayout(new FlowLayout(0));
        this.textFgColor = new ImageButton(16, 16);
        transparentPanel3.add(this.textFgColor);
        this.textFgColor.addActionListener(this);
        transparentPanel3.add(new Label("Foreground"));
        transparentPanel2.add(transparentPanel3);
        transparentPanel3 = new TransparentPanel();
        transparentPanel3.setLayout(new FlowLayout(0));
        this.textBgColor = new ImageButton(16, 16);
        transparentPanel3.add(this.textBgColor);
        this.textBgColor.addActionListener(this);
        transparentPanel3.add(new Label("Background"));
        transparentPanel2.add(transparentPanel3);
        TransparentPanel transparentPanel4 = new TransparentPanel();
        transparentPanel4.setLayout(new BorderLayout());
        transparentPanel4.add("West", new Spacer());
        transparentPanel4.add("North", new Spacer());
        transparentPanel4.add("East", new Spacer());
        transparentPanel3 = new TransparentPanel();
        transparentPanel3.setLayout(new GridLayout(3, 3, 30, 0));
        transparentPanel3.add(new Label("Font Name"));
        transparentPanel3.add(new Label("Font Style"));
        transparentPanel3.add(new Label("Font Size"));
        this.fontName = new Choice();
        transparentPanel3.add(this.fontName);
        this.fontName.addItemListener(this);
        this.fontStyle = new Choice();
        transparentPanel3.add(this.fontStyle);
        this.fontStyle.addItemListener(this);
        this.fontSize = new Choice();
        transparentPanel3.add(this.fontSize);
        this.fontSize.addItemListener(this);
        transparentPanel3.add(new Spacer());
        transparentPanel4.add("Center", transparentPanel3);
        transparentPanel.add(transparentPanel2);
        transparentPanel3 = new TransparentPanel();
        transparentPanel3.setLayout(new BorderLayout());
        transparentPanel3.add("North", new Label("Sample Text"));
        transparentPanel3.add("Center", this.rightPanel);
        transparentPanel.add(transparentPanel3);
        this.add("South", transparentPanel4);
        this.setValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.textFgColor)) {
            new ColorSelector(this, object, "Text Foreground Color", this.textFgColor.getBackground(), this.textBgColor.getBackground(), true);
        } else if (object.equals(this.textBgColor)) {
            new ColorSelector(this, object, "Text Background Color", this.textFgColor.getBackground(), this.textBgColor.getBackground(), false);
        }
        this.setChanged(true);
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("BuddyWindow Help", "You can change the appearance of your buddy list using this setup screen. Press on the color button to change the color of the names in the buddy list and use the choice boxes to change the font name, style, and size. ");
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.fontName) || object.equals(this.fontStyle) || object.equals(this.fontSize)) {
            this.rightPanel.setFont(new Font(this.fontName.getSelectedItem(), this.fontStyleArray[this.fontStyle.getSelectedIndex()], this.fontSize.getSelectedIndex() + 8));
            this.setChanged(true);
        }
    }

    public void removeNotify() {
        this.removeAll();
        this.core = null;
        this.changeListener = null;
        this.rightPanel = null;
        if (this.textFgColor != null) {
            this.textFgColor.destroy();
            this.textFgColor = null;
        }
        if (this.textBgColor != null) {
            this.textBgColor.destroy();
            this.textBgColor = null;
        }
        super.removeNotify();
    }

    public boolean save() {
        this.attribute.setValues(this.textFgColor.getBackground(), this.textBgColor.getBackground(), this.fontName.getSelectedItem(), this.fontStyleArray[this.fontStyle.getSelectedIndex()], this.fontSize.getSelectedIndex() + 8);
        Oscar.config.setValue(BuddyCore.FONT_NAME_KEY, this.fontName.getSelectedItem());
        Oscar.config.setValue(BuddyCore.FONT_STYLE_KEY, this.fontStyle.getSelectedItem());
        Oscar.config.setValue(BuddyCore.FONT_SIZE_KEY, this.fontSize.getSelectedItem());
        Oscar.config.setValue(BuddyCore.TEXT_FGCOLOR_KEY, IUtil.getStringFromColor(this.textFgColor.getBackground()));
        Oscar.config.setValue(BuddyCore.TEXT_BGCOLOR_KEY, IUtil.getStringFromColor(this.textBgColor.getBackground()));
        this.core.attributeChanged();
        this.setChanged(false);
        return true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    private final void setFontCharacteristics() {
        this.fontName.addItem("Helvetica");
        this.fontName.addItem("TimesRoman");
        this.fontName.addItem("Courier");
        this.fontName.addItem("Dialog");
        this.fontName.addItem("DialogInput");
        this.fontName.addItem("ZapfDingbats");
        this.fontName.addItem("default");
        this.fontStyle.addItem("Plain");
        this.fontStyle.addItem("Italic");
        this.fontStyle.addItem("Bold");
        this.fontStyle.addItem("Bold Italic");
        int n = 8;
        while (n <= 24) {
            this.fontSize.addItem(String.valueOf(n));
            ++n;
        }
        this.fontName.select(this.attribute.fontName);
        if (this.attribute.fontStyle == 2) {
            this.fontStyle.select(1);
        } else if (this.attribute.fontStyle == 1) {
            this.fontStyle.select(2);
        } else if (this.attribute.fontStyle == 3) {
            this.fontStyle.select(3);
        } else {
            this.fontStyle.select(0);
        }
        this.fontSize.select(String.valueOf(this.attribute.fontSize));
    }

    public void setValues() {
        this.setFontCharacteristics();
        this.textFgColor.setBackground(this.attribute.textFgColor);
        this.textBgColor.setBackground(this.attribute.textBgColor);
        this.rightPanel.setFont(this.attribute.getFont());
        this.setChanged(false);
    }

    void colorChanged() {
        this.rightPanel.repaint();
    }

    Color[] getColor() {
        return new Color[]{this.textFgColor.getBackground(), this.textBgColor.getBackground()};
    }

    public void setColor(Object object, boolean bl, Color color) {
        ((Component)object).setBackground(color);
        this.colorChanged();
    }
}

