/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import uiutil.MultiLineLabel;
import uiutil.OFrame;

public class ImageButton
extends Component {
    protected static final int NORMAL = 0;
    protected static final int ROLLOVER = 1;
    protected static final int PUSHED = 2;
    protected static final int PUSHEDOUT = 3;
    protected static final int DISABLED = 4;
    protected static final int STATES = 5;
    protected Image[] images;
    protected int state = 0;
    protected int width = -1;
    protected int height;
    private MouseEvent mouseEvent;
    private ActionListener actionListener;
    private String actionCommand;
    protected boolean sticky;
    protected String label;
    private int labelX;
    private int labelY;
    private boolean focusTraversable;
    private boolean activateFocus = true;
    private Window popup;
    private String popupText;

    public ImageButton(Image image, Image image2, Image image3, Image image4) {
        this();
        this.setImages(image, image2, image3, image4);
    }

    public ImageButton(String string) {
        this();
        this.label = string;
        this.setLabel(string);
    }

    public ImageButton(int n, int n2) {
        this();
        this.width = n;
        this.height = n2;
        this.setSize(n, n2);
    }

    public ImageButton() {
        this.setForeground(Color.black);
        this.setBackground(Color.lightGray);
        this.enableEvents(60L);
    }

    public void addNotify() {
        super.addNotify();
        this.adjustDimension();
    }

    public void setPopupText(String string) {
        this.popupText = string;
        if (this.popup == null) {
            this.popup = new Window(OFrame.defaultFrame);
            this.popup.add("Center", new MultiLineLabel(this.popupText, 2, 2));
            ((Component)this.popup).setSize(100, 100);
            this.popup.pack();
            ((Component)this.popup).setBackground(Color.white);
            return;
        }
        this.popup.add("Center", new MultiLineLabel(this.popupText, 2, 2));
        ((Component)this.popup).setSize(100, 100);
        this.popup.pack();
    }

    public void removePopupText() {
        this.popup.dispose();
        this.popup = null;
        this.popupText = null;
    }

    public void setLabel(String string) {
        this.label = string;
        this.adjustDimension();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return this.label;
        }
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public String getLabel() {
        return this.label;
    }

    public void destroy() {
        this.images = null;
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    public void removeNotify() {
        this.destroy();
        super.removeNotify();
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public boolean isEnabled() {
        return this.state != 4;
    }

    public boolean isDown() {
        return this.state == 2;
    }

    public void adjustDimension() {
        FontMetrics fontMetrics;
        int n = 0;
        int n2 = 0;
        Font font = this.getFont();
        if (this.label != null && font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
            n2 = fontMetrics.stringWidth(this.label);
            if (n2 > this.width) {
                n = 5;
            }
            this.width = Math.max(this.width, n2) + 10;
            this.height = Math.max(this.height, fontMetrics.getHeight()) + 10;
            this.labelX = (this.width - n2) / 2 + n;
            this.labelY = (this.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        }
        if (this.width < 2 || this.height < 2) {
            this.height = 16;
            this.width = 16;
        }
        this.setSize(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void setImages(Image image, Image image2, Image image3, Image image4) {
        this.width = image.getWidth(this);
        this.height = image.getHeight(this);
        this.images = new Image[5];
        this.images[0] = this.images[3] = image;
        this.images[2] = image2;
        this.images[4] = image3;
        this.images[1] = image4;
        this.adjustDimension();
        if (this.isValid()) {
            this.repaint();
        }
    }

    public Image[] getImages() {
        return new Image[]{this.images[0], this.images[2], this.images[4], this.images[1]};
    }

    protected void setState(int n) {
        if (this.state != n) {
            this.state = n;
            this.repaint();
        }
    }

    public void setPushed() {
        this.setState(2);
    }

    public void setNormal() {
        this.setState(0);
    }

    public void toggle() {
        if (this.state == 2) {
            this.setFocus();
            return;
        }
        this.setPushed();
    }

    public void setFocusTraversable(boolean bl) {
        this.activateFocus = bl;
    }

    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public void setFocus() {
        this.setState(1);
    }

    public void removeFocus() {
        if (this.state == 1) {
            this.state = 0;
            this.repaint();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.setState(0);
            return;
        }
        this.setState(4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.focusTraversable = this.activateFocus;
        if (this.images != null) {
            graphics.drawImage(this.images[this.state], 0, 0, this.width, this.height, this);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            if (this.state == 1) {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 0, 0, this.height - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 0, 0, this.height - 1);
                graphics.setColor(Color.white);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
            }
        }
        if (this.label != null) {
            graphics.setColor(this.getForeground());
            graphics.drawString(this.label, this.labelX, this.labelY);
        }
    }

    protected void callAction() {
        if (this.mouseEvent != null) {
            return;
        }
        this.mouseEvent = new MouseEvent(this, 500, 0L, 0, 0, 0, 0, false);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(this.mouseEvent);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                if (mouseEvent != this.mouseEvent) break;
                new Event(this, 502, null);
                if (this.actionListener != null) {
                    ActionEvent actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
                    this.actionListener.actionPerformed(actionEvent);
                }
                this.mouseEvent = null;
                break;
            }
            case 504: {
                if (this.state == 4) break;
                if (this.popup != null && !this.popup.isVisible()) {
                    Point point = this.getLocationOnScreen();
                    ((Component)this.popup).setLocation(point.x + mouseEvent.getX(), point.y + mouseEvent.getY() + this.height / 2);
                    ((Component)this.popup).setVisible(true);
                }
                if (this.sticky) {
                    if (this.state == 2) break;
                    this.state = 1;
                } else {
                    if (this.state != 0) break;
                    this.state = 1;
                }
                this.repaint();
                break;
            }
            case 505: {
                if (this.popup != null && this.popup.isVisible()) {
                    ((Component)this.popup).setVisible(false);
                }
                if (this.state == 4 || this.state != 1) break;
                this.state = 0;
                this.repaint();
                break;
            }
            case 501: {
                if (this.state == 4) break;
                if (this.popup != null && this.popup.isVisible()) {
                    ((Component)this.popup).setVisible(false);
                }
                if (this.sticky) {
                    this.toggle();
                    break;
                }
                this.state = 2;
                this.repaint();
                break;
            }
            case 502: {
                if (this.sticky) {
                    this.callAction();
                    break;
                }
                if (this.state != 2 && this.state != 3) break;
                if (this.state == 2) {
                    this.callAction();
                }
                this.state = 0;
                this.repaint();
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (n == 506 && (this.state == 2 || this.state == 3)) {
            if (n2 < 0 || n3 < 0 || n2 > this.width || n3 > this.height) {
                this.setState(3);
            } else {
                this.setState(2);
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.state == 4 || this.sticky && this.state == 2) break;
                this.setFocus();
                break;
            }
            case 1005: {
                if (this.state == 4 || this.sticky && this.state == 2) break;
                this.state = 0;
                this.repaint();
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getID() == 401 && (n == 10 || n == 32) && this.state == 1) {
            new Event(this, 502, null);
            if (this.actionListener != null) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
                this.actionListener.actionPerformed(actionEvent);
            }
        }
        super.processKeyEvent(keyEvent);
    }
}

