/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import uiutil.ImageContainer;

public class LightBar
extends Canvas
implements Runnable {
    public static int MODE_OFF;
    public static int MODE_ON;
    public static int MODE_MOVE_RIGHT;
    public static int MODE_MOVE_LEFT;
    public static int MODE_FLASH;
    public static int MODE_BOUNCE;
    private int displayMode;
    private Color lightColor;
    private int lightDiameter = 8;
    private int lightCount = 5;
    private int lightGap = 2;
    private int hPad = 5;
    private int vPad = 5;
    private Image background;
    private Thread animator;
    private int animationIndex;
    private int animationDelay;
    private Color OffColor = new Color(75, 75, 75);
    private Color BorderColor = Color.black;
    private int SmallDiameter = 7;

    public LightBar(int n) {
        this.lightCount = n;
        this.lightColor = new Color(0, 172, 255);
        this.animator = null;
        this.animationIndex = 0;
        this.animationDelay = 150;
    }

    public void setColor(Color color) {
        this.lightColor = color;
        this.repaint();
    }

    public void setLightDiameter(int n) {
        this.lightDiameter = n;
        this.doLayout();
        this.setBackground();
        this.repaint();
    }

    public void setLightGap(int n) {
        this.lightGap = n;
        this.doLayout();
        this.setBackground();
        this.repaint();
    }

    public void setMode(int n) {
        this.displayMode = n;
        if (this.animator != null) {
            this.animator.stop();
            this.animator = null;
        }
        if (this.displayMode == MODE_MOVE_RIGHT || this.displayMode == MODE_MOVE_LEFT || this.displayMode == MODE_FLASH || this.displayMode == MODE_BOUNCE) {
            this.animator = new Thread(this);
            this.animator.start();
        }
        this.repaint();
    }

    public void setPads(int n, int n2) {
        this.hPad = n;
        this.vPad = n2;
        this.doLayout();
        this.setBackground();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        dimension.width = 2 * this.hPad + this.lightCount * this.lightDiameter + (this.lightCount - 1) * this.lightGap;
        dimension.height = 2 * this.vPad + this.lightDiameter;
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void run() {
        while (true) {
            if (this.displayMode == MODE_MOVE_RIGHT) {
                ++this.animationIndex;
                if (this.animationIndex >= this.lightCount) {
                    this.animationIndex = 0;
                }
            } else if (this.displayMode == MODE_MOVE_LEFT) {
                --this.animationIndex;
                if (this.animationIndex < 0) {
                    this.animationIndex = this.lightCount - 1;
                }
            } else if (this.displayMode == MODE_FLASH) {
                this.animationIndex = this.animationIndex != 0 ? 0 : 1;
            } else if (this.displayMode == MODE_BOUNCE) {
                ++this.animationIndex;
                if (this.animationIndex >= this.lightCount) {
                    this.animationIndex = -this.lightCount + 2;
                }
            }
            this.repaint();
            try {
                Thread.sleep(this.animationDelay);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void paint(Graphics graphics) {
        if (this.background == null) {
            this.setBackground();
        }
        if (this.background != null) {
            Graphics graphics2 = this.background.getGraphics();
            if (this.displayMode == MODE_OFF) {
                this.paintLights(graphics2, this.OffColor);
            } else if (this.displayMode == MODE_ON) {
                this.paintLights(graphics2, this.lightColor);
            } else if (this.displayMode == MODE_MOVE_RIGHT || this.displayMode == MODE_MOVE_LEFT) {
                this.paintLights(graphics2, this.lightColor, this.animationIndex);
            } else if (this.displayMode == MODE_FLASH) {
                if (this.animationIndex == 0) {
                    this.paintLights(graphics2, this.OffColor);
                } else {
                    this.paintLights(graphics2, this.lightColor);
                }
            } else if (this.displayMode == MODE_BOUNCE) {
                if (this.animationIndex < 0) {
                    this.paintLights(graphics2, this.lightColor, -this.animationIndex);
                } else {
                    this.paintLights(graphics2, this.lightColor, this.animationIndex);
                }
            }
            graphics.drawImage(this.background, 0, 0, this);
        }
    }

    private void paintLights(Graphics graphics, Color color) {
        graphics.setColor(color);
        int n = 0;
        while (n < this.lightCount) {
            if (this.lightDiameter <= this.SmallDiameter) {
                graphics.fillRect(this.hPad + n * (this.lightDiameter + this.lightGap) + 1, this.vPad + 1, this.lightDiameter - 2, this.lightDiameter - 2);
            } else {
                graphics.fillArc(this.hPad + n * (this.lightDiameter + this.lightGap) + 1, this.vPad + 1, this.lightDiameter - 2, this.lightDiameter - 2, 0, 360);
            }
            ++n;
        }
    }

    private void paintLights(Graphics graphics, Color color, int n) {
        this.paintLights(graphics, this.OffColor);
        graphics.setColor(color);
        if (this.lightDiameter <= this.SmallDiameter) {
            graphics.fillRect(this.hPad + n * (this.lightDiameter + this.lightGap) + 1, this.vPad + 1, this.lightDiameter - 2, this.lightDiameter - 2);
            return;
        }
        graphics.fillArc(this.hPad + n * (this.lightDiameter + this.lightGap) + 1, this.vPad + 1, this.lightDiameter - 2, this.lightDiameter - 2, 0, 360);
    }

    public void removeNotify() {
        this.lightColor = null;
        this.background = null;
        if (this.animator != null) {
            this.animator.stop();
            this.animator = null;
        }
        this.OffColor = null;
        this.BorderColor = null;
        super.removeNotify();
    }

    private void setBackground() {
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        ImageContainer imageContainer = (ImageContainer)((Object)this.getParent());
        Image image = imageContainer.getBackground(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.background = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics = this.background.getGraphics();
        graphics.drawImage(image, 0, 0, this);
        graphics.setColor(this.BorderColor);
        int n = 0;
        while (n < this.lightCount) {
            if (this.lightDiameter <= this.SmallDiameter) {
                int n2 = this.hPad + n * (this.lightDiameter + this.lightGap);
                int n3 = this.lightDiameter - 2;
                int n4 = this.lightDiameter - 1;
                graphics.drawLine(n2 + 1, this.vPad, n2 + n3, this.vPad);
                graphics.drawLine(n2 + 1, this.vPad + n4, n2 + n3, this.vPad + n4);
                graphics.drawLine(n2, this.vPad + 1, n2, this.vPad + n3);
                graphics.drawLine(n2 + n4, this.vPad + 1, n2 + n4, this.vPad + n3);
            } else {
                graphics.fillArc(this.hPad + n * (this.lightDiameter + this.lightGap), this.vPad, this.lightDiameter, this.lightDiameter, 0, 360);
            }
            ++n;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    static {
        MODE_ON = 1;
        MODE_MOVE_RIGHT = 2;
        MODE_MOVE_LEFT = 3;
        MODE_FLASH = 4;
        MODE_BOUNCE = 5;
    }
}

