/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import uiutil.ImagePanel;
import uiutil.LightBar;

public class LightTest
extends Frame
implements ActionListener,
TextListener {
    private static LightBar lights;
    private static Button onButton;
    private static Button offButton;
    private static Button leftButton;
    private static Button rightButton;
    private static Button flashButton;
    private static Button bounceButton;
    private static TextField sizeField;
    private static Button exitButton;

    public LightTest() {
        this.setTitle("Light Test");
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.gray);
        ImagePanel imagePanel = new ImagePanel();
        this.add("Center", imagePanel);
        lights = new LightBar(6);
        imagePanel.add(lights);
        lights.setLightDiameter(6);
        onButton = new Button("On");
        imagePanel.add(onButton);
        onButton.addActionListener(this);
        offButton = new Button("Off");
        imagePanel.add(offButton);
        offButton.addActionListener(this);
        leftButton = new Button("Left");
        imagePanel.add(leftButton);
        leftButton.addActionListener(this);
        rightButton = new Button("Right");
        imagePanel.add(rightButton);
        rightButton.addActionListener(this);
        flashButton = new Button("Flash");
        imagePanel.add(flashButton);
        flashButton.addActionListener(this);
        bounceButton = new Button("Bounce");
        imagePanel.add(bounceButton);
        bounceButton.addActionListener(this);
        sizeField = new TextField("6", 3);
        imagePanel.add(sizeField);
        sizeField.addTextListener(this);
        exitButton = new Button("Exit");
        imagePanel.add(exitButton);
        exitButton.addActionListener(this);
        this.pack();
    }

    public static void main(String[] stringArray) {
        LightTest lightTest = new LightTest();
        lightTest.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(onButton)) {
            lights.setColor(Color.green);
            lights.setMode(LightBar.MODE_ON);
            return;
        }
        if (object.equals(offButton)) {
            lights.setMode(LightBar.MODE_OFF);
            return;
        }
        if (object.equals(leftButton)) {
            lights.setColor(new Color(0, 255, 255));
            lights.setMode(LightBar.MODE_MOVE_LEFT);
            return;
        }
        if (object.equals(rightButton)) {
            lights.setColor(new Color(0, 255, 255));
            lights.setMode(LightBar.MODE_MOVE_RIGHT);
            return;
        }
        if (object.equals(flashButton)) {
            lights.setColor(Color.red);
            lights.setMode(LightBar.MODE_FLASH);
            return;
        }
        if (object.equals(bounceButton)) {
            lights.setColor(new Color(0, 255, 255));
            lights.setMode(LightBar.MODE_BOUNCE);
            return;
        }
        if (object.equals(exitButton)) {
            System.exit(0);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        String string = sizeField.getText();
        int n = 6;
        try {
            n = new Integer(string);
            lights.setLightDiameter(n);
            this.pack();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
    }
}

