/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;

public class ListItem {
    private String head;
    private String tail;
    int rowNumber;
    int width;
    int height;
    boolean selected;
    private Color background;
    private Color foreground;
    private boolean editMode;
    private boolean disabled;
    private Color textColor;

    public ListItem() {
        this.head = "";
        this.tail = "";
    }

    public ListItem(String string) {
        this(string, Color.black, Color.white);
    }

    public ListItem(String string, Color color, Color color2) {
        this.height = 15;
        this.updateItem(string, color, color2);
    }

    public void destroy() {
        this.head = null;
        this.tail = null;
        this.background = null;
        this.foreground = null;
        this.textColor = null;
    }

    public void setEnabled(boolean bl) {
        this.disabled = !bl;
    }

    public void processKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 37) {
            if (this.head.length() > 0) {
                int n2 = this.head.length() - 1;
                this.tail = String.valueOf(this.head.charAt(n2)) + this.tail;
                this.head = this.head.substring(0, n2);
            }
            return;
        }
        if (n == 39) {
            if (this.tail.length() > 0) {
                this.head = String.valueOf(this.head) + this.tail.charAt(0);
                this.tail = this.tail.substring(1, this.tail.length());
            }
            return;
        }
        if (n == 8) {
            if (this.head.length() > 0) {
                this.head = this.head.substring(0, this.head.length() - 1);
                return;
            }
        } else if (n == 127) {
            if (this.tail.length() > 0) {
                this.tail = this.tail.substring(1, this.tail.length());
                return;
            }
        } else if (n != 16 && n != 20 && n != 9) {
            this.head = String.valueOf(this.head) + keyEvent.getKeyChar();
        }
    }

    public void clear() {
        this.head = "";
        this.tail = "";
        this.editMode = true;
    }

    public void updateItem(String string, Color color, Color color2) {
        this.head = string;
        this.tail = "";
        this.setColors(color2, color);
    }

    public String getItem() {
        return String.valueOf(this.head) + this.tail;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
    }

    void setColors(Color color, Color color2) {
        this.foreground = color;
        this.background = color2;
    }

    public void paint(Graphics graphics, int n) {
        if (graphics == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.height = fontMetrics.getHeight();
        this.width = fontMetrics.stringWidth(String.valueOf(this.head) + this.tail + 1);
        int n2 = 2;
        int n3 = n * (this.height + 2);
        this.rowNumber = n;
        if (this.selected && !this.disabled) {
            graphics.setColor(this.foreground);
            graphics.fillRect(0, n3 - 1, this.width + 2, this.height + 2);
            graphics.setColor(this.background);
            graphics.drawRect(1, n3, this.width - 1, this.height - 1);
        } else {
            graphics.setColor(this.background);
            graphics.fillRect(0, n3, this.width, this.height);
            graphics.setColor(this.foreground);
        }
        int n4 = n2;
        int n5 = (this.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (this.head.length() > 0) {
            n4 = n2 + fontMetrics.stringWidth(this.head.toString());
            if (this.disabled) {
                graphics.setColor(Color.white);
                graphics.drawString(this.head.toString(), n2 + 1, n3 + 1 + n5);
                graphics.setColor(Color.gray);
            }
            graphics.drawString(this.head.toString(), n2, n3 + n5);
        }
        if (this.selected && !this.disabled) {
            this.textColor = graphics.getColor();
            graphics.setColor(Color.green);
            graphics.drawLine(n4, n3 + 1, n4, n3 - 2 + this.height);
            graphics.setColor(this.textColor);
        }
        if (this.tail.length() > 0) {
            if (this.disabled) {
                graphics.setColor(Color.white);
                graphics.drawString(this.tail.toString(), n4 + 1, n3 + 1 + n5);
                graphics.setColor(Color.gray);
            }
            graphics.drawString(this.tail.toString(), n4, n3 + n5);
        }
    }

    public boolean within(int n, int n2) {
        int n3 = this.height + 1;
        int n4 = n3 + 1;
        return n2 >= this.rowNumber * n3 && n2 <= (this.rowNumber + 1) * n4;
    }

    public void toggle() {
        if (this.selected) {
            this.deselect();
            return;
        }
        this.select();
    }

    public void deselect() {
        this.selected = false;
        this.editMode = false;
    }

    public void select() {
        this.selected = true;
    }
}

