/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import uiutil.MediaStoreItem;
import util.JarFile;

public class MediaStore {
    protected static Hashtable media = new Hashtable();
    public static final int ALL = 0;
    public static final int SOUNDS = 1;
    public static final int IMAGES = 2;

    public static void addMedia(String string, String string2, int n) {
        File file;
        try {
            file = new File(String.valueOf(string) + ".uipack.jar");
            if (file.exists()) {
                MediaStore.loadJarFileInfo(file, string2, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            file = new File(String.valueOf(string) + ".uipack");
            if (file.isDirectory()) {
                MediaStore.loadDirInfo(file, string2, n);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean unloadMedia(String string, String string2, String string3) {
        MediaStoreItem mediaStoreItem = MediaStore.getMSI(string, "images", string3);
        if (mediaStoreItem == null) {
            return false;
        }
        mediaStoreItem.object = null;
        return true;
    }

    public static Image getImage(String string, String string2) {
        return MediaStore.getImage(string, string2, true);
    }

    public static Image getImage(String string, String string2, boolean bl) {
        MediaStoreItem mediaStoreItem = MediaStore.getMSI(string, "images", string2);
        if (mediaStoreItem == null) {
            return null;
        }
        if (mediaStoreItem.object == null) {
            Image image;
            if (mediaStoreItem.jarFile == null) {
                image = Toolkit.getDefaultToolkit().getImage(mediaStoreItem.filename);
            } else {
                byte[] byArray = mediaStoreItem.jarFile.getBytes(mediaStoreItem.filename);
                image = Toolkit.getDefaultToolkit().createImage(byArray);
            }
            if (bl) {
                mediaStoreItem.object = image;
            } else {
                return image;
            }
        }
        return (Image)mediaStoreItem.object;
    }

    public static InputStream getSound(String string, String string2) {
        MediaStoreItem mediaStoreItem = MediaStore.getMSI(string, "sounds", string2);
        if (mediaStoreItem == null) {
            return null;
        }
        if (mediaStoreItem.object != null) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)mediaStoreItem.object;
            byteArrayInputStream.reset();
            return byteArrayInputStream;
        }
        try {
            if (mediaStoreItem.jarFile == null) {
                return new FileInputStream(mediaStoreItem.filename);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mediaStoreItem.jarFile.getBytes(mediaStoreItem.filename));
            mediaStoreItem.object = byteArrayInputStream;
            return byteArrayInputStream;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void loadJarFileInfo(File file, String string, int n) {
        try {
            JarFile jarFile = new JarFile(file.getPath());
            Enumeration enumeration = jarFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string2 = zipEntry.getName();
                if ((n == 1 || n == 0) && string2.startsWith("sounds/") && string2.endsWith(".au")) {
                    media.put(String.valueOf(string) + '/' + string2, new MediaStoreItem(string2, jarFile));
                }
                if (n != 2 && n != 0 || !string2.startsWith("images/") || !string2.endsWith(".gif")) continue;
                media.put(String.valueOf(string) + '/' + string2, new MediaStoreItem(string2, jarFile));
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void loadDirInfo(File file, String string, int n) {
        int n2;
        String[] stringArray;
        File file2;
        if (n == 1 || n == 0) {
            file2 = new File(file, "sounds");
            stringArray = file2.list();
            n2 = 0;
            while (stringArray != null && n2 < stringArray.length) {
                media.put(String.valueOf(string) + "/sounds/" + stringArray[n2], new MediaStoreItem(String.valueOf(file2.getPath()) + File.separator + stringArray[n2]));
                ++n2;
            }
        }
        if (n == 2 || n == 0) {
            file2 = new File(file, "images");
            stringArray = file2.list();
            n2 = 0;
            while (stringArray != null && n2 < stringArray.length) {
                media.put(String.valueOf(string) + "/images/" + stringArray[n2], new MediaStoreItem(String.valueOf(file2.getPath()) + File.separator + stringArray[n2]));
                ++n2;
            }
        }
    }

    private static MediaStoreItem getMSI(String string, String string2, String string3) {
        String string4 = "tools/" + string.replace(' ', '_') + "/" + string2 + "/" + string3;
        MediaStoreItem mediaStoreItem = (MediaStoreItem)media.get(string4);
        if (mediaStoreItem == null && (mediaStoreItem = (MediaStoreItem)media.get(string4 = "tools/share/" + string2 + "/" + string3)) == null) {
            return null;
        }
        return mediaStoreItem;
    }
}

