/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import rath.jmsn.ToolBox;
import rath.jmsn.util.UserStatusBox;
import rath.msnm.BuddyList;
import rath.msnm.entity.Group;
import rath.msnm.entity.MsnFriend;

public class BuddyRenderer
extends DefaultTreeCellRenderer
implements ToolBox {
    public static final int VIEW_FRIENDLY_NAME = 1;
    public static final int VIEW_LOGIN_NAME = 2;
    private MsnFriend friend = null;
    private boolean sel = false;
    private Object obj = null;
    private Color selectedBack = new Color(-2140772711);
    private Color backColor = new Color(-2130706433);
    private Color selectedFore = Color.white;
    private Color foreColor = Color.black;
    private Color dragFore = new Color(16428080);
    private int draggingGroup = -1;
    private int viewMode = 1;
    private ImageIcon imageOnline;
    private ImageIcon imageOffline;
    private ImageIcon imageBRB;
    private ImageIcon imageBusy;
    private ImageIcon imageLunch;
    private ImageIcon imagePhone;
    private ImageIcon imageAway;
    private ImageIcon imageIdle;
    private ImageIcon imageBlock;
    BuddyList forward = null;
    BuddyList block = null;

    public BuddyRenderer() {
        this.setOpaque(false);
        this.setFont(ToolBox.FONT_10);
        this.imageOnline = new ImageIcon(this.getIconResource("online.gif"));
        this.imageOffline = new ImageIcon(this.getIconResource("offline.gif"));
        this.imageBusy = new ImageIcon(this.getIconResource("busy.gif"));
        this.imageBRB = new ImageIcon(this.getIconResource("brb.gif"));
        this.imageLunch = new ImageIcon(this.getIconResource("lunch.gif"));
        this.imagePhone = new ImageIcon(this.getIconResource("call.gif"));
        this.imageIdle = new ImageIcon(this.getIconResource("autoleft.gif"));
        this.imageAway = new ImageIcon(this.getIconResource("left.gif"));
        this.imageBlock = new ImageIcon(this.getIconResource("fuck.gif"));
    }

    public void setForeColor(Color c) {
        this.foreColor = c;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public void setDraggingGroup(int index) {
        this.draggingGroup = index;
    }

    public int getDraggingGroup() {
        return this.draggingGroup;
    }

    public void setBuddyView(int mode) {
        this.viewMode = mode;
    }

    public int getBuddyView() {
        return this.viewMode;
    }

    private URL getIconResource(String name) {
        return this.getClass().getResource("/resources/icon/" + name);
    }

    protected String getGroupText(DefaultMutableTreeNode groupNode, String str) {
        if (this.forward == null) {
            return "";
        }
        Integer groupIndex = ((Group)groupNode.getUserObject()).getIndex();
        int total = 0;
        Iterator i = this.forward.iterator();
        while (i.hasNext()) {
            MsnFriend friend = (MsnFriend)i.next();
            if (!groupIndex.equals(friend.getGroupIndex())) continue;
            ++total;
        }
        int online = 0;
        Enumeration<TreeNode> e = groupNode.children();
        while (e.hasMoreElements()) {
            MsnFriend friend = (MsnFriend)((DefaultMutableTreeNode)e.nextElement()).getUserObject();
            if (friend.getStatus().equals("FLN")) continue;
            ++online;
        }
        return str + " (" + online + "/" + total + ")";
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object obj;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.obj = obj = node.getUserObject();
        int groupIndex = -1;
        if (obj instanceof MsnFriend) {
            this.friend = (MsnFriend)obj;
            groupIndex = this.friend.getGroupIndex();
            String status = this.friend.getStatus();
            if (status == null || status.equals("NLN")) {
                status = "";
                this.setIcon(this.imageOnline);
            } else {
                this.setIcon(this.imageOnline);
                if (status.equals("BRB")) {
                    this.setIcon(this.imageBRB);
                } else if (status.equals("IDL")) {
                    this.setIcon(this.imageIdle);
                } else if (status.equals("AWY")) {
                    this.setIcon(this.imageAway);
                } else if (status.equals("BSY")) {
                    this.setIcon(this.imageBusy);
                } else if (status.equals("LUN")) {
                    this.setIcon(this.imageLunch);
                } else if (status.equals("PHN")) {
                    this.setIcon(this.imagePhone);
                } else if (status.equals("FLN") || status.equals("HDN")) {
                    this.setIcon(this.imageOffline);
                }
                status = " (" + UserStatusBox.getFormattedUserStatus(this.friend.getStatus()) + ")";
            }
            if (this.block != null && this.block.get(this.friend.getLoginName()) != null) {
                this.setIcon(this.imageBlock);
            }
            switch (this.viewMode) {
                case 1: {
                    this.setText(this.friend.getFormattedFriendlyName().concat(status));
                    break;
                }
                case 2: {
                    this.setText(this.friend.getLoginName().concat(status));
                    break;
                }
                case 3: {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.friend.getFormattedFriendlyName());
                    sb.append('(');
                    sb.append(this.friend.getLoginName());
                    sb.append(") ");
                    sb.append(status);
                    this.setText(sb.toString());
                }
            }
        } else if (obj instanceof Group) {
            Group group = (Group)obj;
            groupIndex = group.getIndexInt();
            this.setIcon(null);
            this.setText(this.getGroupText(node, group.getFormattedName()));
        }
        this.sel = sel;
        this.setBackground(sel ? this.selectedBack : this.backColor);
        this.setForeground(sel ? this.selectedFore : (this.draggingGroup == groupIndex ? this.dragFore : this.foreColor));
        return this;
    }

    public void paint(Graphics g) {
        if (this.obj instanceof MsnFriend || this.obj instanceof Group) {
            int x = 1;
            int w = this.getWidth();
            int h = this.getHeight();
            ImageIcon icon = (ImageIcon)this.getIcon();
            String text = this.getText();
            FontMetrics fm = g.getFontMetrics(this.getFont());
            if (icon != null) {
                g.drawImage(icon.getImage(), x, h - icon.getIconHeight() >> 1, this);
                x += icon.getIconWidth();
            }
            if (this.sel) {
                g.setColor(this.getBackground());
                g.fillRect(x, 0, w, h);
            }
            g.setFont(this.getFont());
            g.setColor(this.getForeground());
            int y = (h >> 1) + (fm.getAscent() >> 1) - (fm.getDescent() >> 1) - 1;
            g.drawString(text, x + 2, y);
        } else {
            super.paint(g);
        }
    }
}

