/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import rath.jmsn.MainFrame;
import rath.jmsn.NativeToolkit;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.Msg;
import rath.jmsn.util.MusicBox;
import rath.msnm.LocalCopy;
import rath.msnm.MSNMessenger;

public class OptionDialog
extends DefaultDialog
implements ToolBox {
    private JTextField nickField = null;
    private JTextField downField = null;
    private JTextField chatlogField = null;
    private JTextField bgImageField = null;
    private JButton findButton0;
    private JButton findButton1;
    private JButton findButton2;
    private JButton colorButton = null;
    private JCheckBox loginCheck = null;
    private JCheckBox messageCheck = null;
    private JCheckBox fileAutoAcceptCheck = null;
    private JCheckBox tstampCheck = null;
    private JCheckBox emoticonCheck = null;
    private JCheckBox fixedFontFaceCheck = null;
    private MSNMessenger msnm = null;
    private String initFriendlyName = null;

    public OptionDialog(Frame owner, MSNMessenger msnm) {
        super(owner);
        this.msnm = msnm;
        this.setTitle(Msg.get("title.option"));
        this.createUI();
    }

    private void createUI() {
        this.setSize(400, 360);
        JPanel panel = (JPanel)this.getContentPane();
        JTabbedPane pane = new JTabbedPane();
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)this.createGeneralTab(), "General");
        pane.add((Component)this.createMediaTab(), "Graphics");
        panel.add((Component)pane, "Center");
        panel.add((Component)this.createBottomPanel(), "South");
    }

    private JPanel createGeneralTab() {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(layout);
        JPanel nickPanel = new JPanel(new BorderLayout(5, 5));
        nickPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        nickPanel.setAlignmentX(0.0f);
        JLabel nickLabel = new JLabel(Msg.get("label.friendlyname"));
        nickLabel.setFont(ToolBox.FONT);
        this.nickField = new JTextField();
        this.nickField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.processConfirm();
            }
        });
        this.nickField.setFont(ToolBox.FONT);
        nickPanel.add((Component)nickLabel, "West");
        nickPanel.add((Component)this.nickField, "Center");
        panel.add(nickPanel);
        panel.add(this.createDummyPanel(5));
        this.loginCheck = new JCheckBox(Msg.get("label.sound.login"));
        this.loginCheck.setFont(ToolBox.FONT);
        this.messageCheck = new JCheckBox(Msg.get("label.sound.msg"));
        this.messageCheck.setFont(ToolBox.FONT);
        this.fileAutoAcceptCheck = new JCheckBox(Msg.get("label.file.auto.accept"));
        this.fileAutoAcceptCheck.setFont(ToolBox.FONT);
        panel.add(this.loginCheck);
        panel.add(this.messageCheck);
        panel.add(this.fileAutoAcceptCheck);
        panel.add(this.createDummyPanel(24));
        JLabel downLabel = new JLabel(Msg.get("label.folder.download"));
        downLabel.setFont(ToolBox.FONT);
        panel.add(downLabel);
        JPanel downPanel = new JPanel(new BorderLayout(5, 5));
        downPanel.setAlignmentX(0.0f);
        downPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        this.downField = new JTextField();
        this.downField.setEditable(false);
        this.downField.setFont(ToolBox.FONT);
        this.findButton0 = new JButton(Msg.get("button.find"));
        this.findButton0.setFont(ToolBox.FONT);
        this.findButton0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File dir = OptionDialog.this.selectDirectory(OptionDialog.this.downField.getText());
                if (dir != null) {
                    OptionDialog.this.downField.setText(dir.getAbsolutePath());
                }
            }
        });
        downPanel.add((Component)this.downField, "Center");
        downPanel.add((Component)this.findButton0, "East");
        panel.add(downPanel);
        panel.add(this.createDummyPanel(5));
        JLabel logLabel = new JLabel(Msg.get("label.folder.chatlog"));
        logLabel.setFont(ToolBox.FONT);
        panel.add(logLabel);
        JPanel logPanel = new JPanel(new BorderLayout(5, 5));
        logPanel.setAlignmentX(0.0f);
        logPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        this.chatlogField = new JTextField();
        this.chatlogField.setEditable(false);
        this.chatlogField.setFont(ToolBox.FONT);
        this.findButton1 = new JButton(Msg.get("button.find"));
        this.findButton1.setFont(ToolBox.FONT);
        this.findButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File dir = OptionDialog.this.selectDirectory(OptionDialog.this.chatlogField.getText());
                if (dir != null) {
                    OptionDialog.this.chatlogField.setText(dir.getAbsolutePath());
                }
            }
        });
        logPanel.add((Component)this.chatlogField, "Center");
        logPanel.add((Component)this.findButton1, "East");
        panel.add(logPanel);
        return panel;
    }

    private JPanel createMediaTab() {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(layout);
        JLabel bgImgLabel = new JLabel(Msg.get("label.buddy.backimg"));
        bgImgLabel.setFont(ToolBox.FONT);
        panel.add(bgImgLabel);
        panel.add(this.createDummyPanel(5));
        JPanel bgImgPanel = new JPanel(new BorderLayout(5, 5));
        bgImgPanel.setAlignmentX(0.0f);
        bgImgPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        this.bgImageField = new JTextField();
        this.bgImageField.setFont(ToolBox.FONT);
        this.findButton2 = new JButton(Msg.get("button.find"));
        this.findButton2.setFont(ToolBox.FONT);
        this.findButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File dir = OptionDialog.this.selectFile(OptionDialog.this.bgImageField.getText(), new FileFilter(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String name = f.getName().toLowerCase();
                        return name.endsWith(".gif") || name.endsWith(".jpg");
                    }

                    public String getDescription() {
                        return "JPEG, GIF Files (*.gif, *.jpg)";
                    }
                });
                if (dir != null) {
                    OptionDialog.this.bgImageField.setText(dir.getAbsolutePath());
                }
            }
        });
        bgImgPanel.add((Component)this.bgImageField, "Center");
        bgImgPanel.add((Component)this.findButton2, "East");
        panel.add(bgImgPanel);
        panel.add(this.createDummyPanel(4));
        JPanel buddyFontPanel = new JPanel(new FlowLayout(0, 10, 2));
        buddyFontPanel.setAlignmentX(0.0f);
        buddyFontPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        JLabel l0 = new JLabel(Msg.get("label.chooselistfont.color"));
        l0.setFont(ToolBox.FONT);
        this.colorButton = new JButton("");
        this.colorButton.setOpaque(true);
        this.colorButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.colorButton.setPreferredSize(new Dimension(45, 18));
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(OptionDialog.this, Msg.get("label.chooselistfont.color"), OptionDialog.this.colorButton.getBackground());
                OptionDialog.this.colorButton.setBackground(c);
            }
        });
        buddyFontPanel.add((Component)l0, "Center");
        buddyFontPanel.add((Component)this.colorButton, "East");
        panel.add(buddyFontPanel);
        final NativeToolkit tk = NativeToolkit.getInstance();
        if (tk.isWin2k) {
            panel.add(this.createDummyPanel(10));
            JLabel l1 = new JLabel(Msg.get("label.transparent.level"));
            l1.setFont(ToolBox.FONT);
            panel.add(l1);
            JPanel sliderPanel = new JPanel(new BorderLayout(5, 5));
            sliderPanel.setAlignmentX(0.0f);
            sliderPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
            final JSlider slider = new JSlider(30, 255);
            slider.setFont(ToolBox.FONT);
            int value = Integer.parseInt(System.getProperty("jmsn.transparency", "255"));
            if (value != -1) {
                slider.setValue(value);
            } else {
                slider.setEnabled(false);
            }
            slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int value = slider.getValue();
                    tk.makeTransparency(MainFrame.INSTANCE, value);
                    tk.makeTransparency(OptionDialog.this, value);
                    System.setProperty("jmsn.transparency", String.valueOf(value));
                }
            });
            final JCheckBox check = new JCheckBox(Msg.get("checkbox.use"));
            check.setFont(ToolBox.FONT);
            check.setSelected(value != -1);
            check.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean sel = check.isSelected();
                    if (sel) {
                        slider.setValue(slider.getValue());
                    } else {
                        tk.makeTransparency(MainFrame.INSTANCE, -1);
                        tk.makeTransparency(OptionDialog.this, -1);
                        System.setProperty("jmsn.transparency", "-1");
                    }
                    slider.setEnabled(sel);
                }
            });
            sliderPanel.add((Component)slider, "Center");
            sliderPanel.add((Component)check, "East");
            panel.add(sliderPanel);
        }
        panel.add(this.createDummyPanel(5));
        this.tstampCheck = new JCheckBox(Msg.get("label.timestamp"));
        this.tstampCheck.setFont(ToolBox.FONT);
        this.tstampCheck.setAlignmentX(0.0f);
        this.tstampCheck.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        panel.add(this.tstampCheck);
        this.emoticonCheck = new JCheckBox(Msg.get("label.emoticon.view"));
        this.emoticonCheck.setFont(ToolBox.FONT);
        this.emoticonCheck.setAlignmentX(0.0f);
        this.emoticonCheck.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        panel.add(this.emoticonCheck);
        this.fixedFontFaceCheck = new JCheckBox(Msg.get("label.use.fixed.font"));
        this.fixedFontFaceCheck.setFont(ToolBox.FONT);
        this.fixedFontFaceCheck.setAlignmentX(0.0f);
        this.fixedFontFaceCheck.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        panel.add(this.fixedFontFaceCheck);
        return panel;
    }

    private JPanel createDummyPanel(int height) {
        JPanel d0 = new JPanel();
        d0.setAlignmentX(0.0f);
        d0.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
        return d0;
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1, 10, 4));
        JButton confirmButton = new JButton(Msg.get("button.ok"));
        confirmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.processConfirm();
            }
        });
        confirmButton.setFont(ToolBox.FONT);
        JButton cancelButton = new JButton(Msg.get("button.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.dispose();
            }
        });
        cancelButton.setFont(ToolBox.FONT);
        bottomPanel.add(confirmButton);
        bottomPanel.add(cancelButton);
        return bottomPanel;
    }

    private void processConfirm() {
        if (!this.msnm.isLoggedIn()) {
            this.dispose();
            return;
        }
        File downDir = new File(this.downField.getText());
        downDir.mkdirs();
        File logDir = new File(this.chatlogField.getText());
        logDir.mkdirs();
        boolean sndLogin = this.loginCheck.isSelected();
        boolean sndMessage = this.messageCheck.isSelected();
        boolean autoAccept = this.fileAutoAcceptCheck.isSelected();
        boolean tstampView = this.tstampCheck.isSelected();
        boolean emoticonView = this.emoticonCheck.isSelected();
        boolean useFixedFont = this.fixedFontFaceCheck.isSelected();
        LocalCopy local = this.msnm.getLocalCopy();
        local.setProperty("download.dir", downDir.getAbsolutePath());
        local.setProperty("chatlog.dir", logDir.getAbsolutePath());
        local.setProperty("background.image", this.bgImageField.getText());
        local.setProperty("Sound.login.enable", String.valueOf(sndLogin));
        local.setProperty("Sound.message.enable", String.valueOf(sndMessage));
        local.setProperty("File.auto.accept", String.valueOf(autoAccept));
        local.setProperty("timestamp.display", String.valueOf(tstampView));
        local.setProperty("emoticon.display", String.valueOf(emoticonView));
        local.setProperty("buddylist.font.color", String.valueOf(this.colorButton.getBackground().getRGB()));
        local.setProperty("font.fixed.on.chat", String.valueOf(useFixedFont));
        local.storeInformation();
        MusicBox.setEnabled("Login", sndLogin);
        MusicBox.setEnabled("Message.1", sndMessage);
        MusicBox.setEnabled("Message.2", sndMessage);
        System.setProperty("jmsn.file.auto.accept", String.valueOf(autoAccept));
        try {
            File file;
            if (this.msnm != null && this.msnm.isLoggedIn() && !this.initFriendlyName.equals(this.nickField.getText())) {
                this.msnm.setMyFriendlyName(this.nickField.getText());
            }
            if ((file = new File(this.bgImageField.getText())).exists()) {
                ImageIcon icon = new ImageIcon(file.getAbsolutePath());
                MainFrame.INSTANCE.buddies.setBackgroundImage(icon.getImage());
            } else {
                MainFrame.INSTANCE.buddies.setBackgroundImage(null);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        MainFrame.INSTANCE.buddies.renderer.setForeColor(this.colorButton.getBackground());
        MainFrame.INSTANCE.buddies.repaint();
        this.dispose();
    }

    private File selectDirectory(String current) {
        JFileChooser file = new JFileChooser(current);
        file.setFileSelectionMode(1);
        if (file.showOpenDialog(this) == 0) {
            return file.getSelectedFile();
        }
        return null;
    }

    private File selectFile(String current, FileFilter filter) {
        JFileChooser file = new JFileChooser(current);
        file.addChoosableFileFilter(filter);
        file.setFileSelectionMode(0);
        if (file.showOpenDialog(this) == 0) {
            return file.getSelectedFile();
        }
        return null;
    }

    private void processReady() {
        if (!this.msnm.isLoggedIn()) {
            this.nickField.setText(Msg.get("label.login.please"));
            this.nickField.setEnabled(false);
            this.loginCheck.setEnabled(false);
            this.messageCheck.setEnabled(false);
            this.fileAutoAcceptCheck.setEnabled(false);
            this.tstampCheck.setEnabled(false);
            this.emoticonCheck.setEnabled(false);
            this.colorButton.setEnabled(false);
            this.fixedFontFaceCheck.setEnabled(false);
            this.findButton0.setEnabled(false);
            this.findButton1.setEnabled(false);
            this.findButton2.setEnabled(false);
            return;
        }
        this.initFriendlyName = this.msnm.getOwner().getFormattedFriendlyName();
        this.nickField.setText(this.initFriendlyName);
        LocalCopy local = this.msnm.getLocalCopy();
        boolean loginEnable = local.getPropertyBoolean("Sound.login.enable", true);
        boolean messageEnable = local.getPropertyBoolean("Sound.message.enable", true);
        boolean fileAutoAccept = local.getPropertyBoolean("File.auto.accept", false);
        boolean tstampEnable = local.getPropertyBoolean("timestamp.display", false);
        boolean emoticonEnable = local.getPropertyBoolean("emoticon.display", true);
        boolean fixedFontEnable = local.getPropertyBoolean("font.fixed.on.chat", false);
        this.loginCheck.setSelected(loginEnable);
        this.messageCheck.setSelected(messageEnable);
        this.fileAutoAcceptCheck.setSelected(fileAutoAccept);
        this.tstampCheck.setSelected(tstampEnable);
        this.emoticonCheck.setSelected(emoticonEnable);
        this.fixedFontFaceCheck.setSelected(fixedFontEnable);
        String downdir = local.getProperty("download.dir");
        String logdir = local.getProperty("chatlog.dir");
        String backImageFile = local.getProperty("background.image", "");
        new File(downdir).mkdirs();
        new File(logdir).mkdirs();
        this.downField.setText(downdir);
        this.chatlogField.setText(logdir);
        this.bgImageField.setText(backImageFile);
        String foreColor = local.getProperty("buddylist.font.color", "000000");
        this.colorButton.setBackground(new Color(Integer.parseInt(foreColor)));
    }

    public void show() {
        this.processReady();
        super.show();
    }
}

