/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.Msg;
import rath.util.ZipManager;

public class ZippedDirectoryDialog
extends DefaultDialog
implements ToolBox {
    private File dir = null;
    private File temp = null;
    private ZipManager zip = null;
    private JLabel statusLabel = null;
    private JProgressBar progress = null;
    private boolean isComplete = false;
    private Thread zipThread = null;

    public ZippedDirectoryDialog(Frame owner, File dir) {
        super(owner);
        this.dir = dir;
        this.temp = new File(System.getProperty("java.io.tmpdir"), dir.getName() + ".zip");
        this.zip = new ZipManager(){

            protected void compressComplete(File file) {
                ZippedDirectoryDialog.this.increaseProgress();
            }
        };
        this.zip.setArchiveRoot(dir.getAbsolutePath());
        this.createUI();
    }

    private void increaseProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int current = ZippedDirectoryDialog.this.progress.getValue() + 1;
                int max = ZippedDirectoryDialog.this.progress.getMaximum();
                int percent = (int)((float)current / (float)max * 100.0f);
                ZippedDirectoryDialog.this.progress.setValue(current);
                ZippedDirectoryDialog.this.progress.setString(percent + "%");
                if (percent == 100) {
                    ZippedDirectoryDialog.this.isComplete = true;
                    ZippedDirectoryDialog.this.dispose();
                }
            }
        });
    }

    private void processError(final IOException e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ZippedDirectoryDialog.this.statusLabel.setText(Msg.get("zipdlg.msg.fail", e.getMessage()));
                try {
                    Thread.currentThread();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ZippedDirectoryDialog.this.temp = null;
                ZippedDirectoryDialog.this.dispose();
            }
        });
    }

    private void createUI() {
        this.setSize(250, 100);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        this.statusLabel = new JLabel(Msg.get("zipdlg.msg.ready"), 0);
        this.statusLabel.setFont(ToolBox.FONT);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        panel.add((Component)this.statusLabel, "Center");
        panel.add((Component)this.progress, "South");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ZippedDirectoryDialog.this.doStart();
            }
        });
    }

    protected void doStart() {
        if (this.zipThread == null) {
            this.progress.setMaximum(this.getFileCount(this.dir));
            this.statusLabel.setText(Msg.get("zipdlg.msg.working"));
            this.zipThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ZippedDirectoryDialog.this.zip.doCompress(ZippedDirectoryDialog.this.dir, ZippedDirectoryDialog.this.temp);
                    }
                    catch (IOException e) {
                        ZippedDirectoryDialog.this.processError(e);
                    }
                }
            });
            this.zipThread.start();
        }
    }

    private int getFileCount(File dir) {
        return this.recursiveDirectory(dir);
    }

    private int recursiveDirectory(File dir) {
        int count = 0;
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            count = f.isDirectory() ? (count += this.recursiveDirectory(f)) : ++count;
            ++i;
        }
        return count;
    }

    public void dispose() {
        if (this.zipThread != null && !this.isComplete) {
            this.zipThread.interrupt();
            this.temp.deleteOnExit();
        }
        super.dispose();
    }

    public File getZippedFile() {
        return this.isComplete ? this.temp : null;
    }
}

