/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.control.ExceptionDialog;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.ExceptionEvent;
import borland.jbcl.dataset.ExceptionListener;
import borland.jbcl.dataset.Res;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.util.ChainedException;
import borland.jbcl.util.EventMulticaster;
import borland.jbcl.util.ExceptionChain;
import borland.jbcl.util.Variant;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;

public class DataSetException
extends Exception
implements ChainedException {
    private static final int BASE = 0;
    public static final int BAD_QUERY_PROPERTIES = 1;
    public static final int NOT_SELECT_QUERY = 2;
    public static final int UNEXPECTED_END_OF_QUERY = 3;
    public static final int UNKNOWN_PARAM_NAME = 4;
    public static final int MISMATCHED_PARAMETER_FORMAT = 5;
    public static final int PARAMETER_COUNT_MISMATCH = 6;
    public static final int CANNOT_FIND_TABLE_NAME = 7;
    public static final int NO_UPDATABLE_COLUMNS = 8;
    public static final int CANNOT_IMPORT_NULL_DATASET = 9;
    public static final int UNKNOWN_COLUMN_NAME = 10;
    public static final int COLUMN_TYPE_CONFLICT = 11;
    public static final int INVALID_COLUMN_POSITION = 12;
    public static final int COLUMN_ALREADY_BOUND = 13;
    public static final int CANNOT_CHANGE_COLUMN_DATA_TYPE = 14;
    public static final int SET_CALCULATED_FAILURE = 15;
    public static final int UNRECOGNIZED_DATA_TYPE = 16;
    public static final int DATASET_HAS_NO_TABLES = 18;
    public static final int COLUMN_NOT_IN_ROW = 19;
    public static final int EMPTY_COLUMN_NAMES = 20;
    public static final int NO_NON_BLOB_COLUMNS = 21;
    public static final int TRANSACTION_ISOLATION_LEVEL_NOT_SUPPORTED = 22;
    public static final int PARTIAL_SEARCH_FOR_STRING = 23;
    public static final int NEED_LOCATE_START_OPTION = 24;
    public static final int QUERY_NOT_EXECUTED = 25;
    public static final int QUERY_IN_PROCESS = 26;
    public static final int RESTRUCTURE_IN_PROGRESS = 27;
    public static final int ALREADY_LOADING = 28;
    public static final int LOADING_NOT_STARTED = 29;
    public static final int CANNOT_UPDATE_SCOPED_DATA_ROW = 30;
    public static final int INCOMPATIBLE_DATA_ROW = 31;
    public static final int INVALID_DATA_FILE_FORMAT = 32;
    public static final int LINK_COLUMNS_ERROR = 33;
    public static final int MASTER_DETAIL_VIEW_ERROR = 34;
    public static final int DATASET_CORRUPT = 35;
    public static final int DUPLICATE_COLUMN_NAME = 36;
    public static final int NOT_UPDATEABLE = 37;
    public static final int MULTIPLE_ROWS_AFFECTED = 38;
    public static final int DATASET_OPEN = 39;
    public static final int NO_WHERE_CLAUSE = 40;
    public static final int DATASET_HAS_NO_ROWS = 41;
    public static final int DATASET_NOT_OPEN = 42;
    public static final int MASTER_NAVIGATION_ERROR = 43;
    public static final int NO_CALC_FIELDS = 44;
    public static final int CONNECTION_DESCRIPTOR_NOT_SET = 45;
    public static final int INVALID_AGG_DESCRIPTOR = 46;
    public static final int EXCEPTION_CHAIN = 47;
    public static final int INVALID_SORT_COLUMN = 48;
    public static final int INVALID_COLUMN_TYPE = 49;
    public static final int INVALID_SCHEMA_FILE = 50;
    public static final int NO_ROWS_AFFECTED = 51;
    public static final int DATA_FILE_LOAD_FAILED = 60;
    public static final int REOPEN_FAILURE = 61;
    public static final int QUERY_FAILED = 62;
    public static final int RESOLVE_FAILED = 63;
    public static final int MISSING_RESOLVER = 64;
    public static final int MISSING_MASTER_DATASET = 65;
    public static final int SQL_ERROR = 66;
    public static final int NOT_DATABASE_RESOLVER = 67;
    public static final int NULL_COLUMN_NAME = 68;
    public static final int RESOLVE_IN_PROGRESS = 69;
    public static final int CANNOT_CHANGE_COLUMN = 70;
    public static final int INVALID_FORMAT = 71;
    public static final int ONEPASS_INPUT_STREAM = 72;
    public static final int INSUFFICIENT_ROWID = 73;
    public static final int NON_EXISTENT_ROWID = 74;
    public static final int REFRESHROW_NOT_SUPPORTED = 75;
    public static final int CANNOT_SAVE_CHANGES = 76;
    public static final int CANNOT_REFRESH = 77;
    public static final int NO_RESULT_SET = 78;
    public static final int IO_ERROR = 79;
    public static final int CONNECTION_NOT_CLOSED = 80;
    public static final int FIELD_POST_ERROR = 81;
    protected int errorCode;
    protected ExceptionChain exceptionChain;

    public static final void throwBadQueryProperties() throws DataSetException {
        DataSetException.throwException(1, Res.getString(0));
    }

    static final void throwNotSelectQuery() throws DataSetException {
        DataSetException.throwException(2, Res.getString(1));
    }

    static final void throwUnexpectedEndOfQuery() throws DataSetException {
        DataSetException.throwException(3, Res.getString(2));
    }

    static final void throwUnknownParamName(String string) throws DataSetException {
        DataSetException.throwException(4, string);
    }

    static final void throwMismatchedParameterFormat() throws DataSetException {
        DataSetException.throwException(5, Res.getString(34));
    }

    static final void throwParameterCountMismatch() throws DataSetException {
        DataSetException.throwException(6, Res.getString(33));
    }

    static final void throwCantFindTableName() throws DataSetException {
        DataSetException.throwException(7, Res.getString(4));
    }

    static final void throwNoUpdatableColumns() throws DataSetException {
        DataSetException.throwException(8, Res.getString(97));
    }

    static final void throwCantImportNullDataSet() throws DataSetException {
        DataSetException.throwException(9, Res.getString(5));
    }

    static final void throwUnknownColumnName(String string) throws DataSetException {
        DataSetException.throwException(10, Res.format(8, string));
    }

    static final void throwColumnTypeConflict() throws DataSetException {
        DataSetException.throwException(11, Res.getString(27));
    }

    static final void throwInvalidColumnPosition() throws DataSetException {
        DataSetException.throwException(12, Res.getString(9));
    }

    static final void throwCannotChangeColumnDataType() throws DataSetException {
        DataSetException.throwException(14, Res.getString(10));
    }

    static final void throwSetCalculatedFailure() throws DataSetException {
        DataSetException.throwException(15, Res.getString(11));
    }

    static final void throwUnrecognizedDataType() throws DataSetException {
        DataSetException.throwException(16, Res.getString(12));
    }

    static final void throwDataSetHasNoTable() throws DataSetException {
        DataSetException.throwException(18, Res.getString(13));
    }

    static final void throwColumnNotInRow(String string) throws DataSetException {
        DataSetException.throwException(19, string);
    }

    static final void throwEmptyColumnNames() throws DataSetException {
        DataSetException.throwException(20, Res.getString(15));
    }

    static final void throwNoNonBlobColumns() throws DataSetException {
        DataSetException.throwException(21, Res.getString(16));
    }

    static final void throwTransactionIsolationLevelNotSupported() throws DataSetException {
        DataSetException.throwException(22, Res.getString(19));
    }

    static final void throwPartialSearchForString() throws DataSetException {
        DataSetException.throwException(23, Res.getString(17));
    }

    static final void throwNeedLocateStartOption() throws DataSetException {
        DataSetException.throwException(24, Res.getString(18));
    }

    public static final void throwQueryNotExecuted() throws DataSetException {
        DataSetException.throwException(25, Res.getString(35));
    }

    public static final void throwQueryInProcess() throws DataSetException {
        DataSetException.throwException(26, Res.getString(20));
    }

    static final void throwRestructureInProgress() throws DataSetException {
        DataSetException.throwException(27, Res.getString(21));
    }

    static final void throwAlreadyLoading() throws DataSetException {
        DataSetException.throwException(28, Res.getString(22));
    }

    static final void throwLoadingNotStarted() throws DataSetException {
        DataSetException.throwException(29, Res.getString(23));
    }

    static final void throwCannotUpdateScopedDataRow() throws DataSetException {
        DataSetException.throwException(30, Res.getString(24));
    }

    static final void throwIncompatibleDataRow() throws DataSetException {
        DataSetException.throwException(31, Res.getString(25));
    }

    static final void throwInvalidDataFileFormat() throws DataSetException {
        DataSetException.throwException(32, Res.getString(26));
    }

    static final void throwLinkColumnsError() throws DataSetException {
        DataSetException.throwException(33, Res.getString(28));
    }

    static final void throwMasterDetailViewError() throws DataSetException {
        DataSetException.throwException(34, Res.getString(29));
    }

    static final void throwDuplicateColumnName() throws DataSetException {
        DataSetException.throwException(36, Res.getString(30));
    }

    static final void throwNotUpdatable() throws DataSetException {
        DataSetException.throwException(37, Res.getString(31));
    }

    static final void throwResolveInProgress() throws DataSetException {
        DataSetException.throwException(69, Res.getString(32));
    }

    static final void throwNoRowsAffected(String string) throws DataSetException {
        DataSetException.throwException(51, String.valueOf(Res.getString(37)).concat(String.valueOf(string)));
    }

    static final void throwMultipleRowsAffected(String string) throws DataSetException {
        DataSetException.throwException(38, String.valueOf(Res.getString(36)).concat(String.valueOf(string)));
    }

    static final void throwDataSetOpen() throws DataSetException {
        DataSetException.throwException(39, Res.getString(42));
    }

    static final void throwDataSetNotOpen() throws DataSetException {
        DataSetException.throwException(42, Res.getString(43));
    }

    static final void throwDataSetCorrupt() throws DataSetException {
        DataSetException.throwException(35, Res.getString(44));
    }

    static final void throwNoCalcFields() throws DataSetException {
        DataSetException.throwException(44, Res.getString(47));
    }

    static final void throwConnectionDescriptorNotSet() throws DataSetException {
        DataSetException.throwException(45, Res.getString(45));
    }

    static final void throwInvalidAggDescriptor() throws DataSetException {
        DataSetException.throwException(46, Res.getString(48));
    }

    static final void throwNotSortable() throws DataSetException {
        DataSetException.throwException(48, Res.getString(49));
    }

    static final void throwResolveFailed(Exception exception) throws DataSetException {
        DataSetException.throwException(63, Res.getString(55), exception);
    }

    static final void throwMissingResolver() throws DataSetException {
        DataSetException.throwException(64, Res.getString(56));
    }

    static final void throwNotDatabaseResolver() throws DataSetException {
        DataSetException.throwException(67, Res.getString(58));
    }

    static final void throwMissingMasterDataSet() throws DataSetException {
        DataSetException.throwException(65, Res.getString(57));
    }

    static final void throwNoResultSet() throws DataSetException {
        DataSetException.throwException(78, Res.getString(59));
    }

    public static final void throwInvalidColumnType(int n) throws DataSetException {
        DataSetException.throwException(49, Res.format(50, new String[]{Variant.typeName(n)}));
    }

    static final void throwInvalidSQLType(int n) throws DataSetException {
        DataSetException.throwException(49, Res.format(50, new String[]{Integer.toString(n)}));
    }

    static final void throwNullColumnName() throws DataSetException {
        DataSetException.throwException(68, Res.getString(78));
    }

    public static final void throwSQLException(SQLException sQLException) throws DataSetException {
        DataSetException.throwException(66, sQLException);
    }

    public static final void throwIOException(IOException iOException) throws DataSetException {
        DataSetException.throwException(79, iOException);
    }

    static final void throwCannotChangeColumn() throws DataSetException {
        DataSetException.throwException(70, Res.getString(79));
    }

    static final void throwInvalidFormat(Exception exception, String string) throws DataSetException {
        DataSetException.throwException(71, Res.format(81, new String[]{string}), exception);
    }

    static final void throwNoWhereClause(DataSet dataSet) throws DataSetException {
        DataSetException.throwException(40, Res.format(85, new String[]{dataSet.getTableName()}));
    }

    static final void throwDataSetHasNoRows(DataSet dataSet) throws DataSetException {
        DataSetException.throwException(41, Res.format(94, new String[]{dataSet.getTableName()}));
    }

    static final void throwOnePassInputStream(Column column) throws DataSetException {
        DataSetException.throwException(72, Res.format(99, new String[]{column.getColumnName()}));
    }

    static final void throwInsuficientRowId() throws DataSetException {
        DataSetException.throwException(73, Res.getString(87));
    }

    static final void throwNonExistentRowId() throws DataSetException {
        DataSetException.throwException(74, Res.getString(88));
    }

    static final void throwRefreshRowNotSupported() throws DataSetException {
        DataSetException.throwException(75, Res.getString(89));
    }

    static final void throwCannotSaveChanges(StorageDataSet storageDataSet) throws DataSetException {
        String string = storageDataSet.getTableName();
        DataSetException.throwException(76, Res.format(90, new String[]{string != null ? string : ""}));
    }

    static final void throwCannotRefresh(StorageDataSet storageDataSet) throws DataSetException {
        String string = storageDataSet.getTableName();
        DataSetException.throwException(77, Res.format(91, new String[]{string != null ? string : ""}));
    }

    static final void throwInvalidFormatException(Exception exception, int n, Column column) throws DataSetException {
        DataSetException.throwException(71, Res.format(92, new String[]{Integer.toString(n), column.getColumnName()}), exception);
    }

    static final void throwColumnAlreadyBound(DataSet dataSet, Column column) throws DataSetException {
        DataSetException.throwException(13, Res.format(98, column.getColumnName(), dataSet.getTableName()));
    }

    static final void throwConnectionNotClosed(Exception exception) throws DataSetException {
        DataSetException.throwException(80, Res.getString(96), exception);
    }

    static final void throwFieldPostError(Exception exception) throws DataSetException {
        DataSetException.throwException(81, Res.getString(100), exception);
    }

    static final void throwException(int n, Exception exception) throws DataSetException {
        DataSetException.throwException(n, exception.getMessage(), exception);
    }

    static final void throwException(int n, String string, Exception exception) throws DataSetException {
        if (exception instanceof DataSetException) {
            throw (DataSetException)exception;
        }
        throw new DataSetException(n, string, exception);
    }

    static final void throwException(int n, String string, ExceptionChain exceptionChain) throws DataSetException {
        throw new DataSetException(n, string, exceptionChain);
    }

    public DataSetException(int n, String string, ExceptionChain exceptionChain) {
        this(n, string);
        this.exceptionChain = exceptionChain;
    }

    public DataSetException(int n, String string, Exception exception) {
        this(n, string);
        this.exceptionChain = new ExceptionChain();
        this.exceptionChain.append(exception);
    }

    public DataSetException(int n, String string) {
        super(string);
        this.errorCode = n;
    }

    private static final void throwException(int n, String string) throws DataSetException {
        throw new DataSetException(n, string);
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.exceptionChain == null) {
            super.printStackTrace(printStream);
        } else {
            super.printStackTrace(printStream);
            printStream.println(Res.getString(77));
            this.exceptionChain.printStackTrace(printStream);
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public ExceptionChain getExceptionChain() {
        return this.exceptionChain;
    }

    private static final Frame getFrame(Component component) {
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Frame)) continue;
            return (Frame)component2;
        }
        return new Frame();
    }

    public static final void handleException(DataSet dataSet, Component component, Exception exception, boolean bl) {
        Frame frame = DataSetException.getFrame(component);
        if (DataSet.exceptionListeners != null) {
            DataSet.exceptionListeners.dispatch(new ExceptionEvent(dataSet, component, exception));
        } else if ((dataSet == null || dataSet.displayError(exception)) && frame != null && ExceptionDialog.getShowCount() < 1) {
            ((Component)new ExceptionDialog(frame, Res.getString(80), exception, bl)).setVisible(true);
        }
    }

    public static final void handleException(DataSet dataSet, Component component, Exception exception) {
        DataSetException.handleException(dataSet, component, exception, false);
    }

    public static final void handleException(Exception exception) {
        DataSetException.handleException(null, null, exception);
    }

    public static final void handleException(Exception exception, boolean bl) {
        DataSetException.handleException(null, null, exception, bl);
    }

    public static final void addExceptionListener(ExceptionListener exceptionListener) {
        DataSet.exceptionListeners = EventMulticaster.add(DataSet.exceptionListeners, exceptionListener);
    }

    public static final void removeExceptionListener(ExceptionListener exceptionListener) {
        DataSet.exceptionListeners = EventMulticaster.remove(DataSet.exceptionListeners, exceptionListener);
    }
}

