/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.control.MaskableTextItemEditor;
import borland.jbcl.control.PickListItemEditor;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnVariant;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.PickListDescriptor;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.util.Variant;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.ImageItemEditor;
import borland.jbcl.view.ImageItemPainter;
import borland.jbcl.view.SelectableTextItemPainter;
import java.awt.Component;
import java.awt.Insets;
import java.io.InputStream;

class DataSetModel {
    private DataSet dataSet;
    private Column column;
    ItemPainter painter;
    ItemEditor editor;
    private ColumnVariant value;
    private Component component;
    private int alignment;
    private Insets margin;

    DataSetModel(DataSet dataSet, Column column, Component component, int n, Insets insets) {
        this.dataSet = dataSet;
        this.column = column;
        this.component = component;
        this.alignment = n;
        this.margin = insets;
        this.value = new ColumnVariant(column, dataSet);
        if (component != null) {
            this.editor = column.getItemEditor();
            this.painter = column.getItemPainter();
            if (this.editor != null) {
                // empty if block
            }
            if (this.painter == null || this.editor == null) {
                Insets insets2 = insets;
                if (insets2 == null) {
                    insets2 = new Insets(0, 0, 0, 0);
                }
                if (this.painter == null) {
                    switch (column.getDataType()) {
                        case 11: {
                            this.painter = new FocusableItemPainter(new SelectableTextItemPainter(n, insets2, column.getFormatter()));
                            break;
                        }
                        case 12: {
                            this.painter = new FocusableItemPainter(new ImageItemPainter(component, n));
                            break;
                        }
                        default: {
                            this.painter = new FocusableItemPainter(new SelectableTextItemPainter(n, insets2, column.getFormatter()));
                        }
                    }
                }
                if (this.editor == null) {
                    switch (column.getDataType()) {
                        case 12: {
                            this.editor = new ImageItemEditor();
                            break;
                        }
                        default: {
                            PickListDescriptor pickListDescriptor = column.getPickList();
                            if (pickListDescriptor != null) {
                                PickListItemEditor pickListItemEditor = new PickListItemEditor();
                                pickListItemEditor.setCachePickList(true);
                                this.editor = pickListItemEditor;
                                break;
                            }
                            this.editor = new MaskableTextItemEditor(n, insets2, column.getFormatter(), column.getEditMasker());
                        }
                    }
                }
            }
        }
    }

    final void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataSet.addDataChangeListener(dataChangeListener);
    }

    final void addNavigationListener(NavigationListener navigationListener) {
        this.dataSet.addNavigationListener(navigationListener);
    }

    private final void handleException(Exception exception) {
        DataSetException.handleException(this.dataSet, this.component, exception);
    }

    final Variant get() {
        try {
            this.dataSet.getVariant(this.column.ordinal, (Variant)this.value);
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
        catch (Exception exception) {
            this.handleException(exception);
            this.value.setUnassignedNull();
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
    }

    final Variant get(int n) {
        if (this.column == null) {
            return null;
        }
        try {
            this.dataSet.getVariant(this.column.ordinal, n, (Variant)this.value);
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
        catch (Exception exception) {
            this.handleException(exception);
            this.value.setUnassignedNull();
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
    }

    final Variant getCopy(int n) {
        Variant variant = new Variant();
        variant.setVariant(this.get(n));
        return variant;
    }

    final int getRowCount() {
        try {
            int n = this.dataSet.rowCount();
            return n;
        }
        catch (Exception exception) {
            this.handleException(exception);
            int n = 0;
            return n;
        }
    }

    final boolean canSet(boolean bl) {
        return this.canSet(this.dataSet.row(), bl);
    }

    final boolean canSet(int n, boolean bl) {
        try {
            if (!bl) {
                boolean bl2 = this.dataSet.canSet(this.column);
                return bl2;
            }
            this.dataSet.startEdit(this.column);
            boolean bl3 = true;
            return bl3;
        }
        catch (DataSetException dataSetException) {
            this.handleException(dataSetException);
            return false;
        }
    }

    final void set(Object object) {
        try {
            if (object instanceof Variant) {
                this.dataSet.setVariant(this.column.getOrdinal(), (Variant)object);
            } else if (object instanceof InputStream) {
                Variant variant = new Variant();
                variant.setBinaryStream((InputStream)object);
                this.dataSet.setVariant(this.column.getOrdinal(), variant);
            } else if (object != null) {
                this.column.getFormatter().parse(object.toString(), this.value);
                this.dataSet.setVariant(this.column.getOrdinal(), (Variant)this.value);
            } else {
                this.value.setAssignedNull();
                this.dataSet.setVariant(this.column.getOrdinal(), (Variant)this.value);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
            throw new IllegalArgumentException();
        }
    }

    final void set(int n, Object object) {
        if (n != this.dataSet.row()) {
            try {
                this.dataSet.goToRow(n);
            }
            catch (DataSetException dataSetException) {
                this.handleException(dataSetException);
                return;
            }
        }
        this.set(object);
    }

    void addRow(int n) {
        try {
            if (n != this.dataSet.row()) {
                this.dataSet.goToRow(n);
            }
            this.dataSet.insertRow(true);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    final void addRow() {
        try {
            if (!this.dataSet.atLast()) {
                this.dataSet.last();
            }
            this.dataSet.insertRow(false);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    final void removeRow(int n) {
        try {
            if (n != this.dataSet.row()) {
                this.dataSet.goToRow(n);
            }
            this.dataSet.deleteRow();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }
}

