/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataRow;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.Index;
import borland.jbcl.dataset.MasterLinkDescriptor;
import borland.jbcl.dataset.MasterUpdateEvent;
import borland.jbcl.dataset.MasterUpdateListener;
import borland.jbcl.dataset.MatrixData;
import borland.jbcl.dataset.ReadRow;
import borland.jbcl.dataset.ReadWriteRow;
import borland.jbcl.dataset.SortDescriptor;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.dataset.ValidationException;
import borland.jbcl.util.Variant;
import java.util.TooManyListenersException;

class DetailIndex
extends Index
implements MasterUpdateListener {
    private int rangeStart;
    private int rangeEnd;
    private DataRow detailRow;
    private DataRow masterRow;
    private DataSet masterDataSet;
    private Index index;
    private StorageDataSet detailDataSetStore;
    private DataSet detailDataSet;
    private DataSetView detailDataSetView;
    private boolean loadingRows;
    private String[] detailLinkColumns;
    private String[] masterLinkColumns;

    public void masterUpdate(MasterUpdateEvent masterUpdateEvent) {
    }

    DetailIndex(DataSet dataSet) throws DataSetException {
        MasterLinkDescriptor masterLinkDescriptor = dataSet.getMasterLink();
        this.detailDataSet = dataSet;
        this.detailDataSetStore = dataSet.getStorageDataSet();
        this.masterDataSet = masterLinkDescriptor.getMasterDataSet();
        this.masterLinkColumns = masterLinkDescriptor.getMasterLinkColumns();
        this.detailLinkColumns = masterLinkDescriptor.getDetailLinkColumns();
        this.detailDataSetStore.checkMasterDetail(masterLinkDescriptor);
        if (this.detailLinkColumns == null) {
            this.detailLinkColumns = this.masterLinkColumns;
        }
        this.checkLinkingKeys(dataSet);
        this.detailDataSetStore.openIndex(dataSet);
        this.index = dataSet.index;
        this.detailRow = new DataRow(dataSet, this.detailLinkColumns);
        this.detailDataSetView = new DataSetView();
        this.detailDataSetView.setStorageDataSet(this.detailDataSetStore);
        this.detailDataSetView.setSort(dataSet.getSort());
        if (dataSet.getRowFilterListener() != null) {
            try {
                this.detailDataSetView.addRowFilterListener(dataSet.getRowFilterListener());
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
        this.detailDataSetView.open();
        this.detailRow = new DataRow(dataSet, this.detailLinkColumns);
        this.masterRow = new DataRow(this.masterDataSet, this.masterLinkColumns);
        this.masterDataSet.addMasterUpdateListener(this);
        this.masterDataSet.removeAccessListener(dataSet);
        this.masterDataSet.addAccessListener(dataSet);
        this.masterDataSet.addMasterNavigateListener(dataSet);
        this.reLink();
    }

    private final void checkLinkingKeys(DataSet dataSet) throws DataSetException {
        Object object;
        MasterLinkDescriptor masterLinkDescriptor = dataSet.getMasterLink();
        if (this.masterDataSet == null || this.masterLinkColumns == null || this.masterLinkColumns.length < 1 || this.detailLinkColumns != null && this.masterLinkColumns.length != this.detailLinkColumns.length) {
            DataSetException.throwLinkColumnsError();
        }
        this.masterDataSet.open();
        if (this.masterDataSet != null) {
            if (this.canLoadDetails()) {
                StorageDataSet storageDataSet = dataSet.getStorageDataSet();
                Object object2 = object = storageDataSet != null ? storageDataSet.getMatrixData() : null;
                if (object == null || ((MatrixData)object).getRowCount() <= 1) {
                    this.loadDetails();
                }
            }
            if (dataSet.columnCount() < 1 && this.masterDataSet.rowCount() < 1) {
                DataSetException.throwDataSetHasNoRows(this.masterDataSet);
            }
        }
        for (int i = 0; i < this.detailLinkColumns.length; ++i) {
            if (this.detailDataSetStore.getColumn(this.detailLinkColumns[i]).getDataType() == this.masterDataSet.getColumn(this.masterLinkColumns[i]).getDataType()) continue;
            DataSetException.throwLinkColumnsError();
        }
        object = dataSet.getSortKeys();
        Object object3 = null;
        boolean bl = false;
        if (object != null && ((Object)object).length > 0) {
            int n = ((Object)object).length;
            if (n > this.detailLinkColumns.length) {
                n = this.detailLinkColumns.length;
            }
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                if (this.detailLinkColumns[i].equals(object[i])) continue;
                bl2 = false;
            }
            if (!bl2) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (!this.isDetailLinkColumn((String)object[i])) continue;
                    DataSetException.throwMasterDetailViewError();
                }
                object3 = new String[this.detailLinkColumns.length + ((Object)object).length];
                System.arraycopy(this.detailLinkColumns, 0, object3, 0, this.detailLinkColumns.length);
                System.arraycopy(object, 0, object3, this.detailLinkColumns.length, ((Object)object).length);
            } else {
                object3 = this.detailLinkColumns.length > ((Object)object).length ? this.detailLinkColumns : object;
            }
            bl = dataSet.getSort().isDescending();
        } else {
            object3 = this.detailLinkColumns;
        }
        dataSet.resetSort(new SortDescriptor((String[])object3, false, bl));
    }

    private boolean isDetailLinkColumn(String string) {
        for (int i = 0; i < this.detailLinkColumns.length; ++i) {
            if (!this.detailLinkColumns[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    final void setDefaultValues(ReadWriteRow readWriteRow) throws DataSetException {
        this.copyMasterRowToDetailRow(this.masterDataSet, readWriteRow);
    }

    final void close(DataSet dataSet, boolean bl) {
        if (!bl) {
            this.masterDataSet.removeAccessListener(dataSet);
        }
        this.masterDataSet.removeMasterUpdateListener(this);
        this.masterDataSet.removeMasterNavigateListener(dataSet);
    }

    final void copyMasterRowToDetailRow(ReadRow readRow, ReadWriteRow readWriteRow) throws DataSetException {
        ReadRow.copyTo(this.masterLinkColumns, readRow, this.detailLinkColumns, readWriteRow);
    }

    private int locateDetail(DataRow dataRow, int n) throws DataSetException {
        if (this.detailDataSetView.locate(dataRow, n)) {
            return this.detailDataSetView.row();
        }
        return -1;
    }

    void reLink() {
        this.rangeStart = 0;
        this.rangeEnd = -1;
        try {
            if (this.masterDataSet.isOpen() && this.masterDataSet.rowCount() >= 1 && this.detailDataSetView.isOpen()) {
                int n;
                this.copyMasterRowToDetailRow(this.masterDataSet, this.detailRow);
                int n2 = this.locateDetail(this.detailRow, 32);
                if (n2 < 0 && this.canLoadDetails()) {
                    this.loadDetails();
                    n2 = this.locateDetail(this.detailRow, 32);
                }
                if (n2 > -1 && (n = this.locateDetail(this.detailRow, 64)) > -1) {
                    this.rangeStart = n2;
                    this.rangeEnd = n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean canLoadDetails() throws DataSetException {
        if (this.loadingRows) {
            return false;
        }
        if (this.masterDataSet.rowCount() < 1) {
            return false;
        }
        if ((this.masterDataSet.getStatus() & 0x20) != 0) {
            return false;
        }
        this.masterDataSet.open();
        for (int i = 0; i < this.masterLinkColumns.length; ++i) {
            if (!this.masterDataSet.getVariantStorage(this.masterLinkColumns[i]).isNull()) continue;
            return false;
        }
        return true;
    }

    private final void loadDetails() {
        try {
            try {
                this.masterDataSet.detailsFetched();
                this.loadingRows = true;
                this.detailDataSetStore.loadDetailRows(this.detailDataSet, this.masterDataSet);
            }
            catch (DataSetException dataSetException) {
                Object var3_2 = null;
                this.loadingRows = false;
            }
            Object var3_1 = null;
            this.loadingRows = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.loadingRows = false;
            throw throwable;
        }
    }

    public int lastRow() {
        if (this.rangeEnd > -1) {
            return this.rangeEnd - this.rangeStart;
        }
        return -1;
    }

    public int internalRow(int n) throws DataSetException {
        return this.index.internalRow(this.rangeStart + n);
    }

    public int findClosest(int n) throws DataSetException {
        int n2 = this.index.findClosest(n);
        if (n2 > this.rangeEnd) {
            n2 = this.rangeEnd;
        }
        if (n2 < this.rangeStart) {
            n2 = this.rangeStart;
        }
        return n2 - this.rangeStart;
    }

    final boolean compareRow(int n) {
        return false;
    }

    final void loadSearchValues(Variant[] variantArray) {
    }

    public int locate(int n, Column[] columnArray, Variant[] variantArray, int n2) throws DataSetException {
        int n3 = this.index.locate(n + this.rangeStart, columnArray, variantArray, n2 | 0x100);
        if (n3 > -1 && n3 <= this.rangeEnd) {
            return n3 - this.rangeStart;
        }
        return -1;
    }

    public final void masterCanChange(MasterUpdateEvent masterUpdateEvent) throws Exception {
        if (this.lastRow() >= 0 && this.masterRow.hasColumn(masterUpdateEvent.getColumn().getColumnName()) != null) {
            ValidationException.throwCannotOrphanDetails();
        }
    }

    public final void masterDeleting(MasterUpdateEvent masterUpdateEvent) throws Exception {
        this.masterDataSet.getStorageDataSet().getRowData(this.masterDataSet, this.masterDataSet.row(), this.masterRow);
        this.copyMasterRowToDetailRow(this.masterRow, this.detailRow);
        if (this.detailDataSetView.locate(this.detailRow, 32)) {
            ValidationException.throwCannotOrphanDetails();
        }
    }

    public final void masterChanging(MasterUpdateEvent masterUpdateEvent) throws Exception {
        int n;
        this.detailDataSet.post();
        this.masterDataSet.getStorageDataSet().getRowData(this.masterDataSet, this.masterDataSet.row(), this.masterRow);
        ReadRow readRow = masterUpdateEvent.getChangingRow();
        if (readRow.columnList.hasScopedColumns()) {
            n = 0;
            for (int i = 0; i < this.masterLinkColumns.length; ++i) {
                if (readRow.hasColumn(this.masterLinkColumns[i]) == null) continue;
                ++n;
            }
        } else {
            n = this.masterLinkColumns.length;
        }
        if (!(n == 0 || n == this.masterLinkColumns.length && masterUpdateEvent.getChangingRow().equals(this.masterRow))) {
            this.copyMasterRowToDetailRow(this.masterRow, this.detailRow);
            if (this.detailDataSetView.locate(this.detailRow, 32)) {
                ValidationException.throwCannotOrphanDetails();
            }
        }
    }
}

