/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.NullState;
import borland.jbcl.util.Variant;

class LongColumn
extends DataColumn {
    long result;
    long[] vector = new long[16];

    public LongColumn(NullState nullState) {
        super(nullState);
        this.vectorLength = this.vector.length;
    }

    void copy(int n, int n2) {
        this.vector[n2] = this.vector[n];
        if (this.hasNulls) {
            this.nullState.copy(n, n2, this.nullMask);
        }
    }

    protected void grow(int n) {
        long[] lArray = new long[n];
        System.arraycopy(this.vector, 0, lArray, 0, this.vectorLength);
        this.vector = lArray;
        this.vectorLength = this.vector.length;
    }

    int compare(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        this.result = this.vector[n] - this.vector[n2];
        if (this.result < (long)0) {
            return -1;
        }
        if (this.result > (long)0) {
            return 1;
        }
        return 0;
    }

    int compareIgnoreCase(int n, int n2) {
        return this.compare(n, n2);
    }

    void getVariant(int n, Variant variant) {
        if (this.hasNulls && (this.nullState.vector[n] & this.nullMask) != 0) {
            this.nullState.getNull(n, variant, this.nullMask, this.assignedMask);
        } else {
            variant.setLong(this.vector[n]);
        }
    }

    void setVariant(int n, Variant variant) {
        if (variant.isNull()) {
            this.vector[n] = Long.MAX_VALUE;
            this.setNull(n, variant.getType());
        } else {
            if (this.hasNulls) {
                int n2 = n;
                this.nullState.vector[n2] = (byte)(this.nullState.vector[n2] & ~this.nullMask);
            }
            this.vector[n] = variant.getLong();
        }
    }
}

