/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnList;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.ReadWriteRow;
import borland.jbcl.dataset.Res;
import borland.jbcl.dataset.RowVariant;
import borland.jbcl.util.Variant;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class ReadRow {
    ColumnList columnList;
    protected RowVariant[] rowValues;

    Variant getVariantStorage(String string) throws DataSetException {
        return this.rowValues[this.columnList.getOrdinal(string)];
    }

    Variant getVariantStorage(int n) throws DataSetException {
        return this.rowValues[this.columnList.getScopedColumns()[n].ordinal];
    }

    public void getVariant(int n, Variant variant) throws DataSetException {
        variant.setVariant(this.getVariantStorage(n));
    }

    public void getVariant(String string, Variant variant) throws DataSetException {
        variant.setVariant(this.getVariantStorage(string));
    }

    public final byte getByte(String string) throws DataSetException {
        return this.getVariantStorage(string).getByte();
    }

    public final short getShort(String string) throws DataSetException {
        return this.getVariantStorage(string).getShort();
    }

    public final int getInt(String string) throws DataSetException {
        return this.getVariantStorage(string).getInt();
    }

    public final long getLong(String string) throws DataSetException {
        return this.getVariantStorage(string).getLong();
    }

    public final boolean getBoolean(String string) throws DataSetException {
        return this.getVariantStorage(string).getBoolean();
    }

    public final double getDouble(String string) throws DataSetException {
        return this.getVariantStorage(string).getDouble();
    }

    public final float getFloat(String string) throws DataSetException {
        return this.getVariantStorage(string).getFloat();
    }

    public final String getString(String string) throws DataSetException {
        return this.getVariantStorage(string).getString();
    }

    public final BigDecimal getBigDecimal(String string) throws DataSetException {
        return this.getVariantStorage(string).getBigDecimal();
    }

    public final Date getDate(String string) throws DataSetException {
        return this.getVariantStorage(string).getDate();
    }

    public final Time getTime(String string) throws DataSetException {
        return this.getVariantStorage(string).getTime();
    }

    public final Timestamp getTimestamp(String string) throws DataSetException {
        return this.getVariantStorage(string).getTimestamp();
    }

    public final InputStream getBinaryStream(String string) throws DataSetException {
        return this.getVariantStorage(string).getBinaryStream();
    }

    public final byte[] getByteArray(String string) throws DataSetException {
        return this.getVariantStorage(string).getByteArray();
    }

    public final int getArrayLength(String string) throws DataSetException {
        return this.getVariantStorage(string).getArrayLength();
    }

    public final Object getObject(String string) throws DataSetException {
        return this.getVariantStorage(string).getObject();
    }

    public final boolean isNull(String string) throws DataSetException {
        return this.getVariantStorage(string).isNull();
    }

    public final boolean isAssignedNull(String string) throws DataSetException {
        return this.getVariantStorage(string).isAssignedNull();
    }

    public final boolean isUnassignedNull(String string) throws DataSetException {
        return this.getVariantStorage(string).isUnassignedNull();
    }

    public final String format(String string) throws DataSetException {
        Column column = this.getColumn(string);
        return column.format(this.getVariantStorage(column.getOrdinal()));
    }

    public final byte getByte(int n) throws DataSetException {
        return this.getVariantStorage(n).getByte();
    }

    public final int getShort(int n) throws DataSetException {
        return this.getVariantStorage(n).getShort();
    }

    public final int getInt(int n) throws DataSetException {
        return this.getVariantStorage(n).getInt();
    }

    public final long getLong(int n) throws DataSetException {
        return this.getVariantStorage(n).getLong();
    }

    public final boolean getBoolean(int n) throws DataSetException {
        return this.getVariantStorage(n).getBoolean();
    }

    public final float getFloat(int n) throws DataSetException {
        return this.getVariantStorage(n).getFloat();
    }

    public final double getDouble(int n) throws DataSetException {
        return this.getVariantStorage(n).getDouble();
    }

    public final String getString(int n) throws DataSetException {
        return this.getVariantStorage(n).getString();
    }

    public final BigDecimal getBigDecimal(int n) throws DataSetException {
        return this.getVariantStorage(n).getBigDecimal();
    }

    public final Date getDate(int n) throws DataSetException {
        return this.getVariantStorage(n).getDate();
    }

    public final Time getTime(int n) throws DataSetException {
        return this.getVariantStorage(n).getTime();
    }

    public final Timestamp getTimestamp(int n) throws DataSetException {
        return this.getVariantStorage(n).getTimestamp();
    }

    public final InputStream getBinaryStream(int n) throws DataSetException {
        return this.getVariantStorage(n).getBinaryStream();
    }

    public final byte[] getByteArray(int n) throws DataSetException {
        return this.getVariantStorage(n).getByteArray();
    }

    public final Object getObject(int n) throws DataSetException {
        return this.getVariantStorage(n).getObject();
    }

    public final boolean isNull(int n) throws DataSetException {
        return this.getVariantStorage(n).isNull();
    }

    public final boolean isAssignedNull(int n) throws DataSetException {
        return this.getVariantStorage(n).isAssignedNull();
    }

    public final boolean isUnassignedNull(int n) throws DataSetException {
        return this.getVariantStorage(n).isUnassignedNull();
    }

    public final String format(int n) throws DataSetException {
        return this.getColumn(n).format(this.getVariantStorage(n));
    }

    public final Column getColumn(int n) throws DataSetException {
        return this.columnList.getScopedColumns()[n];
    }

    public final int getColumnCount() {
        if (this.columnList != null) {
            return this.columnList.columnCount();
        }
        return 0;
    }

    public final int columnCount() {
        return this.getColumnCount();
    }

    public final Column getColumn(String string) throws DataSetException {
        return this.columnList.getColumn(string);
    }

    public final Column hasColumn(String string) {
        if (this.columnList != null) {
            return this.columnList.hasColumn(string);
        }
        return null;
    }

    final ColumnList getColumnList() {
        return this.columnList;
    }

    final Variant[] getRowValues(ColumnList columnList) throws DataSetException {
        if (columnList.columns != this.columnList.columns) {
            DataSetException.throwIncompatibleDataRow();
        }
        return this.rowValues;
    }

    public static void copyTo(String[] stringArray, ReadRow readRow, String[] stringArray2, ReadWriteRow readWriteRow) throws DataSetException {
        for (int i = 0; i < stringArray.length; ++i) {
            readWriteRow.setVariant(stringArray2[i], readRow.getVariantStorage(stringArray[i]));
        }
    }

    public void copyTo(ReadWriteRow readWriteRow) throws DataSetException {
        Column[] columnArray = readWriteRow.columnList.getScopedColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            readWriteRow.setVariant(i, this.getVariantStorage(columnArray[i].getColumnName()));
        }
    }

    public final boolean equals(ReadRow readRow) throws DataSetException {
        Column[] columnArray = readRow.columnList.getScopedColumns();
        if (columnArray == this.columnList.columns) {
            for (int i = 0; i < columnArray.length; ++i) {
                int n = columnArray[i].ordinal;
                if (this.getVariantStorage(n).equals(readRow.getVariantStorage(n))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            if (this.getVariantStorage(column.getColumnName()).equals(readRow.getVariantStorage(i))) continue;
            return false;
        }
        return true;
    }

    public final int findDifference(int n, ReadRow readRow) throws DataSetException {
        if (readRow.columnList.getScopedColumns() != this.columnList.getScopedColumns()) {
            DataSetException.throwIncompatibleDataRow();
        }
        Column[] columnArray = readRow.columnList.getScopedColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            int n2 = columnArray[i].ordinal;
            if (this.getVariantStorage(n2).equals(readRow.getVariantStorage(n2))) continue;
            return n2;
        }
        return -1;
    }

    String formatRowValues() {
        Column[] columnArray;
        String string = null;
        if (this.columnList != null && (columnArray = this.columnList.getScopedColumns()) != null) {
            for (int i = 0; i < columnArray.length; ++i) {
                String string2 = columnArray[i].getColumnName();
                try {
                    string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(string == null ? "" : string).concat(String.valueOf(":"))).concat(String.valueOf(string2))).concat(String.valueOf("="))).concat(String.valueOf(string2 != null && this.getVariantStorage(string2) != null ? this.getVariantStorage(string2).toString() : ""));
                    continue;
                }
                catch (DataSetException dataSetException) {
                    break;
                }
            }
        }
        return string;
    }

    public String toString() {
        String string = this.formatRowValues();
        if (string == null) {
            string = String.valueOf(":").concat(String.valueOf(Res.getString(69)));
        }
        return String.valueOf(super.toString()).concat(String.valueOf(string));
    }
}

