/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.NullState;
import borland.jbcl.util.Variant;

class ShortColumn
extends DataColumn {
    short[] vector = new short[16];

    public ShortColumn(NullState nullState) {
        super(nullState);
        this.vectorLength = this.vector.length;
    }

    final void copy(int n, int n2) {
        this.vector[n2] = this.vector[n];
        if (this.hasNulls) {
            this.nullState.copy(n, n2, this.nullMask);
        }
    }

    protected final void grow(int n) {
        short[] sArray = new short[n];
        System.arraycopy(this.vector, 0, sArray, 0, this.vectorLength);
        this.vector = sArray;
        this.vectorLength = this.vector.length;
    }

    final int compare(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        return this.vector[n] - this.vector[n2];
    }

    final int compareIgnoreCase(int n, int n2) {
        return this.compare(n, n2);
    }

    final void getVariant(int n, Variant variant) {
        if (this.hasNulls && (this.nullState.vector[n] & this.nullMask) != 0) {
            this.nullState.getNull(n, variant, this.nullMask, this.assignedMask);
        } else {
            variant.setShort(this.vector[n]);
        }
    }

    final void setVariant(int n, Variant variant) {
        if (variant.isNull()) {
            this.vector[n] = Short.MAX_VALUE;
            this.setNull(n, variant.getType());
        } else {
            if (this.hasNulls) {
                int n2 = n;
                this.nullState.vector[n2] = (byte)(this.nullState.vector[n2] & ~this.nullMask);
            }
            this.vector[n] = variant.getShort();
        }
    }
}

