/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetModel;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.model.SingletonModelListener;
import borland.jbcl.model.SingletonViewManager;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.EventMulticaster;
import java.awt.Component;
import java.awt.Insets;

public class SingletonDataSetManager
implements WritableSingletonModel,
SingletonViewManager,
NavigationListener,
DataChangeListener {
    private DataSetModel dataSetModel;
    private boolean events = true;
    private SingletonModelEvent singletonModelEvent = new SingletonModelEvent(this);
    private EventMulticaster modelListeners = new EventMulticaster();

    public SingletonDataSetManager(DataSet dataSet, Column column, Component component, int n, Insets insets) {
        this.dataSetModel = new DataSetModel(dataSet, column, component, n, insets);
        dataSet.addDataChangeListener(this);
        dataSet.addNavigationListener(this);
    }

    public SingletonDataSetManager(DataSet dataSet, Column column) {
        this(dataSet, column, null, 0, null);
    }

    public Object get() {
        return this.dataSetModel.get();
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelListeners.add(singletonModelListener);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelListeners.remove(singletonModelListener);
    }

    public boolean canSet(boolean bl) {
        return this.dataSetModel.canSet(bl);
    }

    public void set(Object object) {
        this.dataSetModel.set(object);
        this.processModelEvent();
    }

    public void touched() {
        this.processModelEvent();
    }

    public void enableModelEvents(boolean bl) {
        if (this.events != bl) {
            this.events = bl;
            if (bl) {
                this.processModelEvent();
            }
        }
    }

    public ItemPainter getPainter(Object object, int n) {
        return this.dataSetModel.painter;
    }

    public ItemEditor getEditor(Object object, int n) {
        return this.dataSetModel.editor;
    }

    protected void processModelEvent() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(this.singletonModelEvent);
        }
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        this.processModelEvent();
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.processModelEvent();
    }
}

