/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.util.ImageLoader;
import borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;

public class ImageItemPainter
implements ItemPainter {
    protected Component component;
    protected int alignment;
    private boolean streamResetError;

    public ImageItemPainter(Component component) {
        this(component, 68);
    }

    public ImageItemPainter(Component component, int n) {
        this.component = component;
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        if ((n & 0xF0) < 0 || (n & 0xF0) > 64) {
            throw new IllegalArgumentException(Res.format(1, new Integer[]{new Integer(n & 0xF0)}));
        }
        if ((n & 0xF) < 0 || (n & 0xF) > 4) {
            throw new IllegalArgumentException(Res.format(2, new Integer[]{new Integer(n & 0xF)}));
        }
        this.alignment = n;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Image image = this.getImage(object, n);
        return image == null ? new Dimension() : new Dimension(image.getWidth(this.component), image.getHeight(this.component));
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        Color color;
        Image image = this.getImage(object, n);
        Color color2 = graphics.getColor();
        Color color3 = color = itemPaintSite != null ? itemPaintSite.getBackground() : null;
        if (color != null) {
            graphics.setColor(color);
        }
        if (image == null || this.streamResetError) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.streamResetError) {
                graphics.setColor(SystemColor.windowText);
                graphics.drawString(Res.getString(9), rectangle.x, rectangle.y);
            }
        } else {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = image.getWidth(this.component);
            int n8 = image.getHeight(this.component);
            int n9 = n6 = itemPaintSite != null ? itemPaintSite.getAlignment() : this.alignment;
            if (n6 == 0) {
                n6 = this.alignment;
            }
            switch (n6 & 0xF) {
                default: {
                    n5 = rectangle.x;
                    n4 = n7;
                    break;
                }
                case 2: {
                    n5 = rectangle.x + (rectangle.width - n7) / 2;
                    n4 = n7;
                    break;
                }
                case 3: {
                    n5 = rectangle.x + rectangle.width - n7;
                    n4 = n7;
                    break;
                }
                case 4: {
                    n5 = rectangle.x;
                    n4 = rectangle.width;
                }
            }
            switch (n6 & 0xF0) {
                default: {
                    n3 = rectangle.y;
                    n2 = n8;
                    break;
                }
                case 32: {
                    n3 = rectangle.y + (rectangle.height - n8) / 2;
                    n2 = n8;
                    break;
                }
                case 48: {
                    n3 = rectangle.y + rectangle.height - n8;
                    n2 = n8;
                    break;
                }
                case 64: {
                    n3 = rectangle.y;
                    n2 = rectangle.height;
                }
            }
            try {
                graphics.drawImage(image, n5, n3, n4, n2, this.component);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (n5 > rectangle.x) {
                graphics.fillRect(rectangle.x, rectangle.y, n5 - rectangle.x, rectangle.height);
            }
            if (n3 > rectangle.y) {
                graphics.fillRect(Math.max(n5, rectangle.x), rectangle.y, n4, n3 - rectangle.y);
            }
            if (n5 + n4 < rectangle.x + rectangle.width) {
                graphics.fillRect(n5 + n4, rectangle.y, rectangle.x + rectangle.width - n5 - n4, rectangle.height);
            }
            if (n3 + n2 < rectangle.y + rectangle.height) {
                graphics.fillRect(n5, n3 + n2, n4, rectangle.y + rectangle.height - n3 - n2);
            }
        }
        graphics.setColor(color2);
    }

    protected Image getImage(Object object, int n) {
        Image image;
        if (object == null) {
            return null;
        }
        this.streamResetError = false;
        if (object instanceof Image) {
            image = (Image)object;
        } else {
            try {
                image = ImageLoader.loadFromBlob(object, this.component);
            }
            catch (IOException iOException) {
                this.streamResetError = true;
                image = null;
            }
        }
        if (image == null) {
            return null;
        }
        if ((n & 1) != 0) {
            return ImageLoader.getDisabledImage(this.component, image);
        }
        return image;
    }
}

