/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemFormatter;
import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.Variant;
import borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class TextItemPainter
implements ItemPainter {
    protected boolean checkDisabled;
    int alignment;
    Insets margins;
    ItemFormatter formatter;
    Color foreground = SystemColor.controlText;

    public TextItemPainter(int n, Insets insets, ItemFormatter itemFormatter) {
        this.setAlignment(n);
        this.margins = insets;
        this.formatter = itemFormatter;
    }

    public TextItemPainter(int n, Insets insets, boolean bl) {
        this(n, insets, null);
        this.checkDisabled = bl;
    }

    public TextItemPainter(int n, Insets insets) {
        this(n, insets, false);
    }

    public TextItemPainter(int n) {
        this(n, new Insets(1, 1, 1, 1));
    }

    public TextItemPainter() {
        this(33);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        if ((this.alignment & 0xF0) < 0 || (this.alignment & 0xF0) > 48) {
            throw new IllegalArgumentException(Res.format(1, new Integer[]{new Integer(this.alignment & 0xF0)}));
        }
        if ((this.alignment & 0xF) < 0 || (this.alignment & 0xF) > 3) {
            throw new IllegalArgumentException(Res.format(2, new Integer[]{new Integer(this.alignment & 0xF)}));
        }
        this.alignment = n;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets insets) {
        this.margins = insets;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public boolean isCheckDisabled() {
        return this.checkDisabled;
    }

    public void setCheckDisabled(boolean bl) {
        this.checkDisabled = bl;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Font font;
        if (graphics == null) {
            return new Dimension(0, 0);
        }
        Font font2 = graphics.getFont();
        Font font3 = font = itemPaintSite != null ? itemPaintSite.getFont() : graphics.getFont();
        if (font == null) {
            font = graphics.getFont();
        }
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        String string = this.getText(object);
        Insets insets = itemPaintSite != null ? itemPaintSite.getItemMargins() : this.margins;
        graphics.setFont(font2);
        return new Dimension(insets.left + insets.right + fontMetrics.stringWidth(string), insets.top + insets.bottom + fontMetrics.getHeight());
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        int n2;
        int n3;
        int n4;
        Insets insets;
        Font font;
        Font font2 = graphics.getFont();
        Color color = graphics.getColor();
        Font font3 = font = itemPaintSite != null ? itemPaintSite.getFont() : graphics.getFont();
        if (font == null) {
            font = graphics.getFont();
        }
        graphics.setFont(font);
        Insets insets2 = insets = itemPaintSite != null ? itemPaintSite.getItemMargins() : this.margins;
        if (insets == null) {
            insets = this.margins;
        }
        int n5 = n4 = itemPaintSite != null ? itemPaintSite.getAlignment() : this.alignment;
        if (n4 == 0) {
            n4 = this.alignment;
        }
        String string = this.getText(object);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        switch (n4 & 0xF) {
            default: {
                n3 = insets.left;
                break;
            }
            case 2: {
                n3 = (rectangle.width - fontMetrics.stringWidth(string)) / 2;
                break;
            }
            case 3: {
                n3 = rectangle.width - fontMetrics.stringWidth(string) - insets.right;
            }
        }
        switch (n4 & 0xF0) {
            default: {
                n2 = insets.top;
                break;
            }
            case 32: {
                n2 = (rectangle.height - fontMetrics.getHeight()) / 2;
                break;
            }
            case 48: {
                n2 = rectangle.height - insets.bottom - fontMetrics.getHeight();
            }
        }
        n2 += fontMetrics.getLeading() + fontMetrics.getAscent();
        graphics.setColor(this.getBackground(object, graphics, n, itemPaintSite));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (string != null) {
            if (this.checkDisabled && (n & 1) != 0) {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawString(string, rectangle.x + n3 + 1, rectangle.y + n2 + 1);
                graphics.setColor(SystemColor.controlShadow);
            } else {
                graphics.setColor(this.getForeground(object, graphics, n, itemPaintSite));
            }
            graphics.drawString(string, rectangle.x + n3, rectangle.y + n2);
        }
        graphics.setFont(font2);
        graphics.setColor(color);
    }

    protected String getText(Object object) {
        if (object != null) {
            if (this.formatter != null && object instanceof Variant) {
                try {
                    String string = this.formatter.format(object);
                    return string;
                }
                catch (InvalidFormatException invalidFormatException) {
                    String string = "";
                    return string;
                }
            }
            return object.toString();
        }
        return "";
    }

    protected Color getBackground(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Color color;
        Color color2 = color = itemPaintSite != null ? itemPaintSite.getBackground() : graphics.getColor();
        if (color == null) {
            color = graphics.getColor();
        }
        return color;
    }

    protected Color getForeground(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Color color;
        Color color2 = color = itemPaintSite != null ? itemPaintSite.getForeground() : this.foreground;
        if (color == null) {
            color = this.foreground;
        }
        return color;
    }
}

