/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class LogWriter {
    public static int TRACE_NONE = 0;
    public static int TRACE_MESSAGES = 16;
    public static int TRACE_EXCEPTION = 17;
    public static int TRACE_DEBUG = 32;
    private String logFileName = "debuglog.txt";
    public PrintWriter printWriter;
    public PrintStream traceWriter = System.out;
    public static boolean needsLogging = false;
    public int lineCount;
    protected static int traceLevel = TRACE_NONE;

    public void logStackTrace() {
        if (needsLogging) {
            this.checkLogFile();
            if (this.printWriter != null) {
                this.println("------------ Traceback ------");
                this.logException(new Exception());
                this.println("----------- End Traceback ------");
            }
        }
    }

    public void logException(Exception ex) {
        if (needsLogging) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.checkLogFile();
            if (this.printWriter != null) {
                ex.printStackTrace(pw);
            }
            this.println(sw.toString());
        }
    }

    public void logTrace(Throwable sframe) {
        if (needsLogging) {
            this.checkLogFile();
            this.logException(new Exception(sframe.getMessage()));
        }
    }

    public void setLogFileName(String name) {
        this.logFileName = name;
    }

    public synchronized void logMessage(String message, String logFileName) {
        if (needsLogging) {
            try {
                File logFile = new File(logFileName);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                    this.printWriter = null;
                }
                FileWriter fw = new FileWriter(logFileName, true);
                PrintWriter printWriter = new PrintWriter((Writer)fw, true);
                printWriter.println(" ---------------------------------------------- ");
                printWriter.println(message);
                printWriter.close();
                fw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void checkLogFile() {
        if (!needsLogging) {
            return;
        }
        if (this.printWriter != null) {
            return;
        }
        if (this.logFileName == null) {
            return;
        }
        try {
            File logFile = new File(this.logFileName);
            if (!logFile.exists()) {
                logFile.createNewFile();
                this.printWriter = null;
            }
            if (this.printWriter == null) {
                FileWriter fw = new FileWriter(this.logFileName, true);
                this.printWriter = new PrintWriter((Writer)fw, true);
                this.printWriter.println("<debug>");
                this.printWriter.println("<![C1DATA[ ");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void println(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) != '\n') continue;
            ++this.lineCount;
        }
        this.checkLogFile();
        if (this.printWriter != null) {
            this.printWriter.println(message);
        }
        ++this.lineCount;
    }

    public void logMessage(String message) {
        if (!needsLogging) {
            return;
        }
        this.checkLogFile();
        this.println(message);
    }

    public void setTraceLevel(int level) {
        traceLevel = level;
    }

    public int getTraceLevel() {
        return traceLevel;
    }
}

