/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Utils {
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    public static String getQuotedString(String str) {
        return '\"' + str + '\"';
    }

    protected static String reduceString(String input) {
        String newString = input.toLowerCase();
        int len = newString.length();
        String retval = "";
        for (int i = 0; i < len; ++i) {
            if (newString.charAt(i) == ' ' || newString.charAt(i) == '\t') continue;
            retval = retval + newString.charAt(i);
        }
        return retval;
    }

    public static String generateCallIdentifier(String address) {
        String date = new Long(System.currentTimeMillis()).toString() + new Double(Math.random()).toString();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] cid = messageDigest.digest(date.getBytes());
            String cidString = Utils.toHexString(cid);
            return cidString + "@" + address;
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public static String generateTag() {
        return new Integer((int)(Math.random() * 10000.0)).toString();
    }

    public static String generateBranchId() {
        String b = new Integer((int)(Math.random() * 10000.0)).toString() + System.currentTimeMillis();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bid = messageDigest.digest(b.getBytes());
            return "z9hG4bK" + Utils.toHexString(bid);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }
}

