/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.RetryAfterHeader;

public class RetryAfter
extends ParametersHeader
implements RetryAfterHeader {
    public static final String DURATION = "duration";
    protected Integer retryAfter;
    protected String comment;

    public RetryAfter() {
        super("Retry-After");
    }

    public String encodeBody() {
        StringBuffer s = new StringBuffer();
        if (this.retryAfter != null) {
            s.append(this.retryAfter);
        }
        if (this.comment != null) {
            s.append(" (" + this.comment + ")");
        }
        if (!this.parameters.isEmpty()) {
            s.append(";" + this.parameters.encode());
        }
        return s.toString();
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removeComment() {
        this.comment = null;
    }

    public void removeDuration() {
        super.removeParameter(DURATION);
    }

    public void setRetryAfter(int retryAfter) throws InvalidArgumentException {
        if (retryAfter < 0) {
            throw new InvalidArgumentException("invalid parameter " + retryAfter);
        }
        this.retryAfter = new Integer(retryAfter);
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) throws ParseException {
        if (comment == null) {
            throw new NullPointerException("the comment parameter is null");
        }
        this.comment = comment;
    }

    public void setDuration(int duration) throws InvalidArgumentException {
        if (duration < 0) {
            throw new InvalidArgumentException("the duration parameter is <0");
        }
        super.setParameter(DURATION, new Integer(duration));
    }

    public int getDuration() {
        return super.getParameterAsInt(DURATION);
    }
}

