/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.StunAddress;
import net.java.stun4j.stack.ErrorHandler;
import net.java.stun4j.stack.MessageQueue;
import net.java.stun4j.stack.RawMessage;

class NetAccessPoint
implements Runnable {
    private static final int MAX_DATAGRAM_SIZE = 8192;
    private MessageQueue messageQueue = null;
    protected DatagramSocket sock;
    private boolean isUsingExternalSocket = false;
    private boolean isRunning;
    private NetAccessPointDescriptor apDescriptor = null;
    private ErrorHandler errorHandler = null;

    NetAccessPoint() {
    }

    NetAccessPoint(NetAccessPointDescriptor apDescriptor, MessageQueue messageQueue, ErrorHandler errorHandler) {
        this.apDescriptor = apDescriptor;
        this.messageQueue = messageQueue;
        this.errorHandler = errorHandler;
    }

    void start() throws IOException {
        if (this.sock == null) {
            this.sock = new DatagramSocket(this.getDescriptor().getAddress().getSocketAddress());
            this.isUsingExternalSocket = false;
        }
        this.sock.setReceiveBufferSize(8192);
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    NetAccessPointDescriptor getDescriptor() {
        return this.apDescriptor;
    }

    public void run() {
        while (this.isRunning) {
            try {
                int bufsize = this.sock.getReceiveBufferSize();
                byte[] message = new byte[bufsize];
                DatagramPacket packet = new DatagramPacket(message, bufsize);
                this.sock.receive(packet);
                RawMessage rawMessage = new RawMessage(message, packet.getLength(), packet.getAddress(), packet.getPort(), this.getDescriptor());
                this.messageQueue.add(rawMessage);
            }
            catch (SocketException ex) {
                if (!this.isRunning) continue;
                System.err.println("A net access point has gone useless:");
                ex.printStackTrace();
                this.stop();
                this.errorHandler.handleFatalError(this, "A socket exception was thrown while trying to receive a message.", ex);
            }
            catch (IOException ex) {
                System.err.println("A net access point has gone useless:");
                ex.printStackTrace();
                this.errorHandler.handleError(ex.getMessage(), ex);
            }
            catch (Throwable ex) {
                System.err.println("A net access point has gone useless:");
                ex.printStackTrace();
                this.stop();
                this.errorHandler.handleFatalError(this, "Unknown error occurred while listening for messages!", ex);
            }
        }
    }

    void stop() {
        this.isRunning = false;
        if (this.sock != null && !this.isUsingExternalSocket) {
            this.sock.close();
        }
    }

    void sendMessage(byte[] message, StunAddress address) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(message, 0, message.length, address.getSocketAddress());
        this.sock.send(datagramPacket);
    }

    public String toString() {
        return "net.java.stun4j.stack.AccessPoint@" + this.apDescriptor.getAddress() + " status: " + (this.isRunning ? "not" : "") + " running";
    }

    void useExternalSocket(DatagramSocket socket) {
        this.sock = socket;
        this.isUsingExternalSocket = true;
    }
}

