/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sf.accolorhelper.ColorWithText;
import net.sf.accolorhelper.ui.AccolorHelperComponent;
import net.sf.accolorhelper.ui.ColorEditorComponent;

public class AccolorHelperMain {
    private ColorWithText[] aColors;
    private String aFilename;
    private boolean aHaveColorsBeenModified;
    private JFrame aFrame;
    private AccolorHelperComponent aColorComparatorComponent;
    private ResourceBundle aResources = ResourceBundle.getBundle(AccolorHelperMain.class.getName());

    public static void main(String[] pArguments) {
        AccolorHelperMain.changeToSystemLookAndFeel();
        try {
            ColorWithText[] lColors = AccolorHelperMain.parseColorStrings(pArguments);
            new AccolorHelperMain(lColors);
        }
        catch (NumberFormatException eNumberFormat) {
            ResourceBundle lResources = ResourceBundle.getBundle(AccolorHelperMain.class.getName());
            JOptionPane.showMessageDialog(null, lResources.getString("usage"), "AccolorHelper", 0);
        }
    }

    private static void changeToSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException eClassNotFound) {
        }
        catch (InstantiationException eInstantiation) {
        }
        catch (IllegalAccessException eIllegalAccess) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
    }

    private static ColorWithText[] parseColorStrings(String[] pStrings) {
        ColorWithText[] result = new ColorWithText[pStrings.length];
        for (int lColorIndex = 0; lColorIndex < pStrings.length; ++lColorIndex) {
            String lString = pStrings[lColorIndex];
            if (lString.matches("[0-9a-fA-F]{6} ?.*")) {
                Color lColor = new Color(Integer.parseInt(lString.substring(0, 6), 16));
                String lText = lString.substring(6);
                if (lText.startsWith(" ")) {
                    lText = lText.substring(1);
                }
                result[lColorIndex] = new ColorWithText(lColor, lText);
                continue;
            }
            result[lColorIndex] = new ColorWithText(Color.BLACK, lString);
        }
        return result;
    }

    private AccolorHelperMain(ColorWithText[] pColors) {
        this.localizeSwingDialogs();
        this.aColors = pColors;
        this.aFrame = new JFrame("AccolorHelper");
        this.aFrame.setDefaultCloseOperation(0);
        URL lLogoUrl = this.getClass().getResource("accolorhelper-logo.png");
        Image lLogo = this.aFrame.getToolkit().createImage(lLogoUrl);
        this.aFrame.setIconImage(lLogo);
        this.aFrame.setJMenuBar(this.createMenu());
        this.aColorComparatorComponent = new AccolorHelperComponent(this.getColorsOnly(pColors));
        this.aFrame.getContentPane().add(this.aColorComparatorComponent);
        this.aFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent pEvent) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent pEvent) {
                AccolorHelperMain.this.executeExit();
            }
        });
        this.aFrame.pack();
        this.aFrame.setVisible(true);
    }

    private void localizeSwingDialogs() {
        this.localizeColorChooser();
        this.localizeFileChooser();
        this.localizeOptionPane();
    }

    private void localizeColorChooser() {
        this.localizeSwing("JColorChooser", false);
    }

    private void localizeFileChooser() {
        this.localizeSwing("JFileChooser", true);
    }

    private void localizeOptionPane() {
        this.localizeSwing("JOptionPane", false);
    }

    private void localizeSwing(String pBundleName, boolean pShouldConvertIntegers) {
        ResourceBundle lResources = ResourceBundle.getBundle(AccolorHelperMain.class.getPackage().getName() + '.' + pBundleName);
        Enumeration<String> lKeysEnumeration = lResources.getKeys();
        while (lKeysEnumeration.hasMoreElements()) {
            String lKey = lKeysEnumeration.nextElement();
            String lValue = lResources.getString(lKey);
            if (pShouldConvertIntegers && lValue.matches("^[0-9]+$")) {
                UIManager.put(lKey, Integer.valueOf(lValue));
                continue;
            }
            UIManager.put(lKey, lValue);
        }
    }

    private JMenuBar createMenu() {
        JMenuBar result = new JMenuBar();
        result.add(this.createColorsMenu());
        return result;
    }

    private JMenu createColorsMenu() {
        JMenu result = new JMenu(this.aResources.getString("menu.colors"));
        this.setMnemonic(result, "menu.colors");
        result.add(this.createNewMenuItem());
        result.add(this.createEditMenuItem());
        result.add(this.createOpenMenuItem());
        result.add(this.createSaveMenuItem());
        result.add(this.createSaveAsMenuItem());
        result.addSeparator();
        result.add(this.createExitMenuItem());
        return result;
    }

    private JMenuItem createNewMenuItem() {
        JMenuItem result = new JMenuItem(this.aResources.getString("menuitem.new"));
        this.setMnemonic(result, "menuitem.new");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                AccolorHelperMain.this.executeNew();
            }
        });
        return result;
    }

    private JMenuItem createEditMenuItem() {
        JMenuItem result = new JMenuItem(this.aResources.getString("menuitem.edit"));
        this.setMnemonic(result, "menuitem.edit");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                AccolorHelperMain.this.executeEdit();
            }
        });
        return result;
    }

    private JMenuItem createOpenMenuItem() {
        JMenuItem result = new JMenuItem(this.aResources.getString("menuitem.open"));
        this.setMnemonic(result, "menuitem.open");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                AccolorHelperMain.this.executeOpen();
            }
        });
        return result;
    }

    private JMenuItem createSaveMenuItem() {
        JMenuItem result = new JMenuItem(this.aResources.getString("menuitem.save"));
        this.setMnemonic(result, "menuitem.save");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                AccolorHelperMain.this.executeSave();
            }
        });
        return result;
    }

    private JMenuItem createSaveAsMenuItem() {
        JMenuItem result = new JMenuItem(this.aResources.getString("menuitem.saveas"));
        this.setMnemonic(result, "menuitem.saveas");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                AccolorHelperMain.this.executeSaveAs();
            }
        });
        return result;
    }

    private JMenuItem createExitMenuItem() {
        JMenuItem result = new JMenuItem(this.aResources.getString("menuitem.exit"));
        this.setMnemonic(result, "menuitem.exit");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                AccolorHelperMain.this.executeExit();
            }
        });
        return result;
    }

    private void setMnemonic(JMenuItem pMenuItem, String pBaseKey) {
        int lMnemonic = this.getMnemonic(pBaseKey);
        if (lMnemonic != 0) {
            pMenuItem.setMnemonic(lMnemonic);
        }
    }

    private int getMnemonic(String lBaseKey) {
        int result = 0;
        String lMnemonic = this.aResources.getString(lBaseKey + ".mnemonic");
        if (lMnemonic != null && lMnemonic.length() > 0) {
            result = lMnemonic.charAt(0);
        }
        return result;
    }

    private void executeNew() {
        boolean lDidUserDiscardChanges = this.checkLossOfChanges("newcolors");
        if (lDidUserDiscardChanges) {
            this.aColors = new ColorWithText[0];
            this.aHaveColorsBeenModified = false;
            this.aColorComparatorComponent.setColors(this.getColorsOnly(this.aColors));
        }
    }

    private void executeEdit() {
        ColorEditorComponent lColorEditorComponent = new ColorEditorComponent(this.aColors);
        if (JOptionPane.showConfirmDialog(this.aFrame, lColorEditorComponent, this.getTitle("editcolors"), 2, -1) == 0 && lColorEditorComponent.haveColorsBeenModified()) {
            List<ColorWithText> lNewColors = lColorEditorComponent.getColors();
            this.aColors = lNewColors.toArray(new ColorWithText[lNewColors.size()]);
            this.aHaveColorsBeenModified = true;
            this.aColorComparatorComponent.setColors(this.getColorsOnly(this.aColors));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOpen() {
        boolean lDidUserDiscardChanges = this.checkLossOfChanges("opencolors");
        if (lDidUserDiscardChanges) {
            File lDirectory = this.getDirectoryForFileDialogs();
            JFileChooser lOpenDialog = new JFileChooser(lDirectory);
            lOpenDialog.setDialogTitle(this.getTitle("opencolors"));
            lOpenDialog.setDialogType(0);
            if (lOpenDialog.showOpenDialog(this.aFrame) == 0) {
                File lFile = lOpenDialog.getSelectedFile();
                try {
                    FileReader lFileReader = new FileReader(lFile);
                    try {
                        BufferedReader lBufferedReader = new BufferedReader(lFileReader);
                        try {
                            ArrayList<String> lLines = new ArrayList<String>();
                            String lLine = lBufferedReader.readLine();
                            while (lLine != null) {
                                lLines.add(lLine);
                                lLine = lBufferedReader.readLine();
                            }
                            String[] lStrings = lLines.toArray(new String[lLines.size()]);
                            this.aColors = AccolorHelperMain.parseColorStrings(lStrings);
                            this.aFilename = lFile.getAbsolutePath();
                            this.aHaveColorsBeenModified = false;
                            this.aColorComparatorComponent.setColors(this.getColorsOnly(this.aColors));
                        }
                        finally {
                            lBufferedReader.close();
                        }
                    }
                    finally {
                        lFileReader.close();
                    }
                }
                catch (FileNotFoundException eFileNotFound) {
                    String lMessage = this.formatMessage("error.filenotfound", lFile.getName());
                    JOptionPane.showMessageDialog(this.aFrame, lMessage, this.getTitle("opencolors"), 0);
                }
                catch (IOException eIO) {
                    String lMessage = this.formatMessage("error.filereaderror", lFile.getName());
                    JOptionPane.showMessageDialog(this.aFrame, lMessage, this.getTitle("opencolors"), 0);
                }
                catch (NumberFormatException eNumberFormat) {
                    JOptionPane.showMessageDialog(this.aFrame, this.formatMessage("error.invaliddata", lFile.getName()), this.getTitle("opencolors"), 0);
                }
            }
        }
    }

    private String getTitle(String pTitleKey) {
        return "AccolorHelper - " + this.aResources.getString("title." + pTitleKey);
    }

    private String formatMessage(String pPatternKey, Object pFirst) {
        String lPattern = this.aResources.getString(pPatternKey);
        String result = MessageFormat.format(lPattern, pFirst);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSave() {
        if (this.aFilename == null) {
            File lDirectory = this.getDirectoryForFileDialogs();
            JFileChooser lSaveDialog = new JFileChooser(lDirectory){
                private static final long serialVersionUID = 1L;

                public void approveSelection() {
                    if (this.getSelectedFile().exists()) {
                        if (JOptionPane.showConfirmDialog(this, AccolorHelperMain.this.formatMessage("message.fileexists", this.getSelectedFile().getName()), AccolorHelperMain.this.getTitle("savecolors"), 0) == 0) {
                            super.approveSelection();
                        }
                    } else {
                        super.approveSelection();
                    }
                }
            };
            lSaveDialog.setDialogTitle(this.getTitle("savecolors"));
            lSaveDialog.setDialogType(1);
            if (lSaveDialog.showSaveDialog(this.aFrame) == 0) {
                this.aFilename = lSaveDialog.getSelectedFile().getAbsolutePath();
            }
        }
        if (this.aFilename != null) {
            try {
                FileWriter lFileWriter = new FileWriter(this.aFilename);
                try {
                    PrintWriter lPrintWriter = new PrintWriter(lFileWriter);
                    try {
                        for (int lColorIndex = 0; lColorIndex < this.aColors.length; ++lColorIndex) {
                            String lHexRgb = "00000" + Integer.toHexString(this.aColors[lColorIndex].getColor().getRGB() & 0xFFFFFF);
                            String lText = this.aColors[lColorIndex].getText();
                            if (0 < lText.length()) {
                                lText = " " + lText;
                            }
                            lPrintWriter.println(lHexRgb.substring(lHexRgb.length() - 6) + lText);
                        }
                    }
                    finally {
                        lPrintWriter.close();
                    }
                }
                finally {
                    lFileWriter.close();
                }
                this.aHaveColorsBeenModified = false;
            }
            catch (IOException eIO) {
                JOptionPane.showMessageDialog(this.aFrame, this.formatMessage("error.filewriteerror", new File(this.aFilename).getName()), this.getTitle("savecolors"), 0);
            }
        }
        return this.aFilename != null;
    }

    private void executeSaveAs() {
        String lOldFilename = this.aFilename;
        this.aFilename = null;
        if (!this.executeSave()) {
            this.aFilename = lOldFilename;
        }
    }

    private void executeExit() {
        boolean lDidUserDiscardChanges = this.checkLossOfChanges("exit");
        if (lDidUserDiscardChanges) {
            this.aFrame.dispose();
        }
    }

    private boolean checkLossOfChanges(String pTitleKey) {
        boolean result = true;
        if (this.aHaveColorsBeenModified) {
            String lArgument = this.aFilename == null ? this.aResources.getString("message.colorlist") : "'" + new File(this.aFilename).getName() + "'";
            int lConfirmationResult = JOptionPane.showConfirmDialog(this.aFrame, this.formatMessage("message.colorsmodified", lArgument), this.getTitle(pTitleKey), 1);
            switch (lConfirmationResult) {
                case 0: {
                    if (this.executeSave()) break;
                    result = false;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    private File getDirectoryForFileDialogs() {
        File result = this.aFilename == null ? new File(System.getProperty("user.home")) : new File(this.aFilename).getParentFile();
        return result;
    }

    private Color[] getColorsOnly(ColorWithText[] pColors) {
        Color[] result = new Color[pColors.length];
        for (int lColorWithTextIndex = 0; lColorWithTextIndex < pColors.length; ++lColorWithTextIndex) {
            ColorWithText lColorWithText = pColors[lColorWithTextIndex];
            result[lColorWithTextIndex] = lColorWithText.getColor();
        }
        return result;
    }
}

