/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import net.sf.accolorhelper.ui.CellMouseAdapter;

public class ColorCombinationsComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Color[] aColors;
    private boolean[][] aSelection;

    public ColorCombinationsComponent(Color[] pColors, boolean[][] pSelection) {
        this.aColors = pColors;
        this.aSelection = pSelection;
        this.addMouseListener(new CellMouseAdapter(){

            public void mouseClicked(MouseEvent pEvent) {
                if (this.isInCell(pEvent.getX(), pEvent.getY())) {
                    int lHorizontalCellIndex = this.getCellIndex(pEvent.getX());
                    int lVerticalCellIndex = this.getCellIndex(pEvent.getY());
                    if (lHorizontalCellIndex < ColorCombinationsComponent.this.aColors.length && lVerticalCellIndex < ColorCombinationsComponent.this.aColors.length) {
                        ((ColorCombinationsComponent)ColorCombinationsComponent.this).aSelection[lHorizontalCellIndex][lVerticalCellIndex] = !ColorCombinationsComponent.this.aSelection[lHorizontalCellIndex][lVerticalCellIndex];
                        ((ColorCombinationsComponent)ColorCombinationsComponent.this).aSelection[lVerticalCellIndex][lHorizontalCellIndex] = ColorCombinationsComponent.this.aSelection[lHorizontalCellIndex][lVerticalCellIndex];
                        ColorCombinationsComponent.this.repaint();
                    }
                }
            }
        });
    }

    public Dimension getMinimumSize() {
        return new Dimension(45 * this.aColors.length + 5, 45 * this.aColors.length + 5);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics pGraphics) {
        Color lForegroundColor = pGraphics.getColor();
        for (int lX = 0; lX < this.aColors.length; ++lX) {
            for (int lY = 0; lY < this.aColors.length; ++lY) {
                if (this.aSelection[lX][lY]) {
                    pGraphics.setColor(lForegroundColor);
                    pGraphics.fillRect(5 + lX * 45, 5 + lY * 45, 40, 40);
                    pGraphics.setColor(this.getBackground());
                    pGraphics.drawRect(5 + lX * 45 + 5 - 1, 5 + lY * 45 + 5 - 1, 31, 31);
                }
                pGraphics.setColor(this.aColors[lX]);
                pGraphics.fillRect(5 + lX * 45 + 5, 5 + lY * 45 + 5, 30, 30);
                pGraphics.setColor(this.aColors[lY]);
                pGraphics.fillRect(5 + lX * 45 + 12, 5 + lY * 45 + 12, 16, 16);
            }
        }
    }

    public void setColors(Color[] pColors, boolean[][] pSelection) {
        this.aColors = pColors;
        this.aSelection = pSelection;
        this.invalidate();
        this.repaint();
    }
}

